/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParamCheck {
    private static final Log LOG = LogFactory.getInstance(ParamCheck.class);
    private static final int MAX_PORT = 65535;
    private static final int REGION_MIN_LENGTH = 2;
    private static final int REGION_MAX_LENGTH = 256;
    private static final String REGION_REGEX = "^[0-9a-zA-Z-]{1,32}$";
    private static final String CONFIG_REGEX = "^[a-zA-Z0-9-_./]*$";

    public static boolean checkPort(String port) {
        boolean result = false;
        if (ParamCheck.checkStrNull(port)) {
            LOG.error((Object)"Port is null, checkPort failed.", "");
            return result;
        }
        try {
            int number = Integer.valueOf(port);
            result = ParamCheck.checkPort(number);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)e, "CheckPort failed.");
        }
        return result;
    }

    public static boolean checkPort(int port) {
        return port > 0 && 65535 >= port;
    }

    public static boolean checkIpAddress(String ip) {
        return ParamCheck.checkIPV4Address(ip) || ParamCheck.checkIPV6Address(ip);
    }

    public static boolean checkIPV4Address(String address) {
        return Ipv4AddressUtil.isIPv4Address((String)address);
    }

    public static boolean checkIPV6Address(String address) {
        return Ipv6AddressUtil.isIPv6Address((String)address);
    }

    public static boolean checkStrNull(String str) {
        return null == str || str.trim().isEmpty();
    }

    public static boolean checkIsPath(String path) {
        if (ParamCheck.checkStrNull(path)) {
            LOG.error((Object)"path is null, checkIsPath failed.", "");
            return false;
        }
        File file = new File(path);
        return file.exists() && file.isDirectory();
    }

    public static boolean checkUserName(String userName) {
        if (ParamCheck.checkStrNull(userName)) {
            LOG.error((Object)"userName is null, checkUserName failed.", "");
            return false;
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z]{4,10}$");
        Matcher matcher = pattern.matcher(Normalizer.normalize(userName, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    public static boolean checkValidConfig(String str) {
        if (ParamCheck.checkStrNull(str)) {
            LOG.error((Object)"Config is null, checkValidConfig failed.");
            return false;
        }
        Pattern pattern = Pattern.compile(CONFIG_REGEX);
        Matcher matcher = pattern.matcher(Normalizer.normalize(str, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    public static boolean checkDBParam(DataBaseInfo dbInfo) {
        boolean result = false;
        if (!ParamCheck.checkIpAddress(dbInfo.getDbHost())) {
            LOG.error((Object)"Db host is error.", "");
        } else if (!ParamCheck.checkPort(dbInfo.getDbPort())) {
            LOG.error((Object)"Db port is error.", "");
        } else if (!ParamCheck.checkUserName(dbInfo.getDbaUsername())) {
            LOG.error((Object)"Db username is error.", "");
        } else if (ParamCheck.checkStrNull(dbInfo.getDbaPassword())) {
            LOG.error((Object)"Db pwd is error.", "");
        } else if (!ParamCheck.checkUserName(dbInfo.getManagerUsername())) {
            LOG.error((Object)"Db manager username is error.", "");
        } else if (ParamCheck.checkStrNull(dbInfo.getManagerPassword())) {
            LOG.error((Object)"Db manager pwd is error.", "");
        } else if (ParamCheck.checkStrNull(dbInfo.getDbFilePath())) {
            LOG.error((Object)"Db file path is error.", "");
        } else if (ParamCheck.checkStrNull(dbInfo.getDbPath())) {
            LOG.error((Object)"Db path is error.", "");
        } else {
            result = true;
        }
        return result;
    }

    public static boolean checkRegion(String regionId) {
        if (ParamCheck.checkStrNull(regionId)) {
            return false;
        }
        if (regionId.length() < 2 || regionId.length() > 256) {
            return false;
        }
        Pattern pattern = Pattern.compile(REGION_REGEX);
        Matcher matcher = pattern.matcher(Normalizer.normalize(regionId, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    public static boolean checkRegExpression(String param, String regExpression) {
        return Pattern.matches(regExpression, param);
    }
}

