/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.certs.ChangeCertsPwd;
import com.huawei.lego.common.certs.ChangePrivateKeyPwd;
import com.huawei.lego.common.certs.PrivateKey;
import com.huawei.lego.common.cloud.VhaUpdateProcess;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.extend.IextendCallBack;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class UpdateUtil {
    private static final Log LOGGER = LogFactory.getInstance(UpdateUtil.class);
    private static final String INSTALL_PATH = InitInstalledXmlTool.getInstallPath();
    private static final String PASS = WccEncryptor.decode(LegoResourceManager.getProValue("default.gauss.mangement.password"));
    private static final String TMP_FILE = INSTALL_PATH + File.separator + "tmp.conf";
    private static final String DEFAULTTYPE = "JKS";
    private static final String DBNAME = "LEGO";

    public static void updateSql(IextendCallBack callBack) throws SQLException {
        try (Connection connect = null;){
            DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            connect = LegoDBConnection.getInstance().connectDBWithDba(dataBase, DBNAME);
            callBack.callDataBaseUpdate(connect);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateSysConfigData() {
        Connection connect = null;
        try {
            DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            connect = LegoDBConnection.getInstance().connectDBWithDba(dataBase, DBNAME);
            if (connect == null) {
                throw new PatchException("updateSysConfigData failed, get db connection is null.");
            }
            VhaUpdateProcess process = new VhaUpdateProcess(connect);
            process.updateAzMapping();
            if (connect == null) return;
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)("updateSysConfigData failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("updateSysConfigData failed");
            }
            catch (Throwable throwable) {
                if (connect == null) throw throwable;
                UpdateUtil.closeConnection(connect);
                throw throwable;
            }
        }
        UpdateUtil.closeConnection(connect);
        return;
    }

    public static void dealGaussDBUserAuth() {
        DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        String dbUserName = dataBase.getDbaUsername();
        String dbPwd = dataBase.getDbaPassword();
        String superUser = dataBase.getManagerUsername();
        dataBase.setDbaUsername(dataBase.getManagerUsername());
        dataBase.setDbaPassword(dataBase.getManagerPassword());
        Connection connect = LegoDBConnection.getInstance().connectDBWithDba(dataBase, DBNAME);
        dataBase.setDbaUsername(dbUserName);
        dataBase.setDbaPassword(dbPwd);
        try {
            UpdateUtil.changeTableOwner(dbUserName, superUser, connect);
            LOGGER.info((Object)"start dealwith Gauss's user.", "");
            String sqlStr = "alter user " + dbUserName + " with nosuperuser noReplication nocreatedb;";
            String alterDB = "alter database LEGO owner to " + dbUserName;
            InitSQL.executeSQL(connect, alterDB);
            InitSQL.executeSQL(connect, sqlStr);
        }
        catch (Exception e) {
            LOGGER.error((Object)("dealwith Gauss's user auth failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("dealGaussDBUserAuth failed.");
        }
        finally {
            if (connect != null) {
                try {
                    connect.close();
                }
                catch (SQLException e2) {
                    LOGGER.error((Object)("close connect faile: " + ExceptionUtil.getErrorMessage((Throwable)e2)), "");
                }
            }
        }
    }

    public static void changeWccLogConfFile(String installPath) throws IOException {
        String sp = File.separator;
        String wccLogFile = installPath + sp + "Runtime" + sp + "logs" + sp + "wcc.log";
        String log4jFile = installPath + "/Runtime/LegoRuntime/conf/wcc/log4j.properties";
        if (installPath.endsWith(File.separator)) {
            wccLogFile = installPath + "Runtime" + sp + "logs" + sp + "wcc.log";
        }
        if (OSInformation.isWindows()) {
            wccLogFile = wccLogFile.replaceAll("\\\\", "\\\\\\\\");
        }
        String backUpFile = log4jFile + "@back";
        File file = new File(log4jFile);
        if (!file.exists()) {
            LOGGER.info((Object)"log4j.properties is not exists, no need changeWccLogConfFile", "");
            return;
        }
        try {
            String key = "appender.rolling.fileName";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(key, wccLogFile);
            UpdateUtil.changeFile(log4jFile, backUpFile, data);
        }
        catch (Exception e) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Update log4j.properties failed: %s.", ExceptionUtil.getErrorMessage((Throwable)e)), "");
            FileUtil.copyFile(backUpFile, log4jFile);
            throw new IOException();
        }
        finally {
            FileUtil.deleteFile(backUpFile);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void changeFile(String file, String backUpFile, Map<String, String> data) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        BufferedWriter writer = null;
        OutputStreamWriter output = null;
        InputStreamReader input = null;
        FileOutputStream outpuStream = null;
        FileInputStream inputStream = null;
        try {
            String text;
            FileUtil.copyFile(file, backUpFile);
            inputStream = new FileInputStream(backUpFile);
            input = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(input);
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    if (!text.startsWith(entry.getKey())) continue;
                    String value = entry.getValue();
                    text = entry.getKey() + "=" + value;
                }
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            outpuStream = new FileOutputStream(file);
            output = new OutputStreamWriter((OutputStream)outpuStream, "UTF-8");
            writer = new BufferedWriter(output);
            writer.write(sb.toString());
            writer.flush();
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.error((Object)("File not found: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new FileNotFoundException();
                catch (IOException e2) {
                    LOGGER.error((Object)e2, "change file failed.");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(writer, "");
                FileUtil.close(output, "");
                FileUtil.close(outpuStream, "");
                FileUtil.close(reader, "");
                FileUtil.close(input, "");
                FileUtil.close(inputStream, "");
                FileUtil.deleteFile(backUpFile);
                throw throwable;
            }
        }
        FileUtil.close(writer, "");
        FileUtil.close(output, "");
        FileUtil.close(outpuStream, "");
        FileUtil.close(reader, "");
        FileUtil.close(input, "");
        FileUtil.close(inputStream, "");
        FileUtil.deleteFile(backUpFile);
    }

    private static void changeTableOwner(String comUser, String superUser, Connection connect) {
        LOGGER.info((Object)"Start change Table Owner.", "");
        int iCount = 0;
        PreparedStatement preparedStatement = null;
        String allTableQuery = "select TABLENAME,TABLEOWNER from pg_tables where SCHEMANAME='PUBLIC' and TABLEOWNER='" + superUser.toUpperCase(Locale.getDefault()) + "';";
        try {
            preparedStatement = connect.prepareStatement(allTableQuery);
            ResultSet rs = preparedStatement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    String sql = "alter table " + tableName + " owner to " + comUser + ";";
                    preparedStatement = connect.prepareStatement(sql);
                    preparedStatement.execute();
                    ++iCount;
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)("changeTableOwner failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("changeTableOwner failed.");
        }
        finally {
            UpdateUtil.closeStatement(preparedStatement);
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "End change Table Owner, count = %s.", iCount), "");
    }

    protected static void closeStatement(PreparedStatement state) {
        if (state != null) {
            try {
                state.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("closeStatement failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    public static void updateCrypt() {
        String sp = File.separator;
        String currPath = InstallConstant.getCurrentPath();
        String appConfigPath = currPath + sp + "Runtime" + sp + "LegoRuntime" + sp + "conf" + sp + "wcc";
        String appConfigFile = appConfigPath + sp + "application.properties";
        File file = new File(appConfigFile);
        if (!file.exists()) {
            LOGGER.error((Object)"Can not find the wcc config file, update crypt failed.", "");
            throw new PatchException("");
        }
        try {
            int mkCount = KmcInstance.getSoftInstance().getMaxMkID(KmcInstance.kmcDomain);
            if (mkCount == 1) {
                LOGGER.info((Object)"need update wcc crypt.", "");
                WccEncryptor.updateSoftCrypt();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("update crypt failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("");
        }
    }

    private static boolean checkIfUpdated(File path) {
        boolean isUpdated = false;
        String sp = File.separator;
        try {
            File[] fileList;
            String cryptPath = path.getCanonicalPath().substring(0, path.getCanonicalPath().lastIndexOf(sp));
            String fileName = path.getName();
            File tmpPath = new File(cryptPath);
            for (File file : fileList = tmpPath.listFiles()) {
                String tmpFileName = file.getName();
                if (!tmpFileName.startsWith(fileName) || tmpFileName.equals(fileName)) continue;
                isUpdated = true;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("check If crypt Updated failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return isUpdated;
    }

    public static void updateCerts() {
        try {
            UpdateUtil.dealWithCerts();
        }
        catch (IOException e) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "DealWithCerts failed: %s.", e), "");
            throw new PatchException("dealWithCerts failed.");
        }
    }

    private static void dealWithCerts() throws IOException {
        String sp = File.separator;
        String runtimePath = InitInstalledXmlTool.getInstallPath() + sp;
        String oldKeyStore = runtimePath + "Runtime@tmp" + LegoResourceManager.getProValue("install.platform.keystore");
        File file = new File(oldKeyStore);
        if (!file.exists()) {
            LOGGER.info((Object)"can not find the keystore file, return.", "0x000252000FB5000D");
            return;
        }
        LOGGER.info((Object)"start deal with backend keystore.", "");
        UpdateUtil.dealWithBackEndKeyStore(runtimePath);
        LOGGER.info((Object)"start deal with tomcat keystore.", "");
        UpdateUtil.dealWithFrontKeyStore(runtimePath);
        UpdateUtil.dealWithNodeAgentStore(runtimePath);
        LOGGER.info((Object)"start deal with nginx certs.", "");
        UpdateUtil.dealWithNginxCerts(runtimePath);
    }

    private static void dealWithNginxCerts(String runtimePath) {
        Path tempCertsDir = Paths.get(runtimePath, "Runtime@tmp", "nginx", "certs");
        Path targetCertsDir = Paths.get(runtimePath, "Runtime", "nginx", "certs");
        if (!Files.isDirectory(tempCertsDir, new LinkOption[0])) {
            String confFile = InstallConstant.getsBasePath() + "Runtime/LegoRuntime/conf/lego.properties";
            PropertyUtil pro = new PropertyUtil(confFile);
            String keystorePwd = WccEncryptor.decode(pro.getValue("nginx.keypass"));
            String generateCertShell = InstallConstant.getsBasePath() + "/generateCert.sh gensmcert";
            if (!CmdUtil.execStrCmd(generateCertShell, new String[]{keystorePwd})) {
                LOGGER.error((Object)"Failed to execute the certificate generation script.");
                throw new InstallException("Failed to execute the certificate generation script.");
            }
        }
        try (Stream<Path> sourceStream = Files.walk(tempCertsDir, 1, new FileVisitOption[0]);){
            sourceStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(source -> {
                try {
                    Files.copy(source, targetCertsDir.resolve(source.getFileName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (IOException e) {
                    LOGGER.error((Object)String.format(Locale.ENGLISH, "Copy cert [%s] failed.", source.getFileName()), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error((Object)"Copy certs from tempCertsDir failed.", (Throwable)e);
        }
    }

    private static String getTomcatKeyStoreFile(String xmlFile) {
        SAXReader reader = new SAXReader();
        String keystore = "";
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            File file = new File(xmlFile);
            if (!file.exists()) {
                LOGGER.error((Object)("getTomcatKeyStoreFile faield, file not exists: " + file.getName()), "");
                throw new FileNotFoundException();
            }
            Document document = reader.read(xmlFile);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore = ((Element)ele).attribute("keystoreFile");
                if (keyStore == null) continue;
                keystore = keyStore.getValue();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("get keystore pwd from tomcat conf file failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("get keystore pwd from tomcat conf file failed.");
        }
        return keystore;
    }

    private static String getTomcatKeyStoreType(String xmlFile) {
        SAXReader reader = new SAXReader();
        String keystoreType = "";
        try {
            File file = new File(xmlFile);
            if (!file.exists()) {
                LOGGER.error((Object)("getTomcatKeyStoreType faield, file not exists: " + file.getName()), "");
                throw new FileNotFoundException();
            }
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xmlFile);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore = ((Element)ele).attribute("keystoreType");
                if (keyStore == null) continue;
                keystoreType = keyStore.getValue();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("get keystore pwd from tomcat conf file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("get keystore pwd from tomcat conf file failed.");
        }
        return keystoreType;
    }

    private static void updateServerXML(String xmlFile, String data, String pwd, String keyPwd, String keyStoreType) {
        File xml = new File(xmlFile);
        if (!xml.exists()) {
            LOGGER.info((Object)"can not find the file server.xml or http port is null, not changed, return.", "");
            return;
        }
        FileOutputStream fout = null;
        XMLWriter writer = null;
        SAXReader reader = new SAXReader();
        boolean isChanged = false;
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xml);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore1 = ((Element)ele).attribute("keystoreFile");
                if (keyStore1 == null) continue;
                ((Element)ele).addAttribute("keystoreFile", data);
                ((Element)ele).addAttribute("keystorePass", WccEncryptor.encode(pwd));
                ((Element)ele).addAttribute("keyPass", WccEncryptor.encode(keyPwd));
                if (!"".equals(keyStoreType)) {
                    ((Element)ele).addAttribute("keystoreType", keyStoreType);
                }
                if (!VerifyUtil.isEmpty((String)keyPwd) && !keyPwd.equals(pwd)) {
                    ((Element)ele).addAttribute("keyPass", WccEncryptor.encode(keyPwd));
                }
                isChanged = true;
            }
            if (!isChanged) {
                LOGGER.info((Object)"password is not changed, return.", "");
                return;
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            fout = new FileOutputStream(new File(xmlFile));
            writer = new XMLWriter((OutputStream)fout, format);
            writer.write(document);
            UpdateUtil.closeStream(fout);
        }
        catch (Exception e) {
            LOGGER.error((Object)("update server.xml failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("update server.xml failed.");
        }
        finally {
            UpdateUtil.closeStream(fout);
            UpdateUtil.closeXmlWriter(writer);
        }
        UpdateUtil.closeXmlWriter(writer);
    }

    private static void closeXmlWriter(XMLWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e, "close xml writer failed.");
            }
        }
    }

    private static void dealWithNodeAgentStore(String runPath) {
        try {
            String nodeAgentTmpCertPath = runPath + "Runtime@tmp/NodeAgent/certs";
            String nodeAgentTmpCertConf = runPath + "Runtime@tmp/NodeAgent/conf/nodeAgent.properties";
            String nodeAgentTmpCertPwdConf = runPath + "Runtime@tmp/NodeAgent/conf/nodeAgent-pwd.properties";
            String nodeAgentCertPath = runPath + "Runtime/NodeAgent/certs";
            String nodeAgentCertConf = runPath + "Runtime/NodeAgent/conf/nodeAgent.properties";
            String nodeAgentCertPwdConf = runPath + "Runtime/NodeAgent/conf/nodeAgent-pwd.properties";
            FileUtil.copyFolder(nodeAgentTmpCertPath, nodeAgentCertPath);
            PropertyUtil pwdPro = new PropertyUtil(nodeAgentTmpCertPwdConf);
            String keystorePass = WccEncryptor.decode(pwdPro.getValue("keystorePass"));
            String keyPass = WccEncryptor.decode(pwdPro.getValue("keyPass"));
            HashMap<String, String> maps = new HashMap<String, String>();
            maps.put("keyPass", WccEncryptor.encode(keyPass));
            maps.put("keystorePass", WccEncryptor.encode(keystorePass));
            FileUtil.modifyDBPropFileUsingStr(nodeAgentCertPwdConf, maps, nodeAgentCertPwdConf);
            PropertyUtil certPathPro = new PropertyUtil(nodeAgentTmpCertConf);
            String certPath = certPathPro.getValue("keystorePath");
            HashMap<String, String> path = new HashMap<String, String>();
            path.put("certPath", certPath);
            FileUtil.modifyDBPropFileUsingStr(nodeAgentCertConf, path, nodeAgentCertConf);
        }
        catch (Exception e) {
            LOGGER.error((Object)("dealWithFrontKeyStore failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("dealWithFrontKeyStore failed: ");
        }
    }

    private static void dealWithFrontKeyStore(String runPath) {
        try {
            String sp = File.separator;
            String tomcatKeyStore = runPath + "Runtime@tmp" + sp + "Tomcat6/certs/tomcat.keystore";
            String xmlFile = runPath + "Runtime@tmp" + sp + "Tomcat6/conf/server.xml";
            String targetKeyStore = runPath + "Runtime/Tomcat6/certs/tomcat.keystore";
            String targetServerXml = runPath + "Runtime/Tomcat6/conf/server.xml";
            String oldPwd = ChangeCertsPwd.getTomcatKeyStorePwd(xmlFile);
            String okdKeyPass = ChangeCertsPwd.getTomcatKeyPwd(xmlFile);
            String keyStoreType = UpdateUtil.getTomcatKeyStoreType(xmlFile);
            String currentKeyStore = UpdateUtil.getTomcatKeyStoreFile(xmlFile);
            File file = new File(tomcatKeyStore);
            if (!file.exists()) {
                LOGGER.info((Object)"the default keystore is not exists, get it from tomcat config file.", "");
                String src = runPath + "Runtime@tmp/Tomcat6/" + currentKeyStore;
                String dest = runPath + "Runtime/Tomcat6/" + currentKeyStore;
                FileUtil.copyFile(src, dest);
                UpdateUtil.updateServerXML(targetServerXml, currentKeyStore, oldPwd, okdKeyPass, keyStoreType);
                return;
            }
            FileUtil.copyFile(tomcatKeyStore, targetKeyStore);
            String newPwd = ChangeCertsPwd.getTomcatKeyStorePwd(targetServerXml);
            if (!VerifyUtil.isEmpty((String)okdKeyPass) && !okdKeyPass.equals(oldPwd)) {
                LOGGER.info((Object)"need update tomcat server.xml private key password.", "");
                UpdateUtil.updateServerXML(targetServerXml, currentKeyStore, newPwd, okdKeyPass, keyStoreType);
            }
            if (!VerifyUtil.isEmpty((String)okdKeyPass) && !okdKeyPass.equals(newPwd)) {
                LOGGER.info((Object)"start update private key password.", "");
                PrivateKey privateKey = new PrivateKey();
                privateKey.setAliasName("bcmrootca");
                privateKey.setKeyStore(targetKeyStore);
                privateKey.setKeyStorePwd(okdKeyPass);
                privateKey.setOldKeyPwd(okdKeyPass);
                privateKey.setNewKeyPwd(newPwd);
                ChangePrivateKeyPwd.updateKeyPwd(privateKey);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("dealWithFrontKeyStore failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("dealWithFrontKeyStore failed: ");
        }
    }

    private static void dealWithBackEndKeyStore(String runPath) {
        String sp = File.separator;
        String oldCertPath = runPath + "Runtime@tmp/LegoRuntime/certs/";
        String newCertPath = runPath + "Runtime/LegoRuntime/certs/";
        String oldConfFile = runPath + "Runtime@tmp" + sp + "LegoRuntime/conf/lego.properties";
        String targetFile = runPath + "Runtime" + sp + "LegoRuntime/conf/lego.properties";
        try {
            PropertyUtil pro = new PropertyUtil(oldConfFile);
            String oldkeyPwd = WccEncryptor.decode(pro.getValue("keyStore"));
            FileUtil.copyFolder(oldCertPath, newCertPath);
            ChangeCertsPwd.changePwd(runPath, oldkeyPwd);
            UpdateUtil.changeConfFile(targetFile, pro);
        }
        catch (Exception e) {
            LOGGER.error((Object)("dealWithBackEndKeyStore faield: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("restore certs failed: ");
        }
    }

    private static void changeConfFile(String file, PropertyUtil pro) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("default.lego.alias", pro.getValue("default.lego.alias"));
        data.put("Issuer.info", pro.getValue("Issuer.info"));
        try {
            FileUtil.modifyDBPropFileUsingStr(file, data, file);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, "changeConfFile failed.");
            throw new PatchException("changeConfFile failed: " + e);
        }
    }

    public static void exportConfig() {
        try {
            UpdateUtil.dealWithFile();
        }
        catch (Exception e) {
            LOGGER.error((Object)("export error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("dealWithFile failed: ");
        }
        finally {
            FileUtil.deleteFile(TMP_FILE);
        }
    }

    private static void dealWithFile() throws IOException {
        String sp = File.separator;
        String proper = "application.properties";
        String wccStore = "wccStore.xml";
        String oldConfPath = "Runtime" + sp + "LegoRuntime" + sp + "conf";
        String oldAppHome = INSTALL_PATH + sp + oldConfPath;
        String oldConfFile = oldAppHome + sp + proper;
        String newConfPath = oldConfPath + sp + "wcc" + sp + "crypt";
        String newConfFile = INSTALL_PATH + sp + newConfPath + sp + wccStore;
        File oldFile = new File(oldConfFile);
        File newFile = new File(newConfFile);
        if (!oldFile.exists() && !newFile.exists()) {
            LOGGER.info((Object)"linux no need deal while cli install, return.", "");
            return;
        }
        if (newFile.exists()) {
            LOGGER.info((Object)"use new wcc config file path.", "");
            oldAppHome = INSTALL_PATH + sp + newConfPath;
        }
        String newAppHome = InstallConstant.getCurrentPath() + sp + newConfPath;
        FileUtil.copyFile("", "");
    }

    public static String getLicXmlPath() {
        String sp = File.separator;
        return INSTALL_PATH + sp + "Runtime" + sp + "LegoRuntime" + sp + "lic" + sp + LegoResourceManager.getProValue("install.params.license.file");
    }

    public static void updateLicXml() throws IOException, DocumentException, SAXException {
        String sp = File.separator;
        String licFile = INSTALL_PATH + sp + "Runtime" + sp + "LegoRuntime" + sp + "lic" + sp + LegoResourceManager.getProValue("install.params.license.file");
        File file = new File(licFile);
        if (!file.exists()) {
            LOGGER.info((Object)"can not find the legolic.xml, no need to update.", "0x000252000FB5000D");
            return;
        }
        UpdateUtil.updateLicXml(licFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLicXml(String xmlFile) throws IOException, DocumentException, SAXException {
        String timeSit;
        Element element;
        Document document;
        XMLWriter writer;
        FileOutputStream fout;
        block4: {
            fout = null;
            writer = null;
            SAXReader reader = new SAXReader();
            File xml = new File(xmlFile);
            try {
                if (!xml.exists()) {
                    LOGGER.error((Object)"LegoLic.xml is not exists.", "");
                    throw new FileNotFoundException("updateLicXml failed, file not found.");
                }
                CommonUtil.setSecurityFeatures((SAXReader)reader);
                document = reader.read(xml);
                element = (Element)document.selectSingleNode("/install/lic");
                timeSit = element.attributeValue("sit");
                String code = WccEncryptor.retryDecode(timeSit);
                if (VerifyUtil.isEmpty((String)code)) break block4;
                LOGGER.info((Object)"Not need change license time, return.", "0x000252000FB5000D");
            }
            catch (Throwable throwable) {
                UpdateUtil.releaseStream(writer);
                UpdateUtil.closeStream(fout);
                throw throwable;
            }
            UpdateUtil.releaseStream(writer);
            UpdateUtil.closeStream(fout);
            return;
        }
        element.addAttribute("sit", WccEncryptor.encode(timeSit));
        OutputFormat format = OutputFormat.createPrettyPrint();
        fout = new FileOutputStream(new File(xmlFile));
        writer = new XMLWriter((OutputStream)fout, format);
        writer.write(document);
        UpdateUtil.releaseStream(writer);
        UpdateUtil.closeStream(fout);
    }

    public static String getInstallPath() {
        return INSTALL_PATH;
    }

    private static void releaseStream(XMLWriter stream) {
        if (stream != null) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Release XMLWriter is Error:", e.getMessage());
            }
        }
    }

    public static void closeConnection(Connection connect) {
        try {
            if (connect != null) {
                connect.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)("close connection failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    private static void closeStream(Closeable be) {
        if (be != null) {
            try {
                be.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"close stream failed.", (Throwable)e, "0x000252000FB50012");
            }
        }
    }
}

