/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.JarFileUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class ChangeDbInforInJar {
    private static final Log LOG = LogFactory.getInstance(ChangeDbInforInJar.class);
    private static final String DEFAULT_IP = "[IPADDRESS]";
    private static final String DEFAULT_PORT = "[PORT]";

    public static void changePropDBFile(DataBaseInfo dbInfor, String savePath) throws IOException {
        LOG.info((Object)"Change DB Properties ", "0x000252000FB5001E");
        String dbHost = dbInfor.getDbHost();
        String dbuseName = dbInfor.getDbaUsername();
        String dbPort = dbInfor.getDbPort();
        String dbPassword = dbInfor.getDbaPassword();
        String jarFile = savePath + "/" + LegoResourceManager.getProValue("install.lego_version.backend.jar.path") + "/" + LegoResourceManager.getProValue("install.db.propfile.jar");
        String dbProFile = "lego.properties";
        String osgiConfig = savePath + "/Runtime/LegoRuntime/conf/" + dbProFile;
        File jar = new File(jarFile);
        if (!jar.exists()) {
            LOG.error((Object)("The jar is not exists, changePropDBFile failed: " + jar.getName()), "");
            return;
        }
        String targetFile = jar.getParent() + File.separator + dbProFile;
        String tmpFile = targetFile + "@tmp";
        String[] keys = new String[3];
        String[] values = new String[3];
        keys[0] = "hibernate.connection.driver_class";
        keys[1] = "hibernate.dialect";
        keys[2] = "hibernate.connection.url";
        try {
            JarFileUtil.copyFileFromJar(jarFile, dbProFile, tmpFile);
            values[0] = LegoResourceManager.getProValue("hibernate.gauss.connection.driver_class");
            values[1] = LegoResourceManager.getProValue("hibernate.gauss.dialect");
            values[2] = LegoResourceManager.getProValue("hibernate.gauss.connection.url.property").replace(DEFAULT_IP, dbHost).replace(DEFAULT_PORT, dbPort);
            FileUtil.modifyDBPropFileUsingStr(tmpFile, keys, values, targetFile);
            JarFileUtil.editJar(jarFile, dbProFile, targetFile);
            String pwdKey = "hibernate.connection.password";
            String userKey = "hibernate.connection.username";
            String pwdValue = WccEncryptor.encode(dbPassword);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put(pwdKey, pwdValue);
            dataMap.put(userKey, dbuseName);
            FileUtil.modifyDBPropFileUsingStr(osgiConfig, dataMap, osgiConfig);
        }
        catch (Exception e) {
            LOG.error((Object)("ChangePropDBFile failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new IOException("changePropDBFile failed.");
        }
        finally {
            FileUtil.deleteFile(targetFile);
            FileUtil.deleteFile(tmpFile);
        }
        LOG.info((Object)"Finish Replace the lego.properties file in jar ", "0x000252000FB50032");
    }
}

