/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.DataBaseTestUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.IOHandleTask;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GaussDBUtil {
    private static final Log LOG = LogFactory.getInstance(GaussDBUtil.class);
    private static final int CONNECTION_SECONDS = 3;
    private static final int CONNECTION_TIMES = 10;
    private static final int OVERTIME_SECONDS = 600;
    private static final String DBPLUGINPATH = "Plug-In" + File.separator + "DataBase" + File.separator + "Script" + File.separator;
    private static final String DBAFTERINSTALLSCRIPTPATH = ".." + File.separator + "gs" + File.separator + "bin" + File.separator;
    private static final String GS_SERVICE_TOOL = "gsService.sh";
    private static final String EXECUTECMD_SUCCESS = "0";
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(2, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public static void installGaussDB() throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("install");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                LOG.error((Object)"Install GaussDB Error", "0x000252000FB50041");
                throw new IOException();
            }
            LOG.info((Object)"Install GaussDB success", "0x000252000FB50040");
        }
        catch (IOException | InterruptedException e) {
            LOG.error((Object)e, "Install gauss DB Error!0x000252000FB50041");
            throw e;
        }
    }

    public static void upgradeGaussDB() {
        try {
            LOG.info((Object)"Start upgrade gaussdb.", "");
            String result = GaussDBUtil.exec("upgrade");
            if (EXECUTECMD_SUCCESS.equals(result)) {
                LOG.info((Object)"Upgrade GaussDB success", "0x000252000FB50040");
                return;
            }
            throw new PatchException("upgradeGaussDB failed, result: " + result);
        }
        catch (Exception e) {
            LOG.error((Object)("UpgradeGaussDB failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("upgradeGaussDB failed.");
        }
    }

    public static void startGaussDB() throws IOException, InterruptedException {
        GaussDBUtil.startGaussDB(false);
    }

    public static void startGaussDB(boolean needTest) throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("start");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                LOG.error((Object)("Start GaussDB Error, result=" + result), "0x000252000FB50043");
                throw new IOException();
            }
            LOG.info((Object)"Start GaussDB success", "0x000252000FB50042");
        }
        catch (IOException | InterruptedException e) {
            LOG.error((Object)e, "Start GaussDB Error0x000252000FB50043");
            throw e;
        }
        if (!needTest) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            TimeUnit.SECONDS.sleep(3L);
            if (!DataBaseTestUtil.connectionGauss()) continue;
            LOG.info((Object)String.format(Locale.ROOT, "Try connect database success. times: %s", i));
            return;
        }
        throw new IOException("try connect database failed. times: 10");
    }

    public static void stopGaussDatabase() throws IOException, InterruptedException {
        boolean green = Boolean.parseBoolean(LegoResourceManager.getProValue("isGreenGauss"));
        if (InitBundleXmlTool.getDBType().equalsIgnoreCase("Gauss") && green && DataBaseTestUtil.connectionGauss()) {
            GaussDBUtil.stopGaussDB();
        }
    }

    public static boolean takeOffArchiveMode() {
        DataBaseInfo dbInfor = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        return GaussDBUtil.takeOffArchiveMode(dbInfor.getDbFilePath() + File.separator + "postgresql.conf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean takeOffArchiveMode(String conf) {
        RandomAccessFile f;
        boolean done;
        block11: {
            done = false;
            File file = new File(conf);
            if (!file.exists() || !file.isFile()) {
                return done;
            }
            f = null;
            try {
                f = new RandomAccessFile(file, "rw");
                String line = null;
                long s = 0L;
                long c = 0L;
                boolean none = true;
                boolean deal = false;
                while ((line = f.readLine()) != null) {
                    ++c;
                    if (line.matches("archive_mode\\s*=.*")) {
                        if ((line = line.toLowerCase(Locale.ROOT)).matches("archive_mode\\s*=\\s*on\\s*(#.*)?")) {
                            f.seek(s);
                            f.writeByte(35);
                            deal = true;
                        } else if (line.matches("archive_mode\\s*=\\s*off\\s*(#.*)?")) {
                            done = true;
                        } else {
                            LOG.error((Object)("Error at line " + c), "take off archive mode failed");
                        }
                        none = false;
                        break;
                    }
                    s = f.getFilePointer();
                }
                if (!none && !deal) break block11;
                f.seek(f.length());
                byte[] separator = System.getProperty("line.separator").getBytes();
                f.write(separator);
                f.write("archive_mode = off".getBytes());
                f.write(separator);
                done = true;
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)e, "Take off archive mode failed");
                }
                catch (Throwable throwable) {
                    FileUtil.close(f, "close RandomAccessFile");
                    throw throwable;
                }
                FileUtil.close(f, "close RandomAccessFile");
            }
        }
        FileUtil.close(f, "close RandomAccessFile");
        return done;
    }

    public static void stopGaussDB() throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("stop");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                LOG.error((Object)"Stop GaussDB Error", "0x000252000FB50045");
                throw new IOException();
            }
            LOG.info((Object)"Stop GaussDB success", "0x000252000FB50044");
        }
        catch (IOException | InterruptedException e) {
            LOG.error((Object)e, "Stop GaussDB Error0x000252000FB50045");
            throw e;
        }
    }

    public static void reinforceGaussDB() throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("reinforce");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                LOG.error((Object)"Reinforce GaussDB Error", "0x000252000FB50049");
                throw new IOException();
            }
            LOG.info((Object)"Reinforce GaussDB success", "0x000252000FB50048");
        }
        catch (IOException e) {
            LOG.error((Object)e, "Reinforce GaussDB Error0x000252000FB50049");
            throw e;
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Reinforce GaussDB Error", "0x000252000FB50049");
            throw e;
        }
    }

    public static void unInstallGaussDB() throws IOException, InterruptedException {
        try {
            String result = GaussDBUtil.exec("uninstall");
            if (null == result || !result.equals(EXECUTECMD_SUCCESS)) {
                LOG.error((Object)"Uninstall GaussDB Error", "0x000252000FB50047");
                throw new IOException();
            }
            LOG.info((Object)"Uninstall GaussDB success", "0x000252000FB50046");
        }
        catch (IOException e) {
            LOG.error((Object)e, "unInstall Gauss DB IO error");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String exec(String action) throws IOException, InterruptedException {
        String string;
        String batPath = InstallConstant.getsBasePath() + DBPLUGINPATH;
        File file = new File(batPath);
        if (!file.exists()) {
            batPath = InstallConstant.getsBasePath() + DBAFTERINSTALLSCRIPTPATH;
        }
        List<String> params = GaussDBUtil.getGaussDBFileParamas(action);
        ArrayList<String> cmdList = new ArrayList<String>();
        String execScript = batPath + GS_SERVICE_TOOL;
        File scripFile = new File(execScript);
        if (!scripFile.exists()) {
            LOG.error((Object)"Can not find the gsService script.", "");
            throw new FileNotFoundException();
        }
        GaussDBUtil.checkScriptFile(execScript);
        cmdList.add(execScript);
        cmdList.addAll(params);
        String[] commands = cmdList.toArray(new String[0]);
        InputStream in = null;
        BufferedReader reader = null;
        BufferedReader errReader = null;
        Process ps = null;
        try {
            ps = Runtime.getRuntime().exec(commands);
            GaussDBUtil.writePassWord(ps, action);
            in = ps.getInputStream();
            reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            errReader = new BufferedReader(new InputStreamReader(ps.getErrorStream(), StandardCharsets.UTF_8));
            FutureTask<String> inputFutureTask = GaussDBUtil.createInputFutureTask(reader);
            IOHandleTask errTask = new IOHandleTask(errReader);
            EXECUTOR_SERVICE.submit(inputFutureTask);
            EXECUTOR_SERVICE.submit(errTask);
            String result = inputFutureTask.get(600L, TimeUnit.SECONDS);
            Integer waitFor = ps.waitFor();
            LOG.info((Object)String.format(Locale.ENGLISH, "WaitFor result is %s", waitFor), "");
            string = result;
        }
        catch (ExecutionException e) {
            LOG.error((Object)String.format(Locale.ENGLISH, "Run cmd error: %s", ExceptionUtil.getErrorMessage((Throwable)e)), "");
            String string2 = "";
            GaussDBUtil.closeStream(in, reader, ps);
            FileUtil.close(errReader, "Err Stream Closed.");
            return string2;
        }
        catch (TimeoutException e2) {
            LOG.error((Object)String.format(Locale.ENGLISH, "Run cmd TimeOut: %s", ExceptionUtil.getErrorMessage((Throwable)e2)), "");
            String string3 = "";
            {
                catch (Throwable throwable) {
                    GaussDBUtil.closeStream(in, reader, ps);
                    FileUtil.close(errReader, "Err Stream Closed.");
                    throw throwable;
                }
            }
            GaussDBUtil.closeStream(in, reader, ps);
            FileUtil.close(errReader, "Err Stream Closed.");
            return string3;
        }
        GaussDBUtil.closeStream(in, reader, ps);
        FileUtil.close(errReader, "Err Stream Closed.");
        return string;
    }

    private static void checkScriptFile(String scripFile) {
        try {
            SignVerifier.getInstance().verify(scripFile);
        }
        catch (SignatureException e) {
            LOG.error((Object)"Failed to verify the gsService script.", "");
            throw new IllegalStateException("Failed to verify the gsService script.");
        }
    }

    private static FutureTask<String> createInputFutureTask(BufferedReader reader) {
        return new FutureTask<String>(() -> {
            String line = "";
            String result = "";
            while ((line = FileUtil.getLineFromFile(reader)) != null) {
                result = line;
                LOG.info((Object)line, "");
            }
            return result;
        });
    }

    private static void writePassWord(Process process, String action) {
        if (!"upgrade".equals(action) && !"reinforce".equals(action)) {
            return;
        }
        DataBaseInfo dbInfo = PrepareParamUtil.getsInstallDto() == null ? InitInstalledXmlTool.getInstalledSystem().getDbInfor() : PrepareParamUtil.getsInstallDto().getDbDto();
        try (BufferedWriter outputBw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));){
            if ("upgrade".equals(action)) {
                GaussDBUtil.writePassToShell(dbInfo.getManagerPassword().toCharArray(), outputBw);
            }
            if ("reinforce".equals(action)) {
                GaussDBUtil.writePassToShell(dbInfo.getDbaPassword().toCharArray(), outputBw);
                GaussDBUtil.writePassToShell(WccEncryptor.retryDecode(dbInfo.getDefaultManagerPassword()).toCharArray(), outputBw);
                GaussDBUtil.writePassToShell(dbInfo.getManagerPassword().toCharArray(), outputBw);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Upgrade or reinforce gauss database failed!");
        }
    }

    private static void writePassToShell(char[] dbaPassWord, BufferedWriter outputBw) throws IOException {
        outputBw.write(dbaPassWord);
        outputBw.newLine();
        outputBw.flush();
    }

    private static void closeStream(InputStream in, BufferedReader reader, Process ps) {
        FileUtil.close(reader, "BufferedReader close");
        FileUtil.close(in, "InputStream close");
        if (ps != null) {
            ps.destroy();
        }
    }

    private static List<String> getGaussDBFileParamas(String type) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(type);
        if ("start".equals(type) || "stop".equals(type)) {
            return params;
        }
        DataBaseInfo dbInfo = null == PrepareParamUtil.getsInstallDto() ? InitInstalledXmlTool.getInstalledSystem().getDbInfor() : PrepareParamUtil.getsInstallDto().getDbDto();
        switch (type) {
            case "install": {
                GaussDBUtil.checkPathChar(dbInfo.getDbPath());
                GaussDBUtil.checkPathChar(dbInfo.getDbFilePath());
                params.add(dbInfo.getDbPath());
                params.add(dbInfo.getDbFilePath());
                params.add(dbInfo.getDbPort());
                params.add(dbInfo.getDbaUsername());
                params.add(dbInfo.getManagerUsername());
                break;
            }
            case "upgrade": {
                params.add(dbInfo.getManagerUsername());
                params.add(dbInfo.getDbPort());
                params.add(dbInfo.getDbFilePath());
                break;
            }
            case "reinforce": {
                params.add(dbInfo.getDbPort());
                params.add(dbInfo.getManagerUsername());
                params.add(dbInfo.getDbaUsername());
                params.add(dbInfo.getDbFilePath());
                break;
            }
            case "uninstall": {
                params.add(dbInfo.getDbPath());
                params.add(dbInfo.getDbFilePath());
                break;
            }
            default: {
                LOG.warn((Object)("the type is not supported. type:" + type), "");
            }
        }
        return params;
    }

    private static void checkPathChar(String path) {
        if (path == null || path.trim().length() < 1) {
            LOG.error((Object)LegoResourceManager.getString("LEGO.GAUSSDBPATH.SET.ERROR.CHAR"), "0x000252000FB50041");
            SystemExitUtil.exitFail();
        }
        String[] folderNames = null;
        if (null != System.getProperty("os.name") && System.getProperty("os.name").contains("Windows")) {
            String unRootPath = path.substring(path.indexOf(":\\") + 2);
            unRootPath = unRootPath.replace("\\", "/");
            folderNames = unRootPath.split("/");
        } else {
            folderNames = path.split("/");
        }
        for (String folder : folderNames) {
            Pattern pattern;
            Matcher matcher;
            boolean flag;
            if (folder.length() == 0 || (flag = (matcher = (pattern = Pattern.compile("^[\\w-.]+$")).matcher(Normalizer.normalize(folder, Normalizer.Form.NFKC))).matches())) continue;
            LOG.error((Object)LegoResourceManager.getString("LEGO.GAUSSDBPATH.SET.ERROR.CHAR"), "0x000252000FB50041");
            SystemExitUtil.exitFail();
        }
    }
}

