/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.plugin.common;

import com.huawei.drm.install.common.dto.PlatformBundles;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class GetOriginalBundlesFile {
    private static final Log LOG = LogFactory.getInstance(GetOriginalBundlesFile.class);

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            LOG.error((Object)"Get InstallInfo error, can not get file param");
            return;
        }
        File file = new File(FilenameUtils.normalize((String)args[0]));
        if (file.exists()) {
            String outPutPath = "./originalProductFile";
            Map<String, PlatformBundles> platBundles = InitInstalledXmlTool.getInstalledSystem().getPtMap();
            Map<String, ProductBundles> installedProduct = InitInstalledXmlTool.getInstalledProductBundlsToCli(args[0]);
            GetOriginalBundlesFile.write(outPutPath, platBundles, installedProduct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(String outPutPath, Map<String, PlatformBundles> platBundles, Map<String, ProductBundles> installedProduct) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(outPutPath);
            int index = 1;
            Iterator<Map.Entry<String, PlatformBundles>> ptIterator = platBundles.entrySet().iterator();
            while (ptIterator.hasNext()) {
                index = GetOriginalBundlesFile.initPlatBundleWriter(writer, index, ptIterator);
            }
            for (Map.Entry<String, ProductBundles> entry : installedProduct.entrySet()) {
                ProductBundles value = entry.getValue();
                if ("ism.v2r5.base.bundle".equals(value.getId().trim())) continue;
                StringBuilder builder = new StringBuilder();
                builder.append(index++).append(". ").append("\t").append(entry.getKey()).append("\t").append(LegoResourceManager.getString(value.getName())).append("\t").append(LegoResourceManager.getString(value.getDescription())).append("\t").append(value.getVersion()).append("\t").append(value.getExtendCallBackClz()).append("\t").append(value.getSize()).append("MB");
                writer.write(builder.toString());
                writer.write("\r\n");
            }
            writer.flush();
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"IOException: ", (Throwable)e);
                }
            }
        }
    }

    private static int initPlatBundleWriter(FileWriter writer, int index, Iterator<?> ptIterator) throws IOException {
        Map.Entry entry = (Map.Entry)ptIterator.next();
        PlatformBundles value = (PlatformBundles)entry.getValue();
        StringBuilder builder = new StringBuilder();
        builder.append(index++).append(". ").append("\t").append(value.getId()).append("\t").append(LegoResourceManager.getString(value.getName())).append("\t").append(LegoResourceManager.getString(value.getDescription())).append("\t").append(value.getVersion()).append("\t").append("null").append("\t").append(value.getSize()).append("MB");
        writer.write(builder.toString());
        writer.write("\r\n");
        return index;
    }
}

