/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

import com.huawei.kmc.common.AppException;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;

public class CommonUtils {
    private CommonUtils() {
    }

    public static boolean isNumeric(CharSequence sequence) {
        if (sequence == null || sequence.length() == 0) {
            return false;
        }
        int sz = sequence.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPath(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        try {
            File file = new File(path);
            String filePath = file.getCanonicalPath();
            if (filePath == null) {
                return false;
            }
            Paths.get(filePath, new String[0]);
        }
        catch (IOException | InvalidPathException ex) {
            return false;
        }
        return true;
    }

    public static boolean checkAutoUpdateMk(Properties props) throws AppException {
        Optional.ofNullable(props).orElseThrow(() -> new AppException("properties cannot be null."));
        String autoUpdateMk = props.getProperty("auto_update_mk_enabled", "");
        if (autoUpdateMk.isEmpty()) {
            return true;
        }
        if (autoUpdateMk.equals("true")) {
            return true;
        }
        if (autoUpdateMk.equals("false")) {
            return false;
        }
        throw new AppException("illegal auto_update_mk_enabled property.");
    }

    public String toString() {
        return "**not support toString**";
    }
}

