/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.crypt;

import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.CommonUtils;
import com.huawei.kmc.common.ConfigUtils;
import com.huawei.kmc.common.Errno;
import com.huawei.kmc.common.ILogger;
import com.huawei.kmc.common.InitStage;
import com.huawei.kmc.crypt.NativeAPI;
import com.huawei.kmc.entity.KmcInitConfig;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class CryptoAPI
extends NativeAPI {
    static final String KMC_VERSION = "KMC 22.1.0";
    private static volatile CryptoAPI instance = null;
    private static volatile Properties globalProperties = new Properties();
    private static final Object CRYPTOAPI_LOCK = new Object();

    private CryptoAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CryptoAPI getInstance() {
        if (instance != null) return instance;
        Class<CryptoAPI> clazz = CryptoAPI.class;
        synchronized (CryptoAPI.class) {
            if (instance != null) return instance;
            instance = new CryptoAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static Properties getProperties() {
        return globalProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLifetimeDays(int updateLifeDays) throws AppException {
        ConfigUtils.checkLifetimeDays(updateLifeDays);
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            globalProperties.put("crypt_key_lifetime_days", (Object)updateLifeDays);
        }
    }

    public static int getInitStage() {
        return NativeAPI.nativeStageJni.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties configProps) throws AppException {
        if (configProps == null || configProps.size() == 0) {
            throw new AppException("config properties cannot be null.");
        }
        Properties filterProps = ConfigUtils.checkIntegrityAndFilterProp(configProps);
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            globalProperties.clear();
            globalProperties.putAll((Map<?, ?>)filterProps);
            try {
                ConfigUtils.checkCryptoProps(globalProperties);
            }
            catch (AppException e) {
                this.getLogger().error("check property error details");
                throw e;
            }
            this.getLogger().info("init component properties size: " + globalProperties.size());
            KmcInitConfig initConfig = CryptoAPI.buildConfig(globalProperties);
            initConfig.setExtendProperties(globalProperties);
            this.initCryptoComponent(initConfig);
        }
    }

    @Override
    protected void setStageStatus() {
        this.nativeInitStage = InitStage.INIT_KMC_DONE;
        NativeAPI.nativeStageJni = InitStage.INIT_KMC_DONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalized() throws AppException {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            this.checkInit();
            int result = this.keFinalize();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("finalize failed result is : " + result);
            }
            this.nativeInitStage = InitStage.JNI_LOADED;
            this.kmcInitConfig = null;
            NativeAPI.nativeStageJni = InitStage.JNI_LOADED;
            globalProperties.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ILogger getLogger() {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            return this.getLoggerInner();
        }
    }

    public byte[] encrypt(byte[] plainText) throws AppException {
        return this.encrypt(this.defaultDomainId, plainText);
    }

    public byte[] encrypt(int domainID, byte[] plainText) throws AppException {
        this.checkInit();
        this.checkEncryptParam(plainText);
        if (CommonUtils.checkAutoUpdateMk(globalProperties) && KmcInitConfig.Role.ROLE_MASTER == this.kmcInitConfig.getRole()) {
            String updateMkProp = globalProperties.getProperty("crypt_key_lifetime_days", null);
            String updateDays = Optional.ofNullable(updateMkProp).orElse((String)((Object)Integer.valueOf(180)));
            int lifeDays = Integer.parseInt(updateDays.toString());
            this.getLogger().debug("lifeDays : " + lifeDays);
            this.checkAndUpdateMk(domainID, lifeDays);
        }
        return this.doEncrypt(domainID, plainText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeNewKey(int domainID) throws AppException {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            this.checkInit();
            int result = this.keActiveNewKey(domainID);
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("ActiveNewKey for domain " + domainID + " failed,result=" + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerKey(int domainID, int keyID, byte[] key) throws AppException {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            this.registerKeyInner(domainID, keyID, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerByteKey(int domainID, int keyID, byte[] key) throws AppException {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            this.registerByteKeyInner(domainID, keyID, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAndUpdateMk(int domainID, int lifeTimeDays) throws AppException {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            this.checkAndUpdateMkInner(domainID, lifeTimeDays);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int importMkFile(String fileName, byte[] pwdText) throws AppException {
        int result;
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            result = this.importMkFileInner(fileName, pwdText);
        }
        return result;
    }

    @Override
    public void removeKeyByKeyID(int domainID, int keyID) throws AppException {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            this.checkInit();
            this.getLogger().info("stage: " + (Object)((Object)this.nativeInitStage) + "domainID: " + domainID);
            int ret = this.keRemoveKeyByID(domainID, keyID);
            if (ret == Errno.KE_RET_SUCCESS.getCode()) {
                return;
            }
            throw new AppException("failed to remove key, error code: " + ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateRootKey() throws AppException {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            this.checkInit();
            int result = this.keUpdateRootKey();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("updateRootKey failed result=" + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void secureEraseKeystore() throws AppException {
        Object object = CRYPTOAPI_LOCK;
        synchronized (object) {
            this.checkInit();
            int result = this.keSecEraseKeystore();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("secEraseKeystore failed result=" + result);
            }
        }
    }

    public String toString() {
        return "**not support toString**";
    }
}

