/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.crypt;

import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.CommonUtils;
import com.huawei.kmc.common.ConfigUtils;
import com.huawei.kmc.common.Errno;
import com.huawei.kmc.common.InitStage;
import com.huawei.kmc.crypt.NativeAPI;
import com.huawei.kmc.entity.KmcInitConfig;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class CryptoAPIEx
extends NativeAPI {
    static final String KMC_VERSION = "KMC 21.0.1";
    private volatile Properties globalPropertiesEx = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLifetimeDays(int updateLifeDays) throws AppException {
        ConfigUtils.checkLifetimeDays(updateLifeDays);
        Object object = this.lock;
        synchronized (object) {
            this.globalPropertiesEx.put("crypt_key_lifetime_days", (Object)updateLifeDays);
        }
    }

    public Properties getProperties() {
        return this.globalPropertiesEx;
    }

    public int getInitStage() {
        return this.nativeInitStage.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties configProps) throws AppException {
        if (configProps == null || configProps.size() == 0) {
            throw new AppException("config properties cannot be null.");
        }
        Properties filterProps = ConfigUtils.checkIntegrityAndFilterProp(configProps);
        Object object = this.lock;
        synchronized (object) {
            this.globalPropertiesEx.clear();
            this.globalPropertiesEx.putAll((Map<?, ?>)filterProps);
            try {
                ConfigUtils.checkCryptoProps(this.globalPropertiesEx);
            }
            catch (AppException e) {
                this.getLogger().error("check property error details");
                throw e;
            }
            this.getLogger().info("init component properties size: " + this.globalPropertiesEx.size());
            KmcInitConfig initConfig = CryptoAPIEx.buildConfig(this.globalPropertiesEx);
            initConfig.setExtendProperties(this.globalPropertiesEx);
            this.initCryptoComponent(initConfig);
        }
    }

    @Override
    protected void setStageStatus() {
        this.nativeInitStage = InitStage.INIT_KMC_DONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalized() throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.checkInit();
            int result = this.keFinalize();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("finalize failed result is : " + result);
            }
            this.nativeInitStage = InitStage.JNI_LOADED;
            this.kmcInitConfig = null;
            this.globalPropertiesEx.clear();
        }
    }

    public byte[] encrypt(byte[] plainText) throws AppException {
        return this.encrypt(this.defaultDomainId, plainText);
    }

    public byte[] encrypt(int domainID, byte[] plainText) throws AppException {
        this.checkInit();
        this.checkEncryptParam(plainText);
        if (CommonUtils.checkAutoUpdateMk(this.globalPropertiesEx) && KmcInitConfig.Role.ROLE_MASTER == this.kmcInitConfig.getRole()) {
            String updateMkProp = this.globalPropertiesEx.getProperty("crypt_key_lifetime_days", null);
            String updateDays = Optional.ofNullable(updateMkProp).orElse((String)((Object)Integer.valueOf(180)));
            int lifeDays = Integer.parseInt(updateDays.toString());
            this.getLogger().debug("lifeDays : " + lifeDays);
            this.checkAndUpdateMk(domainID, lifeDays);
        }
        return this.doEncrypt(domainID, plainText);
    }

    public String toString() {
        return "**not support toString**";
    }
}

