/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.crypt;

import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.CommonUtils;
import com.huawei.kmc.common.Constant;
import com.huawei.kmc.common.Errno;
import com.huawei.kmc.common.HmacAlgorithm;
import com.huawei.kmc.common.IHardwareCallback;
import com.huawei.kmc.common.ILogger;
import com.huawei.kmc.common.INotifyCallback;
import com.huawei.kmc.common.InitStage;
import com.huawei.kmc.common.InnerHashAlgorithm;
import com.huawei.kmc.common.InnerHmacAlgorithm;
import com.huawei.kmc.common.InnerKdfAlgorithm;
import com.huawei.kmc.common.InnerSymmAlgorithm;
import com.huawei.kmc.common.JNIRefObj;
import com.huawei.kmc.common.KdfAlgForPwd;
import com.huawei.kmc.common.KmcMkInfo;
import com.huawei.kmc.common.SdpAlgorithm;
import com.huawei.kmc.entity.KmcExportCfg;
import com.huawei.kmc.entity.KmcImportCfg;
import com.huawei.kmc.entity.KmcInitConfig;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;

public abstract class NativeAPI {
    protected static volatile InitStage nativeStageJni = InitStage.UNINIT;
    static final String DEFAULT_APILIB_NAME = "kmcjni";
    protected volatile InitStage nativeInitStage = InitStage.UNINIT;
    protected IHardwareCallback hardCallBack;
    protected KmcInitConfig kmcInitConfig = null;
    protected final Object lock = new Object();
    private static final Object LOCK = new Object();
    protected int defaultDomainId = 0;
    private static ILogger logger = null;
    private static INotifyCallback notifyCallback = null;
    private long context;

    private static void loadLibs() throws AppException {
        try {
            System.loadLibrary(DEFAULT_APILIB_NAME);
        }
        catch (SecurityException | UnsatisfiedLinkError e) {
            throw new AppException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ILogger getLoggerInner() {
        Object object = LOCK;
        synchronized (object) {
            if (logger != null) {
                return logger;
            }
            logger = new DefaultLogger();
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ILogger getLogger() {
        Object object = this.lock;
        synchronized (object) {
            return this.getLoggerInner();
        }
    }

    protected static KmcInitConfig buildConfig(Properties globalProperties) {
        String primaryKeyStoreFile = globalProperties.getProperty("primary_key_store_file", "");
        String standbyKeyStoreFile = globalProperties.getProperty("standby_key_store_file", "");
        String roleParam = globalProperties.getProperty("crypt_component_role", String.valueOf(1));
        KmcInitConfig.Role kmcRole = Integer.parseInt(roleParam) == 1 ? KmcInitConfig.Role.ROLE_MASTER : KmcInitConfig.Role.ROLE_AGENT;
        String semProp = globalProperties.getProperty("crypt_proc_sem_key");
        String semConfig = semProp == null ? "1227" : semProp;
        Integer semBase = Integer.valueOf("20160000", 16);
        Integer semKey = semBase + Integer.valueOf(semConfig, 16);
        String enableHwPro = globalProperties.getProperty("enableHw");
        String enableHwConfig = enableHwPro == null || enableHwPro.isEmpty() ? "0" : enableHwPro;
        Integer enableHw = Integer.parseInt(enableHwConfig);
        KmcInitConfig initConfig = new KmcInitConfig();
        initConfig.setPrimaryKeyStoreFile(primaryKeyStoreFile);
        initConfig.setStandbyKeyStoreFile(standbyKeyStoreFile);
        initConfig.setRole(kmcRole);
        initConfig.setDomainCount(Integer.parseInt(globalProperties.getProperty("domain_count", "")));
        initConfig.setProcLockPerm(Integer.valueOf(globalProperties.getProperty("crypt_process_perms", "0600"), 8));
        initConfig.setSdpAlgId(SdpAlgorithm.searchByName(globalProperties.getProperty("crypt_symmetric_algorithm", "AES256_GCM")).getValue());
        initConfig.setHmacAlgId(HmacAlgorithm.searchByName(globalProperties.getProperty("crypt_hamc_algorithm", "HMAC_SHA256")).getValue());
        initConfig.setInnerSymmAlgId(InnerSymmAlgorithm.searchByName(globalProperties.getProperty("inner_crypt_symmetric_algorithm", "AES256_GCM")).getValue());
        initConfig.setInnerHashAlgId(InnerHashAlgorithm.searchByName(globalProperties.getProperty("inner_crypt_hash_algorithm", "HASH_SHA256")).getValue());
        initConfig.setInnerHmacAlgId(InnerHmacAlgorithm.searchByName(globalProperties.getProperty("inner_crypt_hmac_algorithm", "HMAC_SHA256")).getValue());
        initConfig.setInnerKdfAlgId(InnerKdfAlgorithm.searchByName(globalProperties.getProperty("inner_crypt_kdf_algorithm", "PBKDF2_HMAC_SHA256")).getValue());
        initConfig.setWorkKeyIter(Integer.parseInt(globalProperties.getProperty("work_key_iter", String.valueOf(1))));
        initConfig.setRootKeyIter(Integer.parseInt(globalProperties.getProperty("root_key_iter", String.valueOf(10000))));
        initConfig.setEnableHw(enableHw);
        initConfig.setSemKey(semKey);
        initConfig.setExtendProperties(globalProperties);
        return initConfig;
    }

    protected static int getInitStageNative() {
        return nativeStageJni.getValue();
    }

    protected void checkInit() throws AppException {
        if (this.nativeInitStage != InitStage.INIT_KMC_DONE) {
            throw new AppException("Not initialized, the stage is: " + (Object)((Object)this.nativeInitStage));
        }
    }

    protected abstract void setStageStatus();

    private int kmcInitialize(KmcInitConfig config) throws AppException {
        Optional.ofNullable(config).orElseThrow(() -> new AppException("config cannot be null."));
        if (this.nativeInitStage == InitStage.INIT_KMC_DONE) {
            this.getLogger().error("api kmc initialize failed, already init before");
            throw new AppException("already init before " + (Object)((Object)this.nativeInitStage));
        }
        if (nativeStageJni == InitStage.UNINIT) {
            throw new AppException("JNI not loaded check your env");
        }
        this.getLogger().info("before kmc initdone.");
        int result = this.keInitialize(config);
        if (result == Errno.KE_RET_SUCCESS.getCode()) {
            this.setStageStatus();
        }
        this.getLogger().info("Kmc init done.");
        return result;
    }

    protected void initCryptoComponent(KmcInitConfig config) throws AppException {
        int result;
        this.getLogger().info("kmc initialize stage: " + ((Object)((Object)nativeStageJni)).getClass().getSimpleName());
        Optional.ofNullable(config).orElseThrow(() -> new AppException("config cannot be null."));
        if (this.kmcInitConfig == null) {
            this.kmcInitConfig = config;
        }
        if ((result = this.kmcInitialize(config)) != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("kmcInitialize failed result is : " + result);
        }
    }

    protected void checkEncryptParam(byte[] plainText) throws AppException {
        if (plainText == null) {
            throw new AppException("plainText cannot be null.");
        }
        if (this.kmcInitConfig == null) {
            throw new AppException("kmcInitConfig should be init.");
        }
    }

    protected byte[] doEncrypt(int domainID, byte[] plainText) throws AppException {
        byte[] cipherText = null;
        JNIRefObj refCipherText = new JNIRefObj();
        int result = this.keEncryptByDomain(domainID, plainText, refCipherText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("Encrypt in domain " + domainID + " failed,result=" + result);
        }
        cipherText = refCipherText.getByteArray();
        return cipherText;
    }

    public byte[] decrypt(byte[] cipherText) throws AppException {
        return this.decrypt(this.defaultDomainId, cipherText);
    }

    public byte[] decrypt(int domainID, byte[] cipherText) throws AppException {
        this.checkInit();
        if (cipherText == null || cipherText.length == 0) {
            throw new AppException("The cipherText cannot be null.");
        }
        JNIRefObj refPlainText = new JNIRefObj();
        int result = this.keDecryptByDomain(domainID, cipherText, refPlainText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("Decrypt in " + domainID + " failed,result=" + result);
        }
        return refPlainText.byteArr;
    }

    public synchronized void setHardCallBack(IHardwareCallback hardCallBack) {
        this.hardCallBack = hardCallBack;
    }

    public byte[] reEncrypt(byte[] cipherText) throws AppException {
        return this.reEncrypt(this.defaultDomainId, cipherText);
    }

    public byte[] reEncrypt(int domainID, byte[] cipherText) throws AppException {
        this.checkInit();
        if (cipherText == null || cipherText.length == 0) {
            throw new AppException("cipherText cannot be null.");
        }
        JNIRefObj refNewCipherText = new JNIRefObj();
        int result = this.keReEncryptByDomain(domainID, cipherText, refNewCipherText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("ReEncrypt in domain " + domainID + " failed,result=" + result);
        }
        return refNewCipherText.getByteArray();
    }

    public void activeNewKey() throws AppException {
        this.activeNewKey(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeNewKey(int domainID) throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.checkInit();
            int result = this.keActiveNewKey(domainID);
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("ActiveNewKey for domain " + domainID + " failed,result=" + result);
            }
        }
    }

    public byte[] genSecBase64Key(int keyLen) throws AppException {
        this.checkInit();
        JNIRefObj refKey = new JNIRefObj();
        int result = this.keGenSecKey(keyLen, refKey);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("genSecKey failed,result=" + result);
        }
        return refKey.byteArr;
    }

    public byte[] genSecByteKey() throws AppException {
        return this.genSecByteKey(32);
    }

    public byte[] genSecByteKey(int keyLen) throws AppException {
        this.checkInit();
        byte[] key = null;
        JNIRefObj refKey = new JNIRefObj();
        int result = this.keGenSecByteKey(keyLen, refKey);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("GenSecByteKey failed,result=" + result);
        }
        key = refKey.getByteArray();
        return key;
    }

    protected void registerKeyInner(int domainID, int keyID, byte[] key) throws AppException {
        this.checkInit();
        if (domainID == 0) {
            throw new AppException("Can't register key in default domain0");
        }
        if (key == null || key.length == 0) {
            throw new AppException("The key cannot be null.");
        }
        int result = this.keRegisterKey(domainID, keyID, key);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("RegisterKey failed,result=" + result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerKey(int domainID, int keyID, byte[] key) throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.registerKeyInner(domainID, keyID, key);
        }
    }

    public void registerByteKey(int domainID, byte[] key) throws AppException {
        this.registerByteKey(domainID, 0, key);
    }

    protected void registerByteKeyInner(int domainID, int keyID, byte[] key) throws AppException {
        this.checkInit();
        if (domainID == 0) {
            throw new AppException("Can't register key in default domain0");
        }
        if (key == null || key.length == 0) {
            throw new AppException("The key cannot be null.");
        }
        int result = this.keRegisterByteKey(domainID, keyID, key);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("RegisterByteKey failed,result=" + result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerByteKey(int domainID, int keyID, byte[] key) throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.registerByteKeyInner(domainID, keyID, key);
        }
    }

    public String getActiveEncodeKey(int domainID) throws AppException {
        return this.getKeyByIDImp(domainID, 0);
    }

    public byte[] getActiveKey(int domainID) throws AppException {
        return this.getKeyByteByID(domainID, 0, false);
    }

    public String getEncodeKeyByID(int domainID, int keyID) throws AppException {
        return this.getKeyByIDImp(domainID, keyID);
    }

    public byte[] getKeyByID(int domainID, int keyID) throws AppException {
        return this.getKeyByteByID(domainID, keyID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeyByIDImp(int domainID, int keyID) throws AppException {
        byte[] key = this.getKeyByteByID(domainID, keyID, true);
        String keyStr = null;
        try {
            if (key != null) {
                keyStr = new String(key, Constant.DEFAULT_CHARSET);
            }
        }
        finally {
            if (key != null) {
                Arrays.fill(key, (byte)0);
            }
        }
        return keyStr;
    }

    private byte[] getKeyByteByID(int domainID, int keyID, boolean encodeInd) throws AppException {
        int result;
        this.checkInit();
        byte[] key = null;
        JNIRefObj refKey = new JNIRefObj();
        int base64Ind = 0;
        if (encodeInd) {
            base64Ind = 1;
        }
        if ((result = this.keGetKeyByID(domainID, keyID, refKey, base64Ind)) != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("getKeyByID failed,result=" + result);
        }
        key = refKey.getByteArray();
        return key;
    }

    public byte[] hmac(int domainID, byte[] plainText) throws AppException {
        this.checkInit();
        if (plainText == null) {
            throw new AppException("plainText cannot be null.");
        }
        JNIRefObj refHmacData = new JNIRefObj();
        int result = this.keHmacByDomain(domainID, plainText, refHmacData);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("Hmac in domain " + domainID + " failed, result=" + result);
        }
        return refHmacData.getByteArray();
    }

    public byte[] protectPwdEx(KdfAlgForPwd algForPwd, int iter, byte[] pwd) throws AppException {
        this.checkInit();
        if (algForPwd == null || pwd == null || pwd.length == 0 || KdfAlgForPwd.searchByName(algForPwd.getStringValue()) == KdfAlgForPwd.PWD_UNKNOWN_ALGORITHM) {
            throw new AppException("algForPwd is unknown or plainText cannot be null.");
        }
        JNIRefObj refPwdProtect = new JNIRefObj();
        int result = this.keProtectPwdEx(algForPwd.getValue(), iter, pwd, refPwdProtect);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("ProtectPwdEx failed result = " + result);
        }
        return refPwdProtect.getByteArray();
    }

    public boolean verifyPwdEx(byte[] pwd, byte[] protectPwd) throws AppException {
        this.checkInit();
        if (pwd == null || pwd.length == 0 || protectPwd == null || protectPwd.length == 0) {
            throw new AppException("pwd or protectPwd is error");
        }
        int result = this.keVerifyPwdEx(pwd, protectPwd);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            if (result == Errno.KE_ERR_PWD_AUTH_FAIL.getCode()) {
                return false;
            }
            throw new AppException("keVerifyPwdEx failed result = " + result);
        }
        return true;
    }

    public byte[] hmacV2(int domainID, byte[] plainText) throws AppException {
        this.checkInit();
        if (plainText == null) {
            throw new AppException("plainText cannot be null.");
        }
        JNIRefObj refHmacData = new JNIRefObj();
        int result = this.keHmacByDomainV2(domainID, plainText, refHmacData);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("HmacV2 in domain " + domainID + " failed, result=" + result);
        }
        return refHmacData.getByteArray();
    }

    public boolean hmacVerify(int domainID, byte[] plainText, byte[] hmacData) throws AppException {
        this.checkInit();
        boolean isVerifySucess = false;
        if (plainText == null) {
            throw new AppException("The plainText cannot be null.");
        }
        if (hmacData == null || hmacData.length == 0) {
            throw new AppException("The hmacData cannot be null.");
        }
        JNIRefObj refResult = new JNIRefObj();
        int result = this.keHmacVerifyByDomain(domainID, plainText, hmacData, refResult);
        if (result == Errno.KE_RET_SUCCESS.getCode()) {
            if (refResult.getIntVal() == 1) {
                isVerifySucess = true;
            }
        } else {
            throw new AppException("HmacVerify in " + domainID + " failed,result=" + result);
        }
        return isVerifySucess;
    }

    public void printAllInfoToLog() {
        this.kePrintAllInfoToLog();
    }

    protected void checkAndUpdateMkInner(int domainID, int lifeTimeDays) throws AppException {
        this.checkInit();
        if (lifeTimeDays < 0 || lifeTimeDays > 180) {
            throw new AppException("lifeTimeDays should be [0 180]");
        }
        int ret = this.keCheckAndUpdateMk(domainID, 180 - lifeTimeDays);
        if (ret == Errno.KE_RET_SUCCESS.getCode()) {
            return;
        }
        throw new AppException("faild to active domain error code " + ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndUpdateMk(int domainID, int lifeTimeDays) throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.checkAndUpdateMkInner(domainID, lifeTimeDays);
        }
    }

    public int getMaxMkID(int domainID) throws AppException {
        this.checkInit();
        int maxKeyID = 0;
        JNIRefObj refMaxKeyID = new JNIRefObj();
        int result = this.keGetMaxMkID(domainID, refMaxKeyID);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("getMaxMkID failed,result=" + result);
        }
        maxKeyID = refMaxKeyID.getIntVal();
        return maxKeyID;
    }

    public boolean isExistMkID(int domainID, int keyID) throws AppException {
        this.checkInit();
        boolean isExist = false;
        JNIRefObj refResult = new JNIRefObj();
        int result = this.keIsExistMkID(domainID, keyID, refResult);
        if (result == Errno.KE_RET_SUCCESS.getCode()) {
            if (refResult.getIntVal() == 1) {
                isExist = true;
            }
        } else {
            throw new AppException("IsExistMkID failed,result=" + result);
        }
        return isExist;
    }

    public int getMkCount() throws AppException {
        this.checkInit();
        return this.keGetMkCount();
    }

    public KmcMkInfo getMkInfo(int idx) throws AppException {
        this.checkInit();
        return this.keGetMkInfo(idx);
    }

    public static synchronized void setJniNotifyCallback(INotifyCallback notifyCallback) {
        if (NativeAPI.notifyCallback != null) {
            return;
        }
        NativeAPI.notifyCallback = notifyCallback;
    }

    public static synchronized void setJniLogger(ILogger logger) {
        if (NativeAPI.logger != null) {
            return;
        }
        NativeAPI.logger = logger;
    }

    public static synchronized void setLogLevel(ILogger.LogLevel level) {
        if (level == null) {
            return;
        }
        NativeAPI.keSetLogLevel(level.ordinal());
    }

    protected int importMkFileInner(String fileName, byte[] pwdText) throws AppException {
        this.checkInit();
        ILogger iLogger = this.getLogger();
        iLogger.info("CryptoAPI importMkFile");
        if (fileName == null || fileName.isEmpty()) {
            throw new AppException("fileName cannot be null");
        }
        if (pwdText == null || pwdText.length == 0) {
            throw new AppException("pwdText cannot be null");
        }
        byte[] fileNameBytes = fileName.getBytes(Constant.DEFAULT_CHARSET);
        int fileNameLen = fileNameBytes.length;
        byte[] concatFileName = new byte[fileNameLen + 1];
        Arrays.fill(concatFileName, (byte)0);
        System.arraycopy(fileNameBytes, 0, concatFileName, 0, fileNameLen);
        int result = this.keImportMkFile(concatFileName, pwdText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            iLogger.error("failed to importMkFile,result = " + result);
            throw new AppException("failed to importMkFile,result = " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importMkFile(String fileName, byte[] pwdText) throws AppException {
        int result;
        Object object = this.lock;
        synchronized (object) {
            result = this.importMkFileInner(fileName, pwdText);
        }
        return result;
    }

    public int exportMkFile(String fileName, byte[] pwdText) throws AppException {
        this.checkInit();
        ILogger iLogger = this.getLogger();
        iLogger.info("CryptoAPI exportMkFile");
        if (fileName == null || fileName.isEmpty()) {
            throw new AppException("fileName cannot be null.");
        }
        if (pwdText == null || pwdText.length == 0) {
            throw new AppException("pwdText cannot be null.");
        }
        byte[] fileNameBytes = fileName.getBytes(Constant.DEFAULT_CHARSET);
        int fileNameLen = fileNameBytes.length;
        byte[] concatFileName = new byte[fileNameLen + 1];
        Arrays.fill(concatFileName, (byte)0);
        System.arraycopy(fileNameBytes, 0, concatFileName, 0, fileNameLen);
        int result = this.keExportMkFile(concatFileName, pwdText);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            iLogger.error("failed to exportMkFile,result = " + result);
            throw new AppException("failed to exportMkFile,result = " + result);
        }
        return result;
    }

    public int importKsf(KmcImportCfg importCfg) throws AppException {
        this.checkInit();
        ILogger iLogger = this.getLogger();
        iLogger.info("CryptoAPI import keystore file");
        if (!importCfg.isValidConfig()) {
            throw new AppException("import config is invalid.");
        }
        int result = this.keImportKsf(importCfg);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            iLogger.error("failed to import keystore file,result = " + result);
            throw new AppException("failed to import keystore file,result = " + result);
        }
        return result;
    }

    public int exportKsf(KmcExportCfg exportCfg) throws AppException {
        this.checkInit();
        ILogger iLogger = this.getLogger();
        iLogger.info("CryptoAPI export keystore file");
        if (!exportCfg.isValidConfig()) {
            throw new AppException("export config is invalid.");
        }
        int result = this.keExportKsf(exportCfg);
        iLogger.error("export keystore file,result = " + result);
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            iLogger.error("failed to export keystore file,result = " + result);
            throw new AppException("failed to export keystore file,result = " + result);
        }
        return result;
    }

    public void removeKeyByKeyID(int domainID, int keyID) throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.checkInit();
            int ret = this.keRemoveKeyByID(domainID, keyID);
            if (ret == Errno.KE_RET_SUCCESS.getCode()) {
                return;
            }
            throw new AppException("failed to remove key, error code: " + ret);
        }
    }

    public synchronized void refreshMkMask() throws AppException {
        this.checkInit();
        int result = this.keRefreshMkMask();
        if (result != Errno.KE_RET_SUCCESS.getCode()) {
            throw new AppException("refreshMkMask failed result=" + result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateRootKey() throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.checkInit();
            int result = this.keUpdateRootKey();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("updateRootKey failed result=" + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void secureEraseKeystore() throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.checkInit();
            int result = this.keSecEraseKeystore();
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("secEraseKeystore failed result=" + result);
            }
        }
    }

    protected int keInitialize(KmcInitConfig kmcInitConfig) {
        return this.keInitializeNative(kmcInitConfig);
    }

    protected int keFinalize() {
        int result = this.keFinalize(this.context);
        this.context = 0L;
        return result;
    }

    protected int keEncryptByDomain(int domainID, byte[] plainText, JNIRefObj refCipherText) {
        return this.keEncryptByDomain(this.context, domainID, plainText, refCipherText);
    }

    protected int keDecryptByDomain(int domainID, byte[] cipherText, JNIRefObj refPlainText) {
        return this.keDecryptByDomain(this.context, domainID, cipherText, refPlainText);
    }

    protected int keReEncryptByDomain(int domainID, byte[] cipherText, JNIRefObj refNewCipherText) {
        return this.keReEncryptByDomain(this.context, domainID, cipherText, refNewCipherText);
    }

    protected int keActiveNewKey(int domainID) {
        return this.keActiveNewKey(this.context, domainID);
    }

    protected int keGenSecKey(int keyLen, JNIRefObj refKey) {
        return this.keGenSecKey(this.context, keyLen, refKey);
    }

    protected int keGenSecByteKey(int keyLen, JNIRefObj refKey) {
        return this.keGenSecByteKey(this.context, keyLen, refKey);
    }

    protected int keRegisterKey(int domainID, int keyID, byte[] key) {
        return this.keRegisterKey(this.context, domainID, keyID, key);
    }

    protected int keRegisterByteKey(int domainID, int keyID, byte[] key) {
        return this.keRegisterByteKey(this.context, domainID, keyID, key);
    }

    protected int keGetKeyByID(int domainID, int keyID, JNIRefObj refKey, int base64Ind) {
        return this.keGetKeyByID(this.context, domainID, keyID, refKey, base64Ind);
    }

    protected int keGetMaxMkID(int domainID, JNIRefObj refMaxKeyID) {
        return this.keGetMaxMkID(this.context, domainID, refMaxKeyID);
    }

    protected int keIsExistMkID(int domainID, int keyID, JNIRefObj refResult) {
        return this.keIsExistMkID(this.context, domainID, keyID, refResult);
    }

    protected int keHmacByDomain(int domainID, byte[] plainText, JNIRefObj refHmacData) {
        return this.keHmacByDomain(this.context, domainID, plainText, refHmacData);
    }

    protected int keProtectPwdEx(int alg, int iter, byte[] pwd, JNIRefObj refProtectPwd) {
        return this.keProtectPwdEx(this.context, alg, iter, pwd, refProtectPwd);
    }

    protected int keVerifyPwdEx(byte[] pwd, byte[] protectPwd) {
        return this.keVerifyPwdEx(this.context, pwd, protectPwd);
    }

    protected int keHmacByDomainV2(int domainID, byte[] plainText, JNIRefObj refHmacData) {
        return this.keHmacByDomainV2(this.context, domainID, plainText, refHmacData);
    }

    protected int keHmacVerifyByDomain(int domainID, byte[] plainText, byte[] hmacData, JNIRefObj refResult) {
        return this.keHmacVerifyByDomain(this.context, domainID, plainText, hmacData, refResult);
    }

    protected int keImportMkFile(byte[] file, byte[] pwdText) {
        return this.keImportMkFile(this.context, file, pwdText);
    }

    protected int keExportMkFile(byte[] file, byte[] pwdText) {
        return this.keExportMkFile(this.context, file, pwdText);
    }

    protected void kePrintAllInfoToLog() {
        this.kePrintAllInfoToLog(this.context);
    }

    protected int keCheckAndUpdateMk(int domainID, int advanceDay) {
        return this.keCheckAndUpdateMk(this.context, domainID, advanceDay);
    }

    protected int keRemoveKeyByID(int domainID, int keyID) {
        return this.keRemoveKeyByID(this.context, domainID, keyID);
    }

    protected int keGetMkCount() {
        return this.keGetMkCount(this.context);
    }

    protected KmcMkInfo keGetMkInfo(int idx) {
        return this.keGetMkInfo(this.context, idx);
    }

    protected int keRefreshMkMask() {
        return this.keRefreshMkMask(this.context);
    }

    protected int keUpdateRootKey() {
        return this.keUpdateRootKey(this.context);
    }

    protected int keSecEraseKeystore() {
        return this.keSecEraseKeystore(this.context);
    }

    protected int keImportKsf(KmcImportCfg importCfg) {
        return this.keImportKsf(this.context, importCfg);
    }

    protected int keExportKsf(KmcExportCfg exportCfg) {
        return this.keExportKsf(this.context, exportCfg);
    }

    private void semKeyIsValid(String key) throws AppException {
        if (!CommonUtils.isNumeric(key)) {
            throw new AppException("semKeyIsValid must be number.");
        }
        Integer min = Integer.valueOf("1111", 16);
        Integer max = Integer.valueOf("9999", 16);
        Integer semConfig = Integer.valueOf(key, 16);
        if (semConfig.compareTo(min) < 0 || semConfig.compareTo(max) > 0) {
            throw new AppException("semKeyIsValid checked result failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSem(String key) throws AppException {
        Object object = this.lock;
        synchronized (object) {
            this.semKeyIsValid(key);
            Integer semBase = Integer.valueOf("20160000", 16);
            Integer semKey = semBase + Integer.valueOf(key, 16);
            Integer semPerm = Integer.valueOf("0600", 8);
            int result = this.keDeleteSem(semKey, semPerm);
            if (result != Errno.KE_RET_SUCCESS.getCode()) {
                throw new AppException("deleteSem failed result = " + result);
            }
        }
    }

    protected static native void keSetLogLevel(int var0);

    private native int keInitializeNative(KmcInitConfig var1);

    private native int keFinalize(long var1);

    private native int keEncryptByDomain(long var1, int var3, byte[] var4, JNIRefObj var5);

    private native int keDecryptByDomain(long var1, int var3, byte[] var4, JNIRefObj var5);

    private native int keReEncryptByDomain(long var1, int var3, byte[] var4, JNIRefObj var5);

    private native int keActiveNewKey(long var1, int var3);

    private native int keGenSecKey(long var1, int var3, JNIRefObj var4);

    private native int keGenSecByteKey(long var1, int var3, JNIRefObj var4);

    private native int keRegisterKey(long var1, int var3, int var4, byte[] var5);

    private native int keRegisterByteKey(long var1, int var3, int var4, byte[] var5);

    private native int keGetKeyByID(long var1, int var3, int var4, JNIRefObj var5, int var6);

    private native int keGetMaxMkID(long var1, int var3, JNIRefObj var4);

    private native int keIsExistMkID(long var1, int var3, int var4, JNIRefObj var5);

    private native int keHmacByDomain(long var1, int var3, byte[] var4, JNIRefObj var5);

    private native int keProtectPwdEx(long var1, int var3, int var4, byte[] var5, JNIRefObj var6);

    private native int keVerifyPwdEx(long var1, byte[] var3, byte[] var4);

    private native int keHmacByDomainV2(long var1, int var3, byte[] var4, JNIRefObj var5);

    private native int keHmacVerifyByDomain(long var1, int var3, byte[] var4, byte[] var5, JNIRefObj var6);

    private native int keImportMkFile(long var1, byte[] var3, byte[] var4);

    private native int keExportMkFile(long var1, byte[] var3, byte[] var4);

    private native void kePrintAllInfoToLog(long var1);

    private native int keCheckAndUpdateMk(long var1, int var3, int var4);

    private native int keRemoveKeyByID(long var1, int var3, int var4);

    private native int keGetMkCount(long var1);

    private native KmcMkInfo keGetMkInfo(long var1, int var3);

    private native int keRefreshMkMask(long var1);

    private native int keUpdateRootKey(long var1);

    private native int keSecEraseKeystore(long var1);

    private native int keImportKsf(long var1, KmcImportCfg var3);

    private native int keExportKsf(long var1, KmcExportCfg var3);

    private native int keDeleteSem(int var1, int var2);

    static {
        try {
            if (nativeStageJni != InitStage.UNINIT) {
                throw new AppException("stage error " + nativeStageJni.ordinal());
            }
            NativeAPI.loadLibs();
            nativeStageJni = InitStage.JNI_LOADED;
        }
        catch (AppException e) {
            System.out.println("JNI library not load check your env status: " + e.getMessage());
        }
    }

    private static class DefaultLogger
    extends ILogger {
        private DefaultLogger() {
        }

        @Override
        public void error(String message) {
        }

        @Override
        public void warn(String message) {
        }

        @Override
        public void info(String message) {
        }

        @Override
        public void debug(String message) {
        }

        @Override
        public void trace(String message) {
        }
    }
}

