/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.alarm.auth;

import com.huawei.common.FileUtil;
import com.huawei.dbtool.WccTool;
import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Scanner;

public class ChangeAuth {
    private static final Log logger = LogFactory.getInstance(ChangeAuth.class);
    private static final String HACONFIG = "/ha/local/conf/ha.properties";
    private static final String USERKEY = "alarm.user";
    private static final String USERPWD = "alarm.password";
    private static final String DBNAME = "LEGO";
    private static final int PASSWORD_ERROR = 2;

    public static void main(String[] stringArray) {
        try (Scanner scanner = new Scanner(System.in);){
            String string = scanner.nextLine();
            ChangeAuth.checkParam(stringArray);
            ChangeAuth.checkAuthInfo(string);
            ChangeAuth.changeHaAuthInfo(string);
            logger.info((Object)"Action: %s exec successful.", stringArray[0]);
            System.exit(0);
        }
        catch (LegoCheckedException legoCheckedException) {
            logger.error((Object)legoCheckedException, "AlarmAction failed.");
            if (legoCheckedException.getErrorCode() == 2L) {
                System.exit(2);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Action: " + stringArray[0] + " exec failed: " + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
        }
        System.exit(1);
    }

    private static void changeHaAuthInfo(String string) {
        String string2 = WccTool.getInstance().encrypt(string);
        FileUtil.modifyConfigFile(ChangeAuth.getHAConfigFile(), USERPWD, string2);
    }

    private static String getHaAlarmAuthUser() {
        File file = new File(ChangeAuth.getHAConfigFile());
        if (!file.exists()) {
            throw new LegoCheckedException("GetHaAlarmAuthUser failed.");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string = properties.getProperty(USERKEY);
            return string;
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, "GetHaAlarmAuthUser failed.");
            throw new LegoCheckedException("GetHaAlarmAuthUser failed.");
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, "Close fip failed.");
                }
            }
        }
    }

    private static String getHAConfigFile() {
        try {
            String string = new File("../").getCanonicalPath();
            String string2 = string + HACONFIG;
            File file = new File(string2);
            if (!file.exists()) {
                throw new FileNotFoundException("Ha config file not found.");
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new LegoCheckedException("GetAuthUser failed.", (Throwable)iOException);
        }
    }

    private static void checkParam(String[] stringArray) {
        if (stringArray.length < 2) {
            throw new LegoCheckedException("CheckParam failed, len=" + stringArray.length);
        }
        if (!"change".equals(stringArray[0])) {
            throw new LegoCheckedException("CheckParam failed, args[0]=" + stringArray[0]);
        }
    }

    private static void checkAuthInfo(String string) {
        User user = new User();
        user.setUserName(ChangeAuth.getHaAlarmAuthUser());
        if (!user.isSyncAdmin()) {
            throw new LegoCheckedException("The user not supported, user: " + user.getUserName());
        }
        DataBaseInfo dataBaseInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        try (Connection connection = LegoDBConnection.getInstance().connectDBWithDba(dataBaseInfo, DBNAME);
             PreparedStatement preparedStatement = ChangeAuth.prepareStatement(connection, user.getUserName());
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if (KmcCompatible.isDataSame((String)string, (String)string3, (String)string2)) continue;
                throw new LegoCheckedException(2L, "new auth is error.");
            }
        }
        catch (LegoCheckedException legoCheckedException) {
            throw legoCheckedException;
        }
        catch (Exception exception) {
            throw new LegoCheckedException("CheckAuthInfo failed: " + ExceptionUtil.getErrorMessage((Throwable)exception));
        }
    }

    private static PreparedStatement prepareStatement(Connection connection, String string) throws LegoCheckedException {
        String string2 = "select USER_PWD,USER_PWD_SALT from t_user where USER_NAME= ?;";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            return preparedStatement;
        }
        catch (SQLException sQLException) {
            logger.error((Object)("Prepare statement failed, SQLException: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)));
            throw new LegoCheckedException("Prepare statement failed.");
        }
    }
}

