/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.sdk.model;

import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.nem.topo.sdk.annotation.XmlProperty;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;

public class ManagedObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6942191502228376235L;
    private static final Log LOG = LogFactory.getInstance(ManagedObject.class);
    private Set<ManagedObject> childMos = new HashSet<ManagedObject>();
    @XmlProperty(Alias="id")
    private Long moId;
    private String uuid;
    @XmlProperty
    private String name;
    private Boolean isGroup;
    private Boolean managed = true;
    @XmlProperty(Alias="node.state")
    private Integer status;
    private Timestamp recentUpdateTime;
    private String type;
    private Boolean canReceiveEvent;
    private ManagedObject parentMo;
    @XmlProperty
    private String description;
    private String path;
    private String domainModelId = "";
    private String domainProductId = "";
    private String subNms;
    private String topMoUuid;
    private Boolean isTopMo = false;
    private String moVersion;
    private Long topoElementId;
    private String perfType;
    private String timezoneFormat;
    private String devAlias;

    public ManagedObject() {
        this.setType(this.getClass().getName());
    }

    public ManagedObject(Long moId) {
        this();
        this.moId = moId;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public void setDevAlias(String devAlias) {
        this.devAlias = devAlias;
    }

    public Long getTopoElementId() {
        return this.topoElementId;
    }

    public void setTopoElementId(Long topoElementId) {
        this.topoElementId = topoElementId;
    }

    public String getMoVersion() {
        return this.moVersion;
    }

    public void setMoVersion(String moVersion) {
        this.moVersion = moVersion;
    }

    public String getTimezoneFormat() {
        if ((this.getIsTopMo().booleanValue() || "Management System".equals(this.name)) && this.timezoneFormat == null) {
            this.timezoneFormat = TimeUtil.getDefaultTimeZone();
        }
        return this.timezoneFormat;
    }

    public void setTimezoneFormat(String timezoneFormat) {
        this.timezoneFormat = timezoneFormat;
        if ((this.getIsTopMo().booleanValue() || "Management System".equals(this.name)) && this.timezoneFormat == null) {
            this.timezoneFormat = TimeUtil.getDefaultTimeZone();
        }
    }

    public String getTopMoUuid() {
        return this.topMoUuid;
    }

    public void setTopMoUuid(String topMoUuid) {
        this.topMoUuid = topMoUuid;
    }

    public Timestamp getRecentUpdateTime() {
        return this.recentUpdateTime;
    }

    public void setRecentUpdateTime(Timestamp recentUpdateTime) {
        this.recentUpdateTime = recentUpdateTime;
    }

    public Long getMoId() {
        return this.moId;
    }

    public void setMoId(Long moId) {
        this.moId = moId;
    }

    public ManagedObject getParentMo() {
        return this.parentMo;
    }

    public void setParentMo(ManagedObject parentMo) {
        this.parentMo = parentMo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isIsGroup() {
        return this.isGroup;
    }

    public void setIsGroup(Boolean isGroup) {
        this.isGroup = isGroup;
    }

    public Boolean getManaged() {
        return this.managed;
    }

    public void setManaged(Boolean managed) {
        this.managed = managed;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getCanReceiveEvent() {
        return this.canReceiveEvent;
    }

    public void setCanReceiveEvent(Boolean canReceiveEvent) {
        this.canReceiveEvent = canReceiveEvent;
    }

    public Long getParentId() {
        if (this.parentMo != null) {
            return this.parentMo.getMoId();
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addChildMo(ManagedObject childMo) {
        this.childMos.add(childMo);
    }

    public Set<ManagedObject> getChildMos() {
        return this.childMos;
    }

    public <T> Set<T> getChildMos(Class<T> clazz) {
        if (null == this.childMos || this.childMos.isEmpty()) {
            return new HashSet();
        }
        HashSet<ManagedObject> results = new HashSet<ManagedObject>();
        for (ManagedObject managedObject : this.childMos) {
            if (!clazz.isInstance(managedObject)) continue;
            results.add(managedObject);
        }
        return results;
    }

    public String getDomainModelId() {
        return this.domainModelId;
    }

    public String getDomainProductId() {
        return this.domainProductId;
    }

    public void setChildMos(Set<ManagedObject> childMos) {
        this.childMos = childMos;
    }

    public void setDomainModelId(String domainModelId) {
        this.domainModelId = domainModelId;
    }

    public void setDomainProductId(String domainProductId) {
        this.domainProductId = domainProductId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getSubNms() {
        return this.subNms;
    }

    public void setSubNms(String subNms) {
        this.subNms = subNms;
    }

    public Boolean getIsTopMo() {
        return this.isTopMo;
    }

    public void setIsTopMo(Boolean isTopMo) {
        this.isTopMo = isTopMo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManagedObject other = (ManagedObject)obj;
        return this.equalsParamOne(other) && this.equalsParamTwo(other) && this.equalsParamThree(other) && this.equalsParamFour(other);
    }

    private boolean equalsParamOne(ManagedObject other) {
        if (this.canReceiveEvent == null ? other.canReceiveEvent != null : !this.canReceiveEvent.equals(other.canReceiveEvent)) {
            return false;
        }
        if (!this.equalsDescription(other)) {
            return false;
        }
        return this.equalsDomainModelId(other);
    }

    private boolean equalsDescription(ManagedObject other) {
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    private boolean equalsDomainModelId(ManagedObject other) {
        return !(this.domainModelId == null ? other.domainModelId != null : !this.domainModelId.equals(other.domainModelId));
    }

    private boolean equalsParamTwo(ManagedObject other) {
        if (!this.overriredEqualsTwo(other)) {
            return false;
        }
        if (this.isTopMo == null ? other.isTopMo != null : !this.isTopMo.equals(other.isTopMo)) {
            return false;
        }
        return !(this.managed == null ? other.managed != null : !this.managed.equals(other.managed));
    }

    private boolean overriredEqualsTwo(ManagedObject other) {
        if (this.domainProductId == null ? other.domainProductId != null : !this.domainProductId.equals(other.domainProductId)) {
            return false;
        }
        return !(this.isGroup == null ? other.isGroup != null : !this.isGroup.equals(other.isGroup));
    }

    private boolean equalsParamThree(ManagedObject other) {
        if (!this.overriedEqualsTree(other)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    private boolean overriedEqualsTree(ManagedObject other) {
        if (this.moId == null ? other.moId != null : !this.moId.equals(other.moId)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    private boolean equalsParamFour(ManagedObject other) {
        if (!this.overriredEqualsFour(other)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    private boolean overriredEqualsFour(ManagedObject other) {
        if (this.subNms == null ? other.subNms != null : !this.subNms.equals(other.subNms)) {
            return false;
        }
        return !(this.topMoUuid == null ? other.topMoUuid != null : !this.topMoUuid.equals(other.topMoUuid));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canReceiveEvent == null ? 0 : this.canReceiveEvent.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.domainModelId == null ? 0 : this.domainModelId.hashCode());
        result = 31 * result + (this.domainProductId == null ? 0 : this.domainProductId.hashCode());
        result = 31 * result + (this.isGroup == null ? 0 : this.isGroup.hashCode());
        result = 31 * result + (this.isTopMo == null ? 0 : this.isTopMo.hashCode());
        result = 31 * result + (this.managed == null ? 0 : this.managed.hashCode());
        result = 31 * result + (this.moId == null ? 0 : this.moId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.recentUpdateTime == null ? 0 : this.recentUpdateTime.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subNms == null ? 0 : this.subNms.hashCode());
        result = 31 * result + (this.topMoUuid == null ? 0 : this.topMoUuid.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public ManagedObject clone() {
        try {
            ManagedObject clonedMo = (ManagedObject)super.clone();
            clonedMo.setChildMos(new HashSet<ManagedObject>());
            return clonedMo;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)("clone exception, this is : " + this), (Throwable)e, 0L);
            throw new LegoUncheckedException("clone exception, this is : " + this, (Throwable)e);
        }
    }

    public String toString() {
        return "ManagedObject [" + "isTopMo=" + this.isTopMo + ", moId=" + this.moId + ", status=" + this.status + ", topMoUuid=" + this.topMoUuid + ", uuid=" + this.uuid + ", timezoneFormat=" + this.timezoneFormat + ", topoElementId=" + this.topoElementId + "]";
    }

    public String getPerfType() {
        return this.perfType;
    }

    public void setPerfType(String perfType) {
        this.perfType = perfType;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

