/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.base.structure;

import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ApplicationStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.EventTrigger;
import com.huawei.lego.core.sdk.base.event.StatusChangedListener;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.base.structure.IApplication;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.base.structure.ISystem;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbsApplication
implements IApplication,
ILifecycle,
DisposableBean {
    private static final Log LOG = LogFactory.getInstance(BaseService.class);
    private List<IService> services = new ArrayList<IService>();
    private List<StatusChangedListener> listeners = new ArrayList<StatusChangedListener>();
    private AppInfo appinfo;
    private ISystem container;
    private Status status;
    private ClassLoader curLoader;
    private String identify;
    private Object lock = new Object();

    public void setIdentify(String uuid) {
        this.identify = uuid;
    }

    public String getIdentify() {
        return this.identify;
    }

    public void setCurLoader(ClassLoader curLoader) {
        this.curLoader = curLoader;
    }

    public ClassLoader getCurLoader() {
        return this.curLoader;
    }

    public AppInfo getAppinfo() {
        return this.appinfo;
    }

    public void setAppinfo(AppInfo appinfo) {
        this.appinfo = appinfo;
    }

    @Override
    public void registerService(IService service) {
    }

    @Override
    public void setContainer(ISystem container) {
        this.container = container;
    }

    public ISystem getContainer() {
        return this.container;
    }

    @Override
    public AppInfo getInfor() {
        return this.appinfo;
    }

    @Override
    public void setAppInfor(AppInfo appInfor) {
        this.appinfo = appInfor;
    }

    @Override
    public IApplication getSelf() {
        return this;
    }

    public void addService(IService service) {
        this.services.add(service);
    }

    public List<IService> getServices() {
        return this.services;
    }

    @Override
    @Deprecated
    public void initialize(ICallback[] callback) {
        Thread.currentThread().setContextClassLoader(this.container.getContextClassLoader());
        if (!this.services.isEmpty()) {
            for (IService service : this.services) {
                if (!(service instanceof ILifecycle)) continue;
                this.container.publishService(this.appinfo, service);
                ((ILifecycle)((Object)service)).initialize(callback);
            }
        }
        Thread.currentThread().setContextClassLoader(this.getCurLoader());
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_INIT);
    }

    @Override
    public void start(List<ICallback> callback) {
        if (!this.services.isEmpty()) {
            for (IService service : this.services) {
                if (!(service instanceof ILifecycle)) continue;
                ((ILifecycle)((Object)service)).start(callback);
            }
        }
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_STARTED);
    }

    @Override
    @Deprecated
    public void stop(ICallback[] callback) {
        List<ServiceInfo> srvInfors = this.appinfo.getServices();
        if (!srvInfors.isEmpty()) {
            Iterator<ServiceInfo> iterator = srvInfors.iterator();
            while (iterator.hasNext()) {
                ServiceInfo srvInfor = iterator.next();
                IService service = (IService)srvInfor.getService();
                if (service instanceof ILifecycle) {
                    ((ILifecycle)((Object)service)).stop(callback);
                }
                this.container.unpublishService(service);
                iterator.remove();
            }
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_STOPED);
    }

    @Override
    public void initialize(List<ICallback> callback) {
        Thread.currentThread().setContextClassLoader(this.container.getContextClassLoader());
        if (!this.services.isEmpty()) {
            for (IService service : this.services) {
                if (!(service instanceof ILifecycle)) continue;
                this.container.publishService(this.appinfo, service);
                ((ILifecycle)((Object)service)).initialize(callback);
            }
        } else {
            ServiceContext.getInstance().register(this.appinfo);
        }
        Thread.currentThread().setContextClassLoader(this.getCurLoader());
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_INIT);
    }

    @Override
    @Deprecated
    public void start(ICallback[] callback) {
        if (!this.services.isEmpty()) {
            for (IService service : this.services) {
                if (!(service instanceof ILifecycle)) continue;
                ((ILifecycle)((Object)service)).start(callback);
            }
        }
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_STARTED);
    }

    @Override
    public void stop(List<ICallback> callback) {
        List<ServiceInfo> srvInforsdd = this.appinfo.getServices();
        if (!srvInforsdd.isEmpty()) {
            Iterator<ServiceInfo> iterator = srvInforsdd.iterator();
            while (iterator.hasNext()) {
                ServiceInfo srvInforp = iterator.next();
                IService servicee = (IService)srvInforp.getService();
                if (servicee instanceof ILifecycle) {
                    ((ILifecycle)((Object)servicee)).stop(callback);
                }
                this.container.unpublishService(servicee);
                iterator.remove();
            }
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_STOPED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusChangeListener(EventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (listener instanceof ApplicationStatusChangedListener) {
                this.listeners.add((ApplicationStatusChangedListener)listener);
            } else {
                LOG.error("listener is not the instance of ApplicationStatusChangedListener!");
            }
        }
    }

    public List getStatusChangeLiserners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remStatusChangeListener(EventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Status getCurrentStatus() {
        return this.status;
    }

    @Override
    public void setCurrentStatus(Status statusParam) {
        this.status = statusParam;
    }

    public void destroy() {
        this.stop(new ArrayList<ICallback>());
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_DESTROYED);
        this.listeners.clear();
    }
}

