/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.common;

import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class ServiceLocator {
    private static final Log logger = LogFactory.getInstance(ServiceLocator.class);
    private static final long CONERR = 51L;
    private static ServiceLocator instance = new ServiceLocator();

    private ServiceLocator() {
    }

    public static final ServiceLocator getInstance() {
        return instance;
    }

    public <T> T getService(Class<T> clazz) {
        if (null == clazz) {
            logger.error("clazz is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Object service = ServiceContext.getInstance().lookup(clazz);
        if (service == null) {
            logger.error("service is null. clazz=" + clazz);
            throw new LegoCheckedException(1073947395L);
        }
        if (clazz.isInstance(service)) {
            return clazz.cast(service);
        }
        logger.error("the service object is null or incompatible with clazz=" + clazz + ", service=" + service);
        throw new LegoCheckedException(1073947395L);
    }

    public static <T> T getBundleService(String bundleName, String serviceName, Class<T> serviceClass) {
        Object service = ServiceLocator.getBundleService(bundleName, serviceName);
        try {
            return serviceClass.cast(service);
        }
        catch (ClassCastException ex) {
            logger.error("getBundleService error :" + bundleName + "/" + serviceName);
            throw new LegoCheckedException(51L, (Throwable)ex);
        }
    }

    public static Object getBundleService(String bundle, String service) {
        ServiceContext context = ServiceContext.getInstance();
        Object obj = context.lookup(bundle + "/" + service);
        if (obj == null) {
            String[] parStrArr = new String[]{"lego.dic.module." + bundle};
            LegoCheckedException le = new LegoCheckedException(51L, parStrArr);
            logger.error((Object)("getBundleService error :" + bundle + "/" + service), (Throwable)le, 653110170615808L);
            throw le;
        }
        return obj;
    }
}

