/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.file.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class FileUtil {
    private static final Log logger;
    private static final Log LOG;
    private static final Charset UTF8;
    private String title;
    private List<String> colTitle;
    private String writeFileName;
    private String strExtend;
    private String strUsrName;
    private String strChar = "UTF-8";

    public void fileSet(String strTitle, List<String> lstColTitle, String strWriteFileName) {
        this.setTitle(strTitle);
        this.setColTitle(lstColTitle);
        this.setWriteFileName(strWriteFileName + "." + this.strExtend);
    }

    public static String getNowTime() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public static void writeDetailFile(String fileName, byte[] logDetail) {
        FileUtil.writeData(new File(fileName), logDetail);
    }

    public static boolean writeText(File file, String text) {
        return FileUtil.writeData(file, text.getBytes(UTF8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeData(File file, byte[] data) {
        FilterOutputStream dos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            dos = new DataOutputStream(fos);
            dos.write(data);
            ((DataOutputStream)dos).flush();
        }
        catch (IOException e) {
            LOG.error((Object)"writeDetailFile", (Throwable)e, 653110170484736L);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != dos) {
                    dos.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"writeDetailFile", (Throwable)e, 653110170484736L);
            }
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"writeDetailFile", (Throwable)e, 653110170484736L);
            }
        }
        return true;
    }

    public abstract void writeFile(List<List<String>> var1);

    public abstract void writeFile(List<List<String>> var1, String var2);

    public abstract void closeFile() throws IOException;

    public static boolean isInSecureDir(Path path) {
        return null != path;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getColTitle() {
        return this.colTitle;
    }

    public void setColTitle(List<String> colTitle) {
        this.colTitle = colTitle;
    }

    public String getWriteFileName() {
        return this.writeFileName;
    }

    public void setWriteFileName(String writeFileName) {
        this.writeFileName = writeFileName;
    }

    public String getStrExtend() {
        return this.strExtend;
    }

    public void setStrExtend(String strExtend) {
        this.strExtend = strExtend;
    }

    public String getStrUsrName() {
        return this.strUsrName;
    }

    public void setStrUsrName(String strUsrName) {
        this.strUsrName = strUsrName;
    }

    public String getStrChar() {
        return this.strChar;
    }

    public void setStrChar(String strChar) {
        this.strChar = strChar;
    }

    public static String readText(File file) {
        return FileUtil.readText(file, 0, null);
    }

    public static String readText(File file, int limit, String message) {
        int length;
        if (!file.exists()) {
            return null;
        }
        Long total = file.length();
        int size = total.intValue();
        if (limit > 0 && file.length() > (long)limit) {
            String error = message != null ? message + " failed. Cause: Exceeded file size limit." : "read file failed. Cause: Exceeded file size limit.";
            throw new LegoCheckedException(error + " limit: " + limit + ", file: " + file.getName());
        }
        byte[] fileContent = new byte[size];
        try (FileInputStream in = new FileInputStream(file);){
            length = in.read(fileContent);
        }
        catch (IOException e) {
            String error = message != null ? message + " failed. " : "read file failed. ";
            logger.error(error + "file: " + file.getName() + ExceptionUtil.getErrorMessage(e));
            throw new LegoCheckedException(error + "file: " + file.getName(), (Throwable)e);
        }
        if (length <= 0) {
            return null;
        }
        try {
            CharsetDecoder decoder = UTF8.newDecoder();
            CharBuffer charbuf = decoder.decode(ByteBuffer.wrap(fileContent));
            return charbuf.toString();
        }
        catch (CharacterCodingException e) {
            logger.error((Object)"not utf-8 charset", e);
            return null;
        }
    }

    public static List<File> listFile(File path) {
        return Optional.ofNullable(path.listFiles()).map(Arrays::asList).orElseGet(Collections::emptyList);
    }

    public static List<String> readLines(File file) {
        String text = FileUtil.readText(file);
        ArrayList<String> lines = new ArrayList<String>();
        if (null != text) {
            String[] strs;
            for (String str : strs = text.split(System.getProperty("line.separator"))) {
                if (null == str || str.isEmpty()) continue;
                lines.add(str);
            }
        }
        return lines;
    }

    public static void writeLines(File file, Collection<String> lines) {
        if (null != lines && !lines.isEmpty() && null != file) {
            String text = String.join((CharSequence)System.getProperty("line.separator"), lines);
            FileUtil.writeText(file, text);
        }
    }

    private static void releaseStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)"Release Stream is Error:", e.getMessage());
            }
        }
    }

    private static String getLineFromFile(BufferedReader bufReader) throws IOException {
        int tempChar;
        StringBuffer strBuf = new StringBuffer();
        while ((tempChar = bufReader.read()) != -1) {
            if (strBuf.length() >= 20000) {
                throw new IOException("input too long");
            }
            if (tempChar == 13) {
                tempChar = bufReader.read();
                if (tempChar == 10) {
                    return strBuf.toString();
                }
                strBuf.append('\r');
            }
            if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                strBuf.append((char)tempChar);
                continue;
            }
            return strBuf.toString();
        }
        if (strBuf.length() > 0) {
            return strBuf.toString();
        }
        return null;
    }

    public static synchronized void modifyPropFileUsingStr(String file, Map<String, String> data, String targetFile) throws IOException {
        FileUtil.modifyPropFileUsingStr(file, data, targetFile, Boolean.FALSE);
    }

    public static synchronized void modifyPropFileUsingStr(String file, Map<String, String> data, String targetFile, boolean preciseMatch) throws IOException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        OutputStreamWriter output = null;
        InputStreamReader input = null;
        FileOutputStream outpuStream = null;
        FileInputStream inputStream = null;
        try {
            File tmpFile = new File(file);
            if (!tmpFile.exists()) {
                logger.error((Object)"The file (%s) is not exists.", tmpFile.getName());
                throw new FileNotFoundException();
            }
            inputStream = new FileInputStream(file);
            input = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(input);
            String text = null;
            StringBuilder sb = new StringBuilder();
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    if (!FileUtil.isMatchPropKey(text, entry.getKey(), preciseMatch)) continue;
                    String value = entry.getValue();
                    if (text.contains(":") && text.contains("=")) {
                        int start = text.indexOf("=");
                        int end = text.lastIndexOf(":");
                        value = text.substring(start + 1, end) + ":" + entry.getValue();
                    }
                    text = entry.getKey() + "=" + value;
                }
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            outpuStream = new FileOutputStream(targetFile);
            output = new OutputStreamWriter((OutputStream)outpuStream, "UTF-8");
            writer = new BufferedWriter(output);
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException e) {
            try {
                logger.error(e, (Object)"ModifyPropFileUsingStr IO Error", new Object[0]);
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(reader);
                FileUtil.releaseStream(input);
                FileUtil.releaseStream(inputStream);
                FileUtil.releaseStream(writer);
                FileUtil.releaseStream(output);
                FileUtil.releaseStream(outpuStream);
                throw throwable;
            }
        }
        FileUtil.releaseStream(reader);
        FileUtil.releaseStream(input);
        FileUtil.releaseStream(inputStream);
        FileUtil.releaseStream(writer);
        FileUtil.releaseStream(output);
        FileUtil.releaseStream(outpuStream);
    }

    private static boolean isMatchPropKey(String text, String key, boolean preciseMatch) {
        if (StringUtils.isEmpty((CharSequence)text) || StringUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        if (preciseMatch) {
            String[] split = text.split("[:=]");
            return StringUtils.equals((CharSequence)split[0], (CharSequence)key);
        }
        return text.startsWith(key);
    }

    static {
        LOG = logger = LogFactory.getInstance(FileUtil.class);
        UTF8 = Charset.forName("utf-8");
    }
}

