/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log;

import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.CodeLog;
import com.huawei.lego.core.sdk.log.DefaultLogConfigurator;
import com.huawei.lego.core.sdk.log.LegoLogger;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.LegoProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class LogFactory
implements Serializable {
    public static final String PRODUCT_LEGO = "com.huawei.lego";
    private static final long serialVersionUID = 7431633055846380526L;
    private static final String CONF_FILE = "conf.properties";
    private static final String KEY_NAME = "app.name";
    private static Map<String, Map<String, Log>> logs = new HashMap<String, Map<String, Log>>();
    private static Map<Long, Map<String, CodeLog>> codeLogs = new HashMap<Long, Map<String, CodeLog>>();

    private LogFactory() {
    }

    public static Log getInstance(Object obj) {
        return LogFactory.getInstance(obj, true, null);
    }

    public static Log getInstance(Object obj, String logName) {
        return LogFactory.getInstance(obj, true, logName);
    }

    public static Log getInstance(Object obj, boolean showLocSrc) {
        return LogFactory.getInstance(obj, showLocSrc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getInstance(Object obj, boolean showLocSrc, String logName) {
        if (null == obj) {
            return new LegoLogger(PRODUCT_LEGO);
        }
        Class<?> classOb = null;
        classOb = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (null == classOb) {
            return new LegoLogger(PRODUCT_LEGO);
        }
        ClassLoader classLoader = classOb.getClassLoader();
        if (null == classLoader) {
            return new LegoLogger(PRODUCT_LEGO);
        }
        Class<?> nowClass = classLoader.getClass();
        if (nowClass != null && "org.apache.catalina.loader.WebappClassLoader".equals(nowClass.getName())) {
            return new LegoLogger(PRODUCT_LEGO);
        }
        String jarfileName = AdapterUtils.getClassJarPath(classOb);
        if (null == jarfileName || jarfileName.length() <= 0) {
            return new LegoLogger(PRODUCT_LEGO);
        }
        Log log = LogFactory.getCacheLog(jarfileName, logName);
        Map<String, Map<String, Log>> map = logs;
        synchronized (map) {
            if (null == log) {
                log = LogFactory.getLog(jarfileName, classLoader, logName);
            }
        }
        log.setShowLocSrc(showLocSrc);
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Log getLog(String jarFileName, ClassLoader cl, String logName) {
        LegoLogger log = null;
        if (null == logName) {
            Properties props = new Properties();
            InputStream is = null;
            try {
                URL url = AdapterUtils.getUrlResourceFromJar(cl, jarFileName, CONF_FILE);
                if (null != url) {
                    is = url.openStream();
                    props.load(is);
                }
            }
            catch (IOException e) {
                LogFactory.ignoreException();
            }
            finally {
                LogFactory.closeStream(is);
            }
            String product = props.getProperty(KEY_NAME);
            if (null != product && product.length() > 0) {
                DefaultLogConfigurator.configurator(product);
                log = new LegoLogger("com.huawei.lego." + product);
            } else {
                log = new LegoLogger(PRODUCT_LEGO);
            }
        } else {
            DefaultLogConfigurator.configurator(logName);
            log = new LegoLogger("com.huawei.lego." + logName);
        }
        LogFactory.saveLog(jarFileName, logName, log);
        return log;
    }

    private static void saveLog(String jarFileName, String logName, Log log) {
        Map<String, Log> logMap = logs.get(jarFileName);
        if (null == logMap) {
            logMap = new HashMap<String, Log>();
        }
        logMap.put(logName, log);
        logs.put(jarFileName, logMap);
    }

    private static Log getCacheLog(String cl, String logName) {
        Map<String, Log> logMap = logs.get(cl);
        if (null == logMap || null == logName) {
            return null;
        }
        return logMap.get(logName);
    }

    private static void closeStream(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                LogFactory.getInstance(LegoProperties.class).error((Object)"Close the inputstream failed about conf.properties error is:", (Throwable)e, 1L);
            }
        }
    }

    public static CodeLog getInstance(Object obj, long logCode) {
        return LogFactory.getInstance(obj, true, logCode);
    }

    public static CodeLog getInstance(Object obj, long logCode, String logName) {
        return LogFactory.getInstance(obj, true, logCode, logName);
    }

    public static CodeLog getInstance(Object obj, boolean showLocSrc, long logCode) {
        return LogFactory.getInstance(obj, showLocSrc, logCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeLog getInstance(Object obj, boolean showLocSrc, long logCode, String logName) {
        if (null == obj) {
            return new LegoLogger("com.huawei.lego." + logCode, logCode);
        }
        ClassLoader cl = null;
        cl = obj instanceof Class ? ((Class)obj).getClassLoader() : obj.getClass().getClassLoader();
        if (null == cl) {
            return new LegoLogger("com.huawei.lego." + logCode, logCode);
        }
        if (cl.getClass().getName().equals("org.apache.catalina.loader.WebappClassLoader")) {
            return new LegoLogger("com.huawei.lego." + logCode, logCode);
        }
        CodeLog codeLog = LogFactory.getCacheCodeLog(logCode, logName);
        Map<Long, Map<String, CodeLog>> map = codeLogs;
        synchronized (map) {
            if (null == codeLog) {
                codeLog = LogFactory.getLog(cl, logCode, logName);
            }
        }
        codeLog.setShowLocSrc(showLocSrc);
        return codeLog;
    }

    private static CodeLog getCacheCodeLog(long logCode, String logName) {
        Map<String, CodeLog> codeLogMap = codeLogs.get(logCode);
        if (null == codeLogMap) {
            return null;
        }
        return codeLogMap.get(logName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CodeLog getLog(ClassLoader cl, long logCode, String logName) {
        LegoLogger codeLog = null;
        if (null == logName) {
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = cl.getResourceAsStream(CONF_FILE);
                props.load(is);
            }
            catch (Exception e) {
                LogFactory.ignoreException();
            }
            finally {
                LogFactory.closeStream(is);
            }
            String product = props.getProperty(KEY_NAME);
            if (null != product && product.length() > 0) {
                DefaultLogConfigurator.configurator(product, logCode);
                codeLog = new LegoLogger("com.huawei.lego." + product + logCode, logCode);
            } else {
                codeLog = new LegoLogger("com.huawei.lego." + logCode, logCode);
            }
        } else {
            DefaultLogConfigurator.configurator(logName, logCode);
            codeLog = new LegoLogger("com.huawei.lego." + logName + logCode, logCode);
        }
        LogFactory.saveCodeLog(logCode, logName, codeLog);
        return codeLog;
    }

    private static void saveCodeLog(long logCode, String logName, CodeLog codeLog) {
        Map<String, CodeLog> codeLogMap = codeLogs.get(logCode);
        if (null == codeLogMap) {
            codeLogMap = new HashMap<String, CodeLog>();
        }
        codeLogMap.put(logName, codeLog);
        codeLogs.put(logCode, codeLogMap);
    }

    private static void ignoreException() {
    }
}

