/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log.filter;

import com.huawei.lego.core.sdk.log.filter.FlagMarker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(name="SensitiveFlagFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public class SensitiveFlagFilter
extends AbstractFilter {
    private static final Logger log = LoggerFactory.getLogger(SensitiveFlagFilter.class);
    private static Set<String> aliasLowerDefaultSet = new HashSet<String>(Arrays.asList("psw", "pwd"));
    private static Set<String> standardLowerDefaultSet = new HashSet<String>(Arrays.asList("account", "email", "mac", "password", "cookie", "token", "headers", "auth", "session", "ticket", "crypt", "cmd", "command"));
    private Set<String> aliasLowerSet;
    private Set<String> standardLowerSet;
    private String sensitivePathPrefix = "com.huawei";
    private FlagMarker flagMarker = FlagMarker.INSTANCE;

    private SensitiveFlagFilter(String sensitivePathPrefix, String aliasSensitiveStr, String standardSensitiveStr, Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
        if (sensitivePathPrefix != null && !sensitivePathPrefix.isEmpty()) {
            this.sensitivePathPrefix = sensitivePathPrefix;
        }
        this.standardLowerSet = standardSensitiveStr != null && !standardSensitiveStr.isEmpty() ? Arrays.stream(standardSensitiveStr.split("\\|")).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()) : standardLowerDefaultSet;
        this.aliasLowerSet = aliasSensitiveStr != null && !aliasSensitiveStr.isEmpty() ? Arrays.stream(aliasSensitiveStr.split("\\|")).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()) : aliasLowerDefaultSet;
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable throwable) {
        if (this.skipPrefix(logger)) {
            return this.getOnMismatch();
        }
        String formatMessage = logger.getMessageFactory().newMessage(msg).getFormattedMessage();
        return this.filterSensitiveInformation(logger, level, formatMessage);
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable throwable) {
        if (this.skipPrefix(logger)) {
            return this.getOnMismatch();
        }
        return this.filterSensitiveInformation(logger, level, msg.getFormattedMessage());
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
        if (this.skipPrefix(logger)) {
            return this.getOnMismatch();
        }
        if (params.length > 0 && params[params.length - 1].getClass().isInstance((Object)this.flagMarker)) {
            return this.getOnMismatch();
        }
        return this.filterSensitiveInformation(logger, level, logger.getMessageFactory().newMessage(msg, params).getFormattedMessage());
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object param) {
        if (this.skipPrefix(logger)) {
            return this.getOnMismatch();
        }
        if (param.getClass().isInstance((Object)this.flagMarker)) {
            return this.getOnMismatch();
        }
        return this.filterSensitiveInformation(logger, level, logger.getMessageFactory().newMessage(msg, new Object[]{param}).getFormattedMessage());
    }

    private boolean skipPrefix(org.apache.logging.log4j.core.Logger logger) {
        return !logger.getName().startsWith(this.sensitivePathPrefix);
    }

    private Filter.Result filterSensitiveInformation(org.apache.logging.log4j.core.Logger logger, Level level, String formatMessage) {
        String formatMessageLow = formatMessage.toLowerCase(Locale.ROOT).replaceAll(" ", "");
        for (String prefix : this.standardLowerSet) {
            if (!formatMessageLow.contains(prefix + ":")) continue;
            logger.log(level, prefix + " ************", (Object)this.flagMarker);
            return this.getOnMatch();
        }
        for (String prefix : this.aliasLowerSet) {
            if (!formatMessageLow.contains(prefix + ":")) continue;
            logger.log(level, prefix + " #############", (Object)this.flagMarker);
            return this.getOnMatch();
        }
        return this.getOnMismatch();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<SensitiveFlagFilter> {
        @PluginBuilderAttribute
        private String aliasSensitiveStr;
        @PluginBuilderAttribute
        private String standardSensitiveStr;
        @PluginBuilderAttribute
        private String sensitivePathPrefix;

        public SensitiveFlagFilter build() {
            return new SensitiveFlagFilter(this.sensitivePathPrefix, this.aliasSensitiveStr, this.standardSensitiveStr, this.getOnMatch(), this.getOnMismatch());
        }
    }
}

