/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.ism.drm.wcc.util.utils.FileWatchService;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class LegoConfig {
    private static final Log LOGGER = LogFactory.getInstance(LegoConfig.class);
    private static final String SYSTEM_PROPERTIES = "conf/lego.properties";
    private static final String NODE_CONFIG = "conf/node.properties";
    private static final String DEPLOY_CONFIG = "conf/legoDeploy.conf";
    private static final String ARB_CONFIG = "conf/arb.properties";
    private static final Map<String, LegoConfig> INSTANCES = new HashMap<String, LegoConfig>();
    private static final String SYS_DEFAULT_DBPASSWORD_ISCHANGED = "sys.default.dbpassword.ischanged";
    private static final String SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED = "sys.default.managerdbpassword.ischanged";
    private String path;
    private Properties properties;
    private long updateTime;

    private LegoConfig(String path) {
        this.path = path;
        this.readConfigProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigProperties() {
        File file = new File(this.path);
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            InputStreamReader inputReader = null;
            try {
                fileInputStream = new FileInputStream(file);
                inputReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
                Properties props = new Properties();
                props.load(inputReader);
                this.setProperties(props);
                this.setUpdateTime(System.currentTimeMillis());
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)"Read lego.properties fail, error:%s.", ExceptionUtil.getErrorMessage(e));
                }
                catch (Throwable throwable) {
                    CommonUtil.close(inputReader);
                    CommonUtil.close(fileInputStream);
                    throw throwable;
                }
                CommonUtil.close(inputReader);
                CommonUtil.close(fileInputStream);
            }
            CommonUtil.close(inputReader);
            CommonUtil.close(fileInputStream);
        }
    }

    public synchronized void reloadConfigProperties() {
        this.readConfigProperties();
    }

    public void setConfigValue(String key, String value) {
        this.setConfigValue(key, value, Boolean.FALSE);
    }

    public void setConfigValue(String key, String value, boolean preciseMatch) {
        if (key == null || value == null) {
            LOGGER.error("SetConfigValue failed, cause key or value is null.");
            return;
        }
        Map<String, String> data = Collections.singletonMap(key, value);
        try {
            FileUtil.modifyPropFileUsingStr(this.path, data, this.path, preciseMatch);
            this.reloadConfigProperties();
        }
        catch (IOException e) {
            LOGGER.error((Object)"SetConfigValue failed, error:%s.", ExceptionUtil.getErrorMessage(e));
            throw new LegoCheckedException(-1L);
        }
    }

    public static LegoConfig getInstance() {
        return LegoConfig.getInstance(SYSTEM_PROPERTIES);
    }

    public static LegoConfig getNodeConfig() {
        return LegoConfig.getInstance(NODE_CONFIG);
    }

    public static LegoConfig getArbConfig() {
        return LegoConfig.getInstance(ARB_CONFIG);
    }

    public static LegoConfig getDeployConfig() {
        return LegoConfig.getInstance(DEPLOY_CONFIG);
    }

    public static synchronized LegoConfig getInstance(String path) {
        LegoConfig config = INSTANCES.get(path);
        if (config == null) {
            config = new LegoConfig(path);
            INSTANCES.put(path, config);
        }
        return config;
    }

    public String getKeyValue(String key) {
        String value = "";
        if (null != this.properties) {
            value = this.properties.getProperty(key);
        }
        return value;
    }

    public String getKeyValue(String key, String defaultValue) {
        String value = this.getKeyValue(key);
        value = value != null ? Normalizer.normalize(value, Normalizer.Form.NFKC) : defaultValue;
        return value;
    }

    public long getNumber(String key, long defaultValue) {
        long num;
        String value = this.getKeyValue(key, String.valueOf(defaultValue));
        LOGGER.info((Object)"Get value from config file with key, key:%s value:%s.", key, value);
        value = value != null ? value : "";
        value = value.replaceAll("^\\s*|\\s*$", "");
        value = value.matches("^\\d+$") ? value : String.valueOf(defaultValue);
        try {
            num = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Number format error for %s , will use default value:%s.", key, defaultValue);
            num = defaultValue;
        }
        return num;
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(key, () -> defaultValue);
    }

    public int getInt(String key, Supplier<Integer> defaultValueSupplier) {
        if (this.properties == null) {
            return defaultValueSupplier.get();
        }
        String property = this.properties.getProperty(key);
        if (property == null) {
            return defaultValueSupplier.get();
        }
        try {
            return Integer.parseInt(property.trim());
        }
        catch (NumberFormatException e) {
            int defaultValue = defaultValueSupplier.get();
            LOGGER.error((Object)"Number format error for %s , will use default value: %s.", key, defaultValue);
            return defaultValue;
        }
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public static synchronized void updateInstance() {
        LegoConfig config = INSTANCES.get(SYSTEM_PROPERTIES);
        if (config != null) {
            config.reloadConfigProperties();
            INSTANCES.put(SYSTEM_PROPERTIES, config);
        }
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.getKeyValue(key, String.valueOf(defaultValue));
        if (!VerifyUtil.isEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static void diffDataBaseConfig(Map<String, String> data) {
        String fileName = PathUtil.getRuntimePath() + File.separator + "bin" + File.separator + "config" + File.separator + "system.xml";
        File file = new File(fileName);
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures(sax);
            Document document = sax.read(file);
            Node node = document.selectSingleNode("/install/database");
            if (!(node instanceof Element)) {
                LOGGER.error("Node is not instanceof document.");
                return;
            }
            Element dbElement = (Element)node;
            String enDbpassword = dbElement.attributeValue("dbpassword");
            if (!WccEncryptor.decrypt(enDbpassword).equals(WccEncryptor.decrypt(LegoConfig.getInstance().getKeyValue("sys.default.dbPwd", "")))) {
                data.put(SYS_DEFAULT_DBPASSWORD_ISCHANGED, "true");
            } else {
                data.put(SYS_DEFAULT_DBPASSWORD_ISCHANGED, "false");
            }
            String enManagerdbusername = dbElement.attributeValue("managerpassword");
            if (!WccEncryptor.decrypt(enManagerdbusername).equals(WccEncryptor.decrypt(LegoConfig.getInstance().getKeyValue("sys.default.managerdbPwd", "")))) {
                data.put(SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED, "true");
            } else {
                data.put(SYS_DEFAULT_MANAGERDBPASSWORD_ISCHANGED, "false");
            }
        }
        catch (DocumentException | SAXException e1) {
            LOGGER.error((Object)"Parse document error: %s.", e1);
        }
    }

    public Set<String> getArbRegionIdList() {
        HashSet<String> regionIdList = new HashSet<String>();
        if (Boolean.parseBoolean(this.properties.getProperty("arb.enable", "false"))) {
            regionIdList.add(LegoConfig.getNodeConfig().getKeyValue("config.hcs.node.region"));
        }
        List regionAutoRecoveryKeys = this.properties.stringPropertyNames().stream().filter(e -> e.endsWith(".arb.enable")).collect(Collectors.toList());
        for (String key : regionAutoRecoveryKeys) {
            regionIdList.add(key.substring(0, key.indexOf(".arb.enable")));
        }
        return regionIdList;
    }

    static {
        Optional runtimePathOption = SysPropertiesUtils.getRuntimePath();
        if (runtimePathOption.isPresent()) {
            try {
                FileWatchService.registerTask((String)Paths.get((String)runtimePathOption.get(), "/LegoRuntime/conf/lego.properties").getParent().toString(), (String)"lego.properties", LegoConfig::updateInstance);
            }
            catch (IOException e) {
                LOGGER.error((Object)"LegoConfig initialize fail, msg:%s", ExceptionUtil.getErrorMessage(e));
                throw new ExceptionInInitializerError("LegoConfig initialize fail.");
            }
        } else {
            LOGGER.info("RuntimePath not find, skip register file watch task.");
        }
    }
}

