/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class LegoProperties {
    public static final String KEY_RUNTIME_PATH = "Runtime.path";
    private static final String DEFAULT_PROPERTIES = "default.properties";
    private static final Properties PROPS = new Properties();
    private static final Log LOG = LogFactory.getInstance(LegoProperties.class);

    private static void getConfigFromFile() {
        InputStream is = null;
        try {
            ClassLoader clazzLoader = LegoProperties.class.getClassLoader();
            if (null != clazzLoader) {
                is = clazzLoader.getResourceAsStream(DEFAULT_PROPERTIES);
            }
            if (null != is) {
                PROPS.load(is);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"read default.properties fail.", (Throwable)e, 0L);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Close the input stream about default.propertieserror is:", (Throwable)e, 0L);
                }
            }
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)PROPS);
        System.setProperties(sysProps);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public static int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            return 0;
        }
        return NumberUtil.convertToInteger(value);
    }

    public static int getPort() {
        return LegoProperties.getInt("base.rmi_port");
    }

    public static int getTrapPort() {
        return LegoProperties.getInt("base.trap_port");
    }

    public static String getIPAddress() {
        return PROPS.getProperty("base.appmanager_server");
    }

    public static boolean isInstalledIntegrated() {
        String isInIntegrated = LegoProperties.getProperty("is.integrated.in.iemp", "false");
        return Boolean.valueOf(isInIntegrated);
    }

    public static String getStorageFilePath() {
        File currentfile = new File(".");
        String path = "";
        try {
            path = currentfile.getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error((Object)"getStorageFilePath getCanonicalPath() error!", 102L);
        }
        return path + File.separator;
    }

    static {
        LegoProperties.getConfigFromFile();
    }
}

