/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class SafeBufferedReader
extends BufferedReader {
    private static final int DEFAULT_MAX_LINES = 2048;
    private static final int DEFAULT_MAX_LINE_LENGTH = 4096;
    private static final int CR = 13;
    private static final int LF = 10;
    private int readerMaxLines;
    private int readerMaxLineLen;
    private int currentLine = 1;

    public SafeBufferedReader(Reader reader, int maxLines, int maxLineLen) {
        super(reader);
        if (maxLines <= 0 || maxLineLen <= 0) {
            throw new LegoCheckedException("maxLines and maxLineLen must be greater than 0");
        }
        this.readerMaxLines = maxLines;
        this.readerMaxLineLen = maxLineLen;
    }

    public SafeBufferedReader(Reader reader) {
        super(reader);
        this.readerMaxLines = 2048;
        this.readerMaxLineLen = 4096;
    }

    @Override
    public String readLine() throws IOException {
        if (this.currentLine > this.readerMaxLines) {
            throw new IOException("Line read limit(" + this.readerMaxLines + ") has been reached.");
        }
        ++this.currentLine;
        int currentPos = 0;
        char[] data = new char[this.readerMaxLineLen];
        int currentCharVal = super.read();
        while (currentCharVal != 13 && currentCharVal != 10 && currentCharVal >= 0) {
            data[currentPos++] = (char)currentCharVal;
            if (currentPos >= this.readerMaxLineLen) break;
            currentCharVal = super.read();
        }
        return this.readResult(currentPos, data, currentCharVal);
    }

    private String readResult(int currentPos, char[] data, int currentCharVal) throws IOException {
        if (currentCharVal < 0) {
            return this.getResultWhenEndFile(currentPos, data);
        }
        if (currentCharVal == 13) {
            super.mark(1);
            this.dealNewlineChar();
        } else if (currentCharVal != 10) {
            super.mark(1);
            int nextCharVal = super.read();
            if (nextCharVal == 13) {
                super.mark(1);
                this.dealNewlineChar();
            } else if (nextCharVal != 10) {
                super.reset();
            }
        }
        return new String(data, 0, currentPos);
    }

    private void dealNewlineChar() throws IOException {
        if (super.read() != 10) {
            super.reset();
        }
    }

    private String getResultWhenEndFile(int currentPos, char[] data) {
        if (currentPos > 0) {
            return new String(data, 0, currentPos);
        }
        return null;
    }
}

