/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Map;

public final class VerifyUtil {
    private static final Log logger = LogFactory.getInstance(VerifyUtil.class);

    private VerifyUtil() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return null == collection || collection.isEmpty();
    }

    public static boolean isEmpty(Object obj) {
        return null == obj || obj instanceof String && ((String)obj).isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isEmpty(String string) {
        return null == string || string.trim().isEmpty();
    }

    public static boolean isNone(String string) {
        return null == string || string.isEmpty();
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isEmpty(Object[][] objects) {
        if (objects == null || objects.length == 0) {
            return true;
        }
        for (Object[] objectArray : objects) {
            if (objectArray.length == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEmpty(Collection<?> collection) {
        if (collection == null || collection.size() == 0) {
            return true;
        }
        return collection.stream().allMatch(VerifyUtil::isEmpty);
    }

    public static boolean isMultiEmpty(Object ... obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (null != obj[i]) continue;
            return true;
        }
        return false;
    }

    public static void checkObject(Object checkedObj) {
        if (null == checkedObj) {
            throw new LegoCheckedException(201L);
        }
    }

    public static void checkStrs(String ... strs) {
        VerifyUtil.checkObjs(strs);
    }

    public static void checkObjs(Object ... objects) {
        if (null == objects) {
            logger.error("parameter error.");
            throw new LegoCheckedException(1073947393L);
        }
        if (objects.length == 0) {
            logger.info("parameter is empty.");
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!VerifyUtil.isEmpty(objects[i])) continue;
            logger.error("parameter error, index=" + i);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static <E> void generalCheckLength(Collection<E> objList) {
        int maxLength = 256;
        if (VerifyUtil.isEmpty(objList)) {
            logger.error("Parameter is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (objList.size() > maxLength) {
            logger.error((Object)"Parameter error, length = %s", String.valueOf(objList.size()));
            throw new LegoCheckedException(1073947393L);
        }
    }
}

