/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class AESEncryptor {
    private static final Log LOG = LogFactory.getInstance(AESEncryptor.class);

    private static void setWccFile() {
        String currPath = "";
        try {
            currPath = new File(System.getProperty("user.dir")).getCanonicalPath();
        }
        catch (IOException e) {
            currPath = "";
        }
        String conf = "LegoRuntime" + File.separator + "conf" + File.separator + "wcc";
        String wccConf = currPath.substring(0, currPath.length() - "bin".length()) + conf;
        try {
            KmcInstance.initComponent((String)wccConf);
        }
        catch (Exception e) {
            LOG.error((Object)"Set wcc file error.");
        }
    }

    public static String wccDecrypt(String key) {
        try {
            return KmcInstance.decrypt((String)key);
        }
        catch (Exception e) {
            LOG.error((Object)"Wcc decrypt error.");
            return null;
        }
    }

    public static void importWccConfig(String file, String decryptPwd) {
        try {
            KmcInstance.getSoftInstance().importMkFile(file, decryptPwd.getBytes(StandardCharsets.UTF_8));
            String hwFile = file.replace("wcc.conf", "wcc-hw.conf");
            KmcInstance.getHwInstance().importMkFile(hwFile, decryptPwd.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOG.error((Object)"Import wcc config error.");
        }
    }

    static {
        AESEncryptor.setWccFile();
    }
}

