/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import com.huawei.ism.drm.configbackup.ErrHandleTask;
import com.huawei.ism.drm.configbackup.ExceptionUtil;
import com.huawei.ism.drm.configbackup.Printer;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmdUtil {
    private static final Log LOG = LogFactory.getInstance(CmdUtil.class);
    private static final String errLog = "logs/importDBErr.log";
    private static final String infoLog = "logs/importDBInput.log";

    public static void runShell(String shPath, String[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append(shPath.replace("\\/", "/"));
        if (params != null && params.length > 0) {
            for (String param : params) {
                sb.append(" ").append(param);
            }
        }
        CmdUtil.runShell(sb.toString());
    }

    public static boolean checkParam(String param, String match, int minSize, int maxSize) throws Exception {
        if (param == null || match == null || 0 > minSize || 0 > maxSize || minSize > maxSize) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" regEx :");
            sb.append(match);
            sb.append(" minSize :");
            sb.append(minSize);
            sb.append(" maxSize :");
            sb.append(maxSize);
            sb.append(" is error.");
            LOG.info((Object)sb.toString(), "");
            throw new Exception();
        }
        if (minSize > param.length() || maxSize < param.length()) {
            return false;
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runShell(String shStr) {
        LOG.info((Object)"start restore configdata, please wait...");
        Printer.println("Start restore configdata, please wait...");
        InputStreamReader input = null;
        BufferedReader inputBr = null;
        InputStreamReader err = null;
        BufferedReader errBr = null;
        try {
            Process process = Runtime.getRuntime().exec(shStr);
            input = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
            inputBr = new BufferedReader(input);
            ErrHandleTask inputTask = new ErrHandleTask(inputBr, infoLog);
            err = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
            errBr = new BufferedReader(err);
            ErrHandleTask errTask = new ErrHandleTask(errBr, errLog);
            Thread inputT = new Thread(inputTask);
            Thread errT = new Thread(errTask);
            inputT.setName("ErrHandleTask-execStrCmd-input");
            errT.setName("ErrHandleTask-execStrCmd-error");
            inputT.setUncaughtExceptionHandler((thread, ex) -> LOG.error((Object)"ErrHandleTask-execStrCmd-input uncaughtException!"));
            errT.setUncaughtExceptionHandler((thread, ex) -> LOG.error((Object)"ErrHandleTask-execStrCmd-error uncaughtException!"));
            inputT.start();
            errT.start();
            process.waitFor();
            LOG.info((Object)"Restore successfully, Please restart the Server.", "");
            Printer.println("Restore successfully, please restart the Server.");
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Failed restoreLinuxMysql:" + ExceptionUtil.getErrorMessage(e)));
                Printer.println("Failed restoreLinuxMysql.");
            }
            catch (Throwable throwable) {
                CmdUtil.releaseStream(inputBr);
                CmdUtil.releaseStream(input);
                CmdUtil.releaseStream(errBr);
                CmdUtil.releaseStream(err);
                throw throwable;
            }
            CmdUtil.releaseStream(inputBr);
            CmdUtil.releaseStream(input);
            CmdUtil.releaseStream(errBr);
            CmdUtil.releaseStream(err);
        }
        CmdUtil.releaseStream(inputBr);
        CmdUtil.releaseStream(input);
        CmdUtil.releaseStream(errBr);
        CmdUtil.releaseStream(err);
    }

    private static void releaseStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Release Stream is Error:", e.getMessage());
            }
        }
    }
}

