/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import com.huawei.cipher.EncryptedPropertiesHandler;
import com.huawei.cipher.FileSignHandler;
import com.huawei.ism.drm.configbackup.AESEncryptor;
import com.huawei.ism.drm.configbackup.AESUtil;
import com.huawei.ism.drm.configbackup.CmdUtil;
import com.huawei.ism.drm.configbackup.ExceptionUtil;
import com.huawei.ism.drm.configbackup.PortCheckUtil;
import com.huawei.ism.drm.configbackup.Printer;
import com.huawei.ism.drm.configbackup.ZipUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GaussDBrestoreImpl {
    private static final Log LOG = LogFactory.getInstance(GaussDBrestoreImpl.class);
    private static boolean isSaltFileExist = false;
    private static final String RMI_PORT = "rmi.port";
    private static final String GAUSS_RESTORE_DIR_KEY = "gauss.restore.dir";
    private static final String DEFAULT_GAUSS_RESTORE_DIR_KEY = File.separator + "home" + File.separator + "DRManager";
    private static String backupDataDir = "";
    private static String exportFile = "";
    private static final String LINUX_RESTORE = "/usr/local/gaussdb/bin/gsql";
    private static final String WCC_FILE = "wcc.conf";
    private static final int APM_PORT_PARAM_MAX_SZIE = 65535;
    private static final String RUNTIME_FILE = System.getProperties().getProperty("user.dir").substring(0, System.getProperties().getProperty("user.dir").lastIndexOf("Runtime") + "Runtime".length()) + File.separator + "bin" + File.separator + "config" + File.separator + "conf" + File.separator + "config.properties";
    private static final String INSTALLED_FILE = "config/system.xml";
    private static final String KMC_PATH = "/Runtime/LegoRuntime/conf/wcc";
    private static final int USER_NAME_MIN_LENGTH = 4;
    private static final int USER_NAME_MAX_LENGTH = 8;
    private static final String USER_NAME_REX = "^[A-Za-z]+$";
    private static byte[] SALT = new byte[128];
    private static byte[] IV = new byte[16];
    private static String encryptFile = "";
    private static String tmpPath = "";
    private String host = "";
    private String port = "";
    private String userName = "";
    private String userPass = "";
    private String superUserName = "";
    private String superUserPass = "";
    private String dbName = "lego";
    private int[] ports = new int[3];
    private String installPath = System.getProperties().getProperty("user.dir").substring(0, System.getProperties().getProperty("user.dir").lastIndexOf("Runtime") + "Runtime".length());
    private String encryptPassword = null;

    public GaussDBrestoreImpl() throws Exception {
        this.parseConf();
        this.parseXML();
    }

    public static boolean isIsSaltFileExist() {
        return isSaltFileExist;
    }

    public static byte[] getSalt() {
        return SALT;
    }

    public static byte[] getIV() {
        return IV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDB(File fileLoc) {
        String importFile = this.getEncryptFile(fileLoc);
        try {
            if ("".equals(importFile)) {
                Printer.println("Decrypt file failed.");
                LOG.error((Object)"Get encrypt file failed.", "");
                return;
            }
            this.load(importFile);
        }
        catch (Exception e) {
            LOG.error((Object)("ImportDB error." + ExceptionUtil.getErrorMessage(e)));
            Printer.println("ImportDB error.");
        }
        finally {
            File path = new File(tmpPath);
            this.deleteTmpFiles(path);
        }
    }

    private boolean checkSystemRuning() {
        int sysStatus = PortCheckUtil.checkSystemUsing(this.ports);
        if (-1 != sysStatus) {
            Printer.println("The system is in using, please stop the system and retry!");
            return false;
        }
        return true;
    }

    private String getEncryptFile(File zipFile) {
        String zip = "";
        try {
            GaussDBrestoreImpl.getSaltAndIV(zipFile);
        }
        catch (Exception e) {
            File path = new File(tmpPath);
            this.deleteTmpFiles(path);
        }
        File file = new File(encryptFile);
        if (file.exists()) {
            zip = encryptFile;
        }
        return zip;
    }

    private void deleteTmpFiles(File path) {
        if (path.exists() && path.isDirectory()) {
            File[] tmpFiles;
            for (File tmp : tmpFiles = path.listFiles()) {
                tmp.delete();
            }
            path.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectionGaussDB() {
        Connection conn = null;
        boolean isValid = false;
        try {
            String url = "jdbc:postgresql://" + this.host + ":" + this.port + "/POSTGRES?ssl=true&sslfactory=org.postgresql.ssl.NonValidatingFactory";
            Class.forName("org.postgresql.Driver");
            conn = DriverManager.getConnection(url, this.superUserName, this.superUserPass);
            isValid = this.clearDB(conn);
        }
        catch (Exception e) {
            LOG.error((Object)("Connection database failed." + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("Connection database failed.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    LOG.error((Object)("DB Connection Close Error" + ExceptionUtil.getErrorMessage(e1)), "");
                    Printer.println("DB connection Close Error");
                }
            }
        }
        return isValid;
    }

    private void parseConf() {
        LOG.debug((Object)"Start parseConf", "");
        try (FileInputStream in = new FileInputStream(RUNTIME_FILE);){
            Properties conf = new Properties();
            conf.load(in);
            this.ports[2] = Integer.parseInt(conf.getProperty(RMI_PORT, "-1"));
            backupDataDir = conf.getProperty(GAUSS_RESTORE_DIR_KEY, DEFAULT_GAUSS_RESTORE_DIR_KEY);
        }
        catch (Exception e) {
            LOG.error((Object)String.format(Locale.ROOT, "Failed parseConf %s", ExceptionUtil.getErrorMessage(e)));
            Printer.println("Failed parseConf");
        }
        LOG.debug((Object)"Success parseConf", "");
    }

    private void parseXML() throws Exception {
        LOG.debug((Object)"Start parseXML", "");
        try {
            File file = new File(INSTALLED_FILE);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            CommonUtil.setSecurityFeatures((DocumentBuilderFactory)factory);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nl = doc.getElementsByTagName("install");
            int size = nl.getLength();
            for (int i = 0; i < size; ++i) {
                Element bookElement = (Element)nl.item(i);
                NodeList childNodes = bookElement.getChildNodes();
                int sizeChild = childNodes.getLength();
                for (int j = 0; j < sizeChild; ++j) {
                    Node node = childNodes.item(j);
                    this.degradeParseXML(node);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed parseXML: " + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("Failed parseXML");
        }
        this.checkParam();
        LOG.debug((Object)"Success parseXML", "");
    }

    private void checkParam() throws Exception {
        if (this.isEmpty(this.userName) || this.isEmpty(this.host) || this.isEmpty(this.userPass) || this.isEmpty(this.port) || this.isEmpty(this.superUserName) || this.isEmpty(this.superUserPass)) {
            LOG.info((Object)"Check param failed~!", "");
            throw new Exception();
        }
        if (!CmdUtil.checkParam(this.userName, USER_NAME_REX, 4, 8) || !CmdUtil.checkParam(this.superUserName, USER_NAME_REX, 4, 8)) {
            LOG.info((Object)"Check param failed~!", "");
            throw new Exception();
        }
        if (!this.checkDrmPortParam(this.port) || !this.checkIpParam().booleanValue()) {
            LOG.info((Object)"Check param failed~!", "");
            throw new Exception();
        }
    }

    private boolean checkDrmPortParam(String portStr) throws Exception {
        int drmPort = 0;
        try {
            drmPort = Integer.valueOf(portStr);
        }
        catch (NumberFormatException e) {
            LOG.info((Object)"Check port is error . parm: %s", portStr);
            throw new Exception();
        }
        return drmPort > 0 && 65535 >= drmPort;
    }

    private Boolean checkIpParam() throws Exception {
        String matchIp = "(2[2][0-3]|2[0-1]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})";
        return this.checkParam(this.host, matchIp);
    }

    private boolean checkParam(String param, String match) throws Exception {
        if (this.isEmpty(param) || this.isEmpty(match)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Check param is error.");
            sb.append(" regEx :");
            sb.append(match);
            sb.append(" is error.");
            LOG.error((Object)sb.toString(), "");
            Printer.println(sb.toString());
            throw new Exception();
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && mat.groupCount() >= 0;
    }

    private static void releaseStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Release Stream is Error:", e.getMessage());
            }
        }
    }

    private boolean isEmpty(String string) {
        return null == string || string.trim().isEmpty();
    }

    private void degradeParseXML(Node node) {
        if (node.getNodeType() == 1) {
            if ("database".equals(node.getNodeName())) {
                NamedNodeMap nnm = node.getAttributes();
                this.host = nnm.getNamedItem("dbhost").getNodeValue();
                this.port = nnm.getNamedItem("dbport").getNodeValue();
                this.userName = nnm.getNamedItem("dbuserName").getNodeValue();
                this.userPass = AESEncryptor.wccDecrypt(nnm.getNamedItem("dbpassword").getNodeValue());
                this.superUserName = nnm.getNamedItem("manageruserName").getNodeValue();
                this.superUserPass = AESEncryptor.wccDecrypt(nnm.getNamedItem("managerpassword").getNodeValue());
            } else if ("httport".equals(node.getNodeName())) {
                this.ports[0] = this.parsePort(node.getTextContent());
            } else if ("httpsport".equals(node.getNodeName())) {
                this.ports[1] = Integer.parseInt(node.getTextContent());
            } else {
                LOG.warn((Object)("NodeName is not supported.nodeName:" + node.getNodeName()), "");
            }
        }
    }

    private int parsePort(String port) {
        if (port == null || !port.matches("\\s*\\d+\\s*")) {
            return -1;
        }
        return Integer.parseInt(port.trim());
    }

    private static void getSaltAndIV(File zipFile) throws Exception {
        FileInputStream salt = null;
        FileInputStream iv = null;
        File saltF = null;
        File ivF = null;
        try {
            File[] files;
            tmpPath = ZipUtil.getInstallPath() + File.separator + "Runtime" + File.separator + "tmp" + File.separator + "tmpSql";
            ZipUtil.getInstance().unzipFile(tmpPath, zipFile);
            String saltFile = tmpPath + File.separator + "zip1.tmp";
            String ivFile = tmpPath + File.separator + "zip2.tmp";
            saltF = new File(saltFile);
            if (saltF.exists()) {
                salt = new FileInputStream(saltF);
                ((InputStream)salt).read(SALT);
                isSaltFileExist = true;
            }
            ivF = new File(ivFile);
            iv = new FileInputStream(ivF);
            ((InputStream)iv).read(IV);
            for (File file1 : files = new File(tmpPath).listFiles()) {
                if (file1.getName().endsWith(".zip")) {
                    encryptFile = tmpPath + File.separator + file1.getName();
                }
                if (!WCC_FILE.equals(file1.getName())) continue;
                exportFile = tmpPath + File.separator + WCC_FILE;
            }
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Get salt or iv data failed." + ExceptionUtil.getErrorMessage(e)), "");
                throw e;
            }
            catch (Throwable throwable) {
                GaussDBrestoreImpl.closeStream(salt);
                GaussDBrestoreImpl.closeStream(iv);
                ivF.delete();
                saltF.delete();
                throw throwable;
            }
        }
        GaussDBrestoreImpl.closeStream(salt);
        GaussDBrestoreImpl.closeStream(iv);
        ivF.delete();
        saltF.delete();
    }

    private static void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Close stream failed.", (Throwable)e, "");
        }
    }

    private File uncryptFile(String fileLoc) {
        File file = new File(fileLoc);
        if (!file.exists()) {
            Printer.println("File is not exist.");
            LOG.error((Object)"File is not exist.", "");
            return null;
        }
        String password = this.encryptPassword != null ? this.encryptPassword : this.userPass;
        File zipFile = AESUtil.getInstance().decryptFile(file, ".zip", password);
        File file1 = null;
        if (zipFile == null) {
            LOG.error((Object)"Decrypt file failed, please check your password.", "");
            return file1;
        }
        try {
            file1 = ZipUtil.getInstance().unzipFile(file.getParent(), zipFile);
        }
        catch (Exception e) {
            LOG.error((Object)("Unzip file error: " + ExceptionUtil.getErrorMessage(e)), "");
        }
        zipFile.delete();
        return file1;
    }

    private void load(String fileLoc) throws Exception {
        File file = this.uncryptFile(fileLoc);
        if (null == file) {
            return;
        }
        if (!file.getName().endsWith(".sql")) {
            Printer.println("Decrypt file failed, please check your password and unzip properties.");
            LOG.info((Object)"The file is not correct. fileName=%s.", file.getName());
            return;
        }
        if (!this.connectionGaussDB()) {
            return;
        }
        this.checkParam();
        String filePath = this.installPath.split("Runtime")[0];
        EncryptedPropertiesHandler encryptedPropertiesHandler = new EncryptedPropertiesHandler("", filePath + KMC_PATH);
        encryptedPropertiesHandler.beforeBackup(filePath);
        File wccConf = new File(exportFile);
        AESEncryptor.importWccConfig(wccConf.getCanonicalPath(), this.encryptPassword);
        encryptedPropertiesHandler.afterBackup(filePath);
        this.loadLinux(file.getCanonicalPath());
        new FileSignHandler(filePath + KMC_PATH, filePath);
        try {
            file.delete();
        }
        catch (Exception e) {
            Printer.println("Unsuccessful to delete the temp file: " + ExceptionUtil.getErrorMessage(e));
            LOG.info((Object)"Unsuccessful to delete the temp file.", "");
        }
    }

    private void loadLinux(String sqlFile) {
        StringBuffer param = new StringBuffer();
        param.append(" -h").append(this.host);
        param.append(" -U").append(GaussDBrestoreImpl.encodeForLinux(this.userName));
        param.append(" -p ").append(GaussDBrestoreImpl.encodeForLinux(this.port));
        param.append(" -W ").append(this.userPass);
        param.append(" ").append(GaussDBrestoreImpl.encodeForLinux(this.dbName));
        param.append(" -f ").append(sqlFile.contains(" ") ? "\"" + sqlFile + "\"" : sqlFile);
        try {
            CmdUtil.runShell(LINUX_RESTORE, new String[]{param.toString()});
        }
        catch (Exception e) {
            LOG.error((Object)("LoadLinux error: " + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("LoadLinux error.");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            GaussDBrestoreImpl msdi = new GaussDBrestoreImpl();
            if (!msdi.checkSystemRuning()) {
                return;
            }
            String fileLoc = args[0];
            if (msdi.isEmpty(fileLoc)) {
                Printer.println("File is null or empty.");
                return;
            }
            File file = new File(FilenameUtils.normalize((String)fileLoc));
            if (!file.getCanonicalPath().startsWith(backupDataDir)) {
                Printer.println(String.format(Locale.ROOT, "The restore file should be located in directory: %s.", backupDataDir));
                return;
            }
            if (!file.exists()) {
                Printer.println("File is not exists.");
                return;
            }
            if (args.length > 1 && "TRUE".equals(args[1])) {
                char[] password = System.console().readPassword("Please input old encrypt password:", new Object[0]);
                msdi.encryptPassword = password != null ? new String(password) : null;
            }
            msdi.importDB(file);
        }
        System.exit(0);
    }

    private Boolean clearDB(Connection gaussDBConn) {
        String dropScript = "DROP DATABASE if exists " + this.dbName + ";";
        String createScript = "CREATE DATABASE " + this.dbName + " WITH TEMPLATE = TEMPLATE0 ENCODING 'UTF8';";
        String ownerScript = "ALTER DATABASE " + this.dbName + " OWNER TO " + this.userName;
        String connLimit = "ALTER DATABASE " + this.dbName + " CONNECTION LIMIT=100;";
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add(dropScript);
        scripts.add(createScript);
        scripts.add(ownerScript);
        scripts.add(connLimit);
        return this.runScripts(scripts, gaussDBConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runScripts(List<String> sqlScripts, Connection gaussDBConn) {
        Statement stmt = null;
        int size = sqlScripts.size();
        Printer.println("Start to clear the database.");
        try {
            LOG.error((Object)"chmod++++++++++++++++++++++", "");
            stmt = gaussDBConn.createStatement();
            for (int index = 0; index < size; ++index) {
                String sql = sqlScripts.get(index);
                stmt.execute(sql);
            }
            Printer.println("Clear the database successfully!");
            boolean sql = true;
            return sql;
        }
        catch (Exception e) {
            LOG.error((Object)("Create statement failed.run sql failed:" + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("Fail to clear the database");
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Create statement close failed: " + ExceptionUtil.getErrorMessage(e)));
                }
            }
        }
    }

    private static String encodeForLinux(String str) {
        char[] charArray;
        if (str == null) {
            return "";
        }
        StringBuilder encoded = new StringBuilder();
        for (char c : charArray = str.toCharArray()) {
            if ('-' == c || GaussDBrestoreImpl.isNumber(c) || GaussDBrestoreImpl.isAlphabet(c)) {
                encoded.append(c);
                continue;
            }
            encoded.append("\\").append(c);
        }
        return encoded.toString();
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphabet(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }
}

