/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import com.huawei.ism.drm.configbackup.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ZipUtil {
    private static final ZipUtil INSTANCE = new ZipUtil();
    private static final Log LOG = LogFactory.getInstance(ZipUtil.class);

    private ZipUtil() {
    }

    public static ZipUtil getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File unzipFile(String directory, File zipFile) throws Exception {
        String name = "";
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            File parent = new File(directory);
            if (!parent.exists() && !parent.mkdirs()) {
                throw new Exception("Create the dir \"" + parent.getName() + "\" failed.");
            }
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                File file = new File(directory + File.separator + name);
                return file;
            }
            name = this.writeFileToDirectory(directory, name, zis, ze);
            return new File(FilenameUtils.normalize((String)(directory + File.separator + name)));
        }
        catch (Exception e) {
            LOG.error((Object)("Unzip file failed." + ExceptionUtil.getErrorMessage(e)));
            throw e;
        }
    }

    private String writeFileToDirectory(String directory, String name, ZipInputStream zis, ZipEntry ze) throws IOException {
        long totalFileCount = 0L;
        long totalFileSize = 0L;
        byte[] buffer = new byte[10240];
        while (ze != null) {
            name = ze.getName();
            String entryFilePath = CommonUtil.sanitizeFileName((String)directory, (String)name);
            try (FileOutputStream output = new FileOutputStream(entryFilePath);){
                if (!ze.isDirectory()) {
                    CommonUtil.zipFileNumCheck((long)(++totalFileCount));
                }
                int bytesRead = zis.read(buffer);
                while (bytesRead > 0) {
                    CommonUtil.zipBombCheck((long)(totalFileSize += (long)bytesRead));
                    output.write(buffer, 0, bytesRead);
                    bytesRead = zis.read(buffer);
                }
                output.flush();
            }
            catch (IOException e) {
                LOG.error((Object)("Unzip file failed." + ExceptionUtil.getErrorMessage(e)));
            }
            ze = zis.getNextEntry();
        }
        return name;
    }

    public static String getInstallPath() throws DocumentException, SAXException {
        String installFile = "RDInstalled.xml";
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(installFile));
            Element installElement = (Element)document.selectSingleNode("/install/installpath");
            return installElement.attribute("path").getValue();
        }
        catch (DocumentException | SAXException e) {
            LOG.error((Object)"Get install path failed.", "");
            throw e;
        }
    }
}

