/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.install.log.filter;

import java.io.FileNotFoundException;
import java.net.BindException;
import java.security.acl.NotOwnerException;
import java.sql.SQLException;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.jar.JarException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.InsufficientResourcesException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(name="ExceptionFilter", category="Core", elementType="filter", printObject=true)
@PerformanceSensitive(value={"allocation"})
public final class ExceptionFilter
extends AbstractFilter {
    private static final Logger log = LoggerFactory.getLogger(ExceptionFilter.class);
    private static final List<Class> EXCEPTION_CLASS = Stream.of(FileNotFoundException.class, JarException.class, MissingResourceException.class, NotOwnerException.class, ConcurrentModificationException.class, InsufficientResourcesException.class, BindException.class, OutOfMemoryError.class, StackOverflowError.class, SQLException.class).collect(Collectors.toList());

    private ExceptionFilter(Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable throwable) {
        return this.filterSensitiveException(throwable);
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable throwable) {
        return this.filterSensitiveException(throwable);
    }

    private Filter.Result filterSensitiveException(Throwable throwable) {
        return EXCEPTION_CLASS.stream().filter((? super T clazz) -> clazz.isInstance(throwable)).peek(clazz -> this.logSensitiveThrowable(clazz.getSimpleName(), throwable)).findAny().map(clazz -> this.onMatch).orElse(this.onMismatch);
    }

    private void logSensitiveThrowable(String throwableName, Throwable throwable) {
        Throwable filterThrowable = new Throwable(throwableName);
        filterThrowable.setStackTrace(throwable.getStackTrace());
        log.error(throwableName, filterThrowable);
    }

    private Filter.Result filter(Throwable throwable) {
        return EXCEPTION_CLASS.stream().anyMatch(cls -> throwable.getClass().equals(cls)) ? this.onMatch : this.onMismatch;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<ExceptionFilter> {
        public Builder setMatchString() {
            return this;
        }

        public ExceptionFilter build() {
            return new ExceptionFilter(this.getOnMatch(), this.getOnMismatch());
        }
    }
}

