/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.util;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class CommonUtil {
    private static final Log LOG = LogFactory.getInstance(CommonUtil.class);
    private static final int MAX_LEN = 0xFFFFFFE;
    private static final String SP = File.separator;
    private static long maxFileCount;
    private static long maxTotalFileSize;
    private static final long DEFAULT_MAX_FILE_COUNT = 1000L;
    private static final long DEFAULT_MAX_TOTAL_FILE_SIZE = 0x40000000L;
    private static final String FILENAME_INVALID_ERROR_MSG = "The ZIP package contains invalid fileName.";
    private static final String FILE_NUM_OVER_LIMIT_ERROR_MSG = "The ZIP package contains too many files.";
    private static final String FILE_SIZE_TOO_LARGE_ERROR_MSG = "Zip Bomb! File size is too large.";

    private static void setUnZipFileProperties() {
        try {
            String currPath = new File(System.getProperty("user.dir")).getCanonicalPath();
            String conf = "LegoRuntime" + File.separator + "conf" + File.separator + "lego.properties";
            String legoConf = currPath.substring(0, currPath.length() - "bin".length()) + conf;
            File file = new File(legoConf);
            Properties properties = new Properties();
            properties.load(Files.newInputStream(file.toPath(), new OpenOption[0]));
            maxFileCount = Long.parseLong(properties.getProperty("unzip.max.file.count", String.valueOf(1000L)));
            maxTotalFileSize = Long.parseLong(properties.getProperty("unzip.max.total.file.size", String.valueOf(0x40000000L)));
            maxFileCount = Math.min(maxFileCount, 3000L);
            maxTotalFileSize = Math.min(maxTotalFileSize, 0xC0000000L);
        }
        catch (IOException ex) {
            maxFileCount = 1000L;
            maxTotalFileSize = 0x40000000L;
        }
    }

    public static boolean isEmpty(String string) {
        return null == string || string.trim().isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return null == collection || collection.isEmpty();
    }

    public static void closeStream(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOG.error((Object)("Close strean failed, errmsg=" + ExceptionUtil.getErrorMessage(e)), "");
            }
        }
    }

    public static String getInstallPath() {
        File file = new File("/home/ICUser/RDInstalled.xml");
        if (!file.exists()) {
            LOG.error((Object)"Can not find the RDInstalled.xml.", "");
            throw new RuntimeException("Can not find the RDInstalled.xml.");
        }
        try {
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures(sax);
            Document document = sax.read(file);
            String installPath = "";
            List list = document.selectNodes("/install/installpath");
            if (null != list && !list.isEmpty()) {
                Element ele = (Element)list.get(0);
                installPath = ele.attributeValue("path");
            }
            if (CommonUtil.isEmpty(installPath)) {
                throw new RuntimeException("Can not find the install path.");
            }
            File path = new File(installPath);
            if (!path.exists() || !path.isDirectory()) {
                LOG.error((Object)"Can not find the eReplcation install path.", "");
                throw new RuntimeException("Can not find the eReplication server install path.");
            }
            return installPath;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get install path info. errMsg=%s" + ExceptionUtil.getErrorMessage(e)), "");
            throw new RuntimeException();
        }
    }

    public static void setSecurityFeatures(SAXReader reader) throws SAXException {
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    public static void setSecurityFeatures(DocumentBuilderFactory factory) throws ParserConfigurationException {
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    public static String decrypt(String data) {
        String wccHome = CommonUtil.getInstallPath() + SP + "Runtime" + SP + "LegoRuntime" + SP + "conf" + SP + "wcc";
        File path = new File(wccHome);
        if (!path.exists() || !path.isDirectory()) {
            LOG.error((Object)"Init wcc failed, can not find the home path.", "");
            throw new RuntimeException();
        }
        try {
            KmcInstance.initComponent((String)wccHome);
            return KmcInstance.decrypt((String)data);
        }
        catch (Exception e) {
            LOG.error((Object)"Init wcc failed, can not find the home path.", "");
            return null;
        }
    }

    public static String getLineFromFile(BufferedReader bufReader) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int tempChar;
            while ((tempChar = bufReader.read()) != -1) {
                if (strBuf.length() >= 0xFFFFFFE) {
                    throw new IOException("input too long");
                }
                if (tempChar == 13) {
                    tempChar = bufReader.read();
                    if (tempChar == 10) {
                        return strBuf.toString();
                    }
                    strBuf.append('\r');
                }
                if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                    strBuf.append((char)tempChar);
                    continue;
                }
                return strBuf.toString();
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (strBuf.length() > 0) {
            return strBuf.toString();
        }
        return null;
    }

    public static String sanitizeFileName(String directory, String fileName) throws IOException {
        File parentFile = new File(directory);
        File childFile = new File(directory, fileName);
        String childPath = childFile.getCanonicalPath();
        if (childPath.startsWith(parentFile.getCanonicalPath())) {
            return childPath;
        }
        LOG.error(FILENAME_INVALID_ERROR_MSG);
        throw new IOException(FILENAME_INVALID_ERROR_MSG);
    }

    public static void zipFileNumCheck(long totalFileCount) throws IOException {
        if (totalFileCount > maxFileCount) {
            LOG.error(FILE_NUM_OVER_LIMIT_ERROR_MSG);
            throw new IOException(FILE_NUM_OVER_LIMIT_ERROR_MSG);
        }
    }

    public static void zipBombCheck(long totalFileSize) throws IOException {
        if (totalFileSize > maxTotalFileSize) {
            LOG.error(FILE_SIZE_TOO_LARGE_ERROR_MSG);
            throw new IOException(FILE_SIZE_TOO_LARGE_ERROR_MSG);
        }
    }

    static {
        CommonUtil.setUnZipFileProperties();
    }
}

