/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.arbitration.security;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.security.ArbSecurityCertificateManager;
import com.huawei.ism.drm.arbitration.util.ArbProperties;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.exception.EtcdServerException;
import com.huawei.lego.comm.security.KeyStoreX509TrustManager;
import java.io.File;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Locale;

public class ArbX509TrustManager
extends KeyStoreX509TrustManager {
    private static final String RUNTIME_DIR;
    private static final String KEYSTORE_FILE;
    private EtcdConfig etcdConfig;

    public ArbX509TrustManager(EtcdConfig etcdConfig, boolean isForceCheckCert) throws EtcdServerException {
        super(KEYSTORE_FILE, String.join((CharSequence)",", Arrays.toString(etcdConfig.getServer())), ArbSecurityCertificateManager.getDefaultKeyStore(KEYSTORE_FILE, etcdConfig), isForceCheckCert);
        this.etcdConfig = etcdConfig;
    }

    public void reloadTrustManager() {
        try {
            KeyStore keyStore = ArbSecurityCertificateManager.getDefaultKeyStore(KEYSTORE_FILE, this.etcdConfig);
            this.trustManager = ArbX509TrustManager.getTrustManager((KeyStore)keyStore);
        }
        catch (EtcdServerException e) {
            LogManager.error(String.format(Locale.ROOT, "ArbX509TrustManager reloadTrustManager failed, msg: %s", LogManager.getErrorMessage(e)));
        }
    }

    static {
        ArbProperties.getInstance();
        RUNTIME_DIR = ArbProperties.getRuntimePath();
        KEYSTORE_FILE = RUNTIME_DIR + File.separator + "LegoRuntime" + File.separator + "certs" + File.separator + "arb.keystore";
    }
}

