/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.arbitration.util;

import com.huawei.ism.drm.arbitration.log.LogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;

public class ArbProperties {
    private static ArbProperties instance = null;
    private static final Properties PROPS = new Properties();
    private static final String ARB_FILE = File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "arb.properties";
    private static final String LEGO_PROPERTIES = File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "lego.properties";
    private static final String[] PROPERTIES_FILES = new String[]{ARB_FILE, LEGO_PROPERTIES};
    private static final String LEGO_RUNTIME_DIR = "LegoRuntime";
    private static final String RUNTIME_DIR = "Runtime/bin";
    public static final String BUSINESS_ARB_ENABLE = ".arb.enable";
    public static final String BUSINESS_ARB_LOCAL_AZ = ".arb.localAZ";
    public static final String BUSINESS_ARB_REMOTE_AZ = ".arb.remoteAZ";

    public static ArbProperties getInstance() {
        if (null == instance) {
            instance = new ArbProperties();
        }
        for (int i = 0; i < PROPERTIES_FILES.length; ++i) {
            ArbProperties.loadProperties(PROPERTIES_FILES[i]);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(String propertiesFile) {
        File file = new File(ArbProperties.getRuntimePath() + propertiesFile);
        if (!file.exists()) {
            LogManager.error(String.format(Locale.ROOT, "%s file is not exist", propertiesFile));
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            PROPS.load(fileInputStream);
        }
        catch (IOException e) {
            LogManager.error(String.format(Locale.ROOT, "load %s file is fail, cause by " + LogManager.getErrorMessage(e), propertiesFile));
            return;
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e2) {
                    LogManager.error("close load arb.properties file fileInputStream failed, cause by " + LogManager.getErrorMessage(e2));
                }
            }
        }
    }

    public static String getRuntimePath() {
        String currPath = "";
        try {
            currPath = new File("").getCanonicalPath();
        }
        catch (IOException e) {
            LogManager.error("get currPath failed, cause by " + LogManager.getErrorMessage(e));
            return "";
        }
        String path = "";
        if (currPath.endsWith(LEGO_RUNTIME_DIR)) {
            path = currPath.substring(0, currPath.length() - (File.separator + LEGO_RUNTIME_DIR).length());
        } else if (currPath.endsWith(RUNTIME_DIR)) {
            path = currPath.substring(0, currPath.length() - (File.separator + "bin").length());
        }
        return path;
    }

    public String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public List<String> getRegions() {
        List regionAutoRecoveryKeys = PROPS.stringPropertyNames().stream().filter(e -> e.endsWith(BUSINESS_ARB_ENABLE)).collect(Collectors.toList());
        ArrayList<String> regions = new ArrayList<String>();
        for (String key : regionAutoRecoveryKeys) {
            regions.add(key.substring(0, key.indexOf(BUSINESS_ARB_ENABLE)));
        }
        return regions;
    }
}

