/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.arbitration.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.huawei.ism.drm.arbitration.exception.ArbitrationException;
import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.CustomSerializerProvider;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class JSONArray
extends ArrayList {
    private static final long serialVersionUID = 5871970967397101346L;
    private static ObjectMapper defaultObjMapper = new ObjectMapper();
    private List elements = new ArrayList();

    public JSONArray() {
        this.elements.clear();
        this.elements = new ArrayList();
    }

    public static JSONArray fromObject(Object object) {
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        JSONArray jsonArray = new JSONArray();
        try {
            if (object instanceof String) {
                List list = (List)defaultObjMapper.readValue(object.toString(), (TypeReference)new TypeReference<List<Object>>(){});
                JSONArray.convertElement(jsonArray, list);
            } else if (object instanceof Collection || object instanceof String[]) {
                String arrayStr = defaultObjMapper.writeValueAsString(object);
                return JSONArray.fromObject(arrayStr);
            }
        }
        catch (Exception e) {
            LogManager.error("fromObject failed:" + LogManager.getErrorMessage(e));
        }
        return jsonArray;
    }

    private static void convertElement(JSONArray array, List<Object> list) {
        Object tempEle = null;
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object ele;
            tempEle = ele = iterator.next();
            if (ele instanceof Map && !(ele instanceof JSONObject)) {
                tempEle = JSONObject.fromObject(ele);
            } else if (ele instanceof Collection && !(ele instanceof JSONArray)) {
                tempEle = JSONArray.fromObject(ele);
            }
            array.elements.add(tempEle);
        }
    }

    @Override
    public String toString() {
        try {
            return defaultObjMapper.writeValueAsString((Object)this.elements);
        }
        catch (JsonProcessingException e) {
            LogManager.error("toString failed:" + LogManager.getErrorMessage(e));
            throw new ArbitrationException(-1L, (Throwable)e);
        }
    }

    public static <T> List<T> toCollection(JSONArray array, Class<T> objectClass) {
        if (null == array) {
            LogManager.error("toCollection param is null");
            throw new ArbitrationException(1073947393L);
        }
        try {
            return (List)defaultObjMapper.readValue(array.toString(), (JavaType)defaultObjMapper.getTypeFactory().constructCollectionType(List.class, objectClass));
        }
        catch (Exception e) {
            LogManager.error("toCollection failed:" + LogManager.getErrorMessage(e));
            throw new ArbitrationException(-1L, (Throwable)e);
        }
    }

    public JSONObject getJSONObject(int index) {
        if (index < 0 || index >= this.elements.size()) {
            LogManager.error("index is out of boundary");
            throw new ArbitrationException(1073947393L);
        }
        Object value = this.elements.get(index);
        if (null != value && value instanceof JSONObject) {
            return (JSONObject)value;
        }
        LogManager.error("the element[" + index + "] is null");
        throw new ArbitrationException(-1L);
    }

    public String getString(int index) {
        if (index < 0 || index >= this.elements.size()) {
            LogManager.error("index is out of boundary");
            throw new ArbitrationException(1073947393L);
        }
        Object value = this.elements.get(index);
        return value.toString();
    }

    public Boolean getBoolean(int index) {
        if (index < 0 || index >= this.elements.size()) {
            LogManager.error("index is out of boundary");
            throw new ArbitrationException(1073947393L);
        }
        Object value = this.elements.get(index);
        if (null != value) {
            if (Boolean.FALSE.equals(value) || value instanceof String && ((String)value).equalsIgnoreCase("false")) {
                return false;
            }
            if (Boolean.TRUE.equals(value) || value instanceof String && ((String)value).equalsIgnoreCase("true")) {
                return true;
            }
        }
        LogManager.error("the element[" + index + "] is null");
        throw new ArbitrationException(-1L);
    }

    public boolean isArray() {
        return true;
    }

    @Override
    public boolean add(Object object) {
        if (null == object) {
            return false;
        }
        Object tempValue = this.convertValue(object);
        return this.elements.add(tempValue);
    }

    private Object convertValue(Object object) {
        Object tempValue = object;
        if (object instanceof String) {
            tempValue = this.convertStr2Json(object);
        } else if (object instanceof Map && !(object instanceof JSONObject)) {
            tempValue = JSONObject.fromObject(object);
        } else if (object instanceof Collection && !(object instanceof JSONArray)) {
            tempValue = JSONArray.fromObject(object);
        }
        return tempValue;
    }

    private Object convertStr2Json(Object value) {
        Object tempValue = value;
        try {
            if (((String)value).startsWith("{") && ((String)value).endsWith("}")) {
                tempValue = JSONObject.fromObject(value);
            } else if (((String)value).startsWith("[") && ((String)value).endsWith("]")) {
                tempValue = JSONArray.fromObject(value);
            }
        }
        catch (Exception e) {
            LogManager.error("can't convert string to JSON Object:str=" + value);
        }
        return tempValue;
    }

    @Override
    public void add(int index, Object object) {
        if (null == object) {
            LogManager.info("can't add null value to array");
            return;
        }
        Object tempValue = this.convertValue(object);
        this.elements.add(index, tempValue);
    }

    @Override
    public boolean addAll(Collection objects) {
        if (null == objects || objects.isEmpty()) {
            return false;
        }
        for (Object obj : objects) {
            this.add(obj);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection objects) {
        if (null == objects || objects.isEmpty()) {
            return false;
        }
        for (Object obj : objects) {
            this.add(index, obj);
        }
        return true;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.elements.contains(object);
    }

    @Override
    public boolean containsAll(Collection objects) {
        return this.elements.containsAll(objects);
    }

    @Override
    public Object get(int index) {
        return this.elements.get(index);
    }

    @Override
    public int indexOf(Object object) {
        return this.elements.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.elements.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.elements.lastIndexOf(object);
    }

    @Override
    public ListIterator listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    public boolean remove(Object object) {
        return this.elements.remove(object);
    }

    @Override
    public Object remove(int index) {
        return this.elements.remove(index);
    }

    @Override
    public boolean removeAll(Collection objects) {
        return this.elements.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection objects) {
        return this.elements.retainAll(objects);
    }

    @Override
    public Object set(int index, Object object) {
        return this.elements.set(index, object);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public List subList(int begin, int end) {
        return this.elements.subList(begin, end);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public Object[] toArray(Object[] objects) {
        return this.elements.toArray(objects);
    }

    public JSONObject toJSONObject(JSONArray array) {
        if (null == array || array.isEmpty()) {
            return null;
        }
        JSONObject json = new JSONObject();
        for (Object obj : array.elements) {
            json.put(obj.toString(), obj);
        }
        return json;
    }

    static {
        try {
            defaultObjMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            defaultObjMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            CustomSerializerProvider sp = new CustomSerializerProvider();
            defaultObjMapper.setSerializerProvider((DefaultSerializerProvider)sp);
        }
        catch (Exception e) {
            LogManager.error("Initialize ObjectMapper failed:" + LogManager.getErrorMessage(e));
        }
    }
}

