/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.arbitration.util;

import com.huawei.ism.drm.arbitration.exception.ArbitrationException;
import com.huawei.ism.drm.arbitration.log.LogManager;

public final class NumberUtil {
    private static final short ZERO = 0;
    private static final boolean FALSE = Boolean.FALSE;

    private NumberUtil() {
    }

    public static boolean getBooleanValue(Boolean booleanValue) {
        return booleanValue == null ? FALSE : booleanValue;
    }

    public static short getShortValue(Short shortObj) {
        return shortObj == null ? (short)0 : shortObj;
    }

    public static int getIntValue(Integer intObj) {
        return intObj == null ? 0 : intObj;
    }

    public static long getLongValue(Long longObj) {
        return longObj == null ? 0L : longObj;
    }

    public static Double parseDouble(Object obj) {
        Double data = 0.0;
        if (obj != null) {
            try {
                data = Double.valueOf(obj.toString());
            }
            catch (NumberFormatException e) {
                LogManager.error("Parsing failed. obj:" + obj + ", cause by " + LogManager.getErrorMessage(e));
                data = 0.0;
            }
        }
        return data;
    }

    public static Integer parseInteger(Object obj) {
        Integer data = 0;
        if (obj != null) {
            try {
                data = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                LogManager.error("Parsing failed. obj:" + obj + ", cause by " + LogManager.getErrorMessage(e));
                data = 0;
            }
        }
        return data;
    }

    public static Long parseLong(Object obj) {
        Long value = 0L;
        if (obj != null) {
            try {
                value = Long.valueOf(obj.toString());
            }
            catch (NumberFormatException e) {
                LogManager.error("Parsing failed. obj:" + obj + ", cause by " + LogManager.getErrorMessage(e));
                value = 0L;
            }
        }
        return value;
    }

    public static Long convertToLong(Object object, long defaultValue) {
        if (null == object) {
            return defaultValue;
        }
        Long result = null;
        try {
            result = Long.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            LogManager.error("Converting failed. obj:" + object + ", cause by " + LogManager.getErrorMessage(e));
            result = defaultValue;
        }
        return result;
    }

    public static Integer convertToInteger(Object object, int defaultValue) {
        if (null == object) {
            return defaultValue;
        }
        Integer result = null;
        try {
            result = Integer.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            LogManager.error("Converting failed. obj:" + object + ", cause by " + LogManager.getErrorMessage(e));
            result = defaultValue;
        }
        return result;
    }

    public static Double convertToDouble(Object object, double defaultValue) {
        if (null == object) {
            return defaultValue;
        }
        Double result = null;
        try {
            result = Double.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            LogManager.error("Converting failed. obj:" + object + ", cause by " + LogManager.getErrorMessage(e));
            result = defaultValue;
        }
        return result;
    }

    public static Long convertToLong(Object object, ArbitrationException failException) {
        if (null == object) {
            LogManager.error("can't Convert to long because object is null");
            throw failException;
        }
        try {
            return Long.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            LogManager.error("Converting failed. obj:" + object + ", cause by " + LogManager.getErrorMessage(e));
            throw failException;
        }
    }

    public static Integer convertToInteger(Object object, ArbitrationException failException) {
        if (null == object) {
            LogManager.error("can't Convert to float because object is null");
            throw failException;
        }
        try {
            return Integer.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            LogManager.error("Converting failed. obj:" + object + ", cause by " + LogManager.getErrorMessage(e));
            throw failException;
        }
    }

    public static Double convertToDouble(Object object, ArbitrationException failException) {
        if (null == object) {
            LogManager.error("can't Convert to double because object is null");
            throw failException;
        }
        try {
            return Double.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            LogManager.error("Converting failed. obj:" + object + ", cause by " + LogManager.getErrorMessage(e));
            throw failException;
        }
    }

    public static Float convertToFloat(Object object, ArbitrationException failException) {
        if (null == object) {
            LogManager.error("can't Convert to float because object is null");
            throw failException;
        }
        try {
            return Float.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException e) {
            LogManager.error("Converting failed. obj:" + object + ", cause by " + LogManager.getErrorMessage(e));
            throw failException;
        }
    }

    public static Long convertToLong(Object object) {
        return NumberUtil.convertToLong(object, new ArbitrationException(1073947393L));
    }

    public static Integer convertToInteger(Object object) {
        return NumberUtil.convertToInteger(object, new ArbitrationException(1073947393L));
    }

    public static Double convertToDouble(Object object) {
        return NumberUtil.convertToDouble(object, new ArbitrationException(1073947393L));
    }

    public static Float convertToFloat(Object object) {
        return NumberUtil.convertToFloat(object, new ArbitrationException(1073947393L));
    }
}

