/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.impl;

import com.huawei.ism.drm.arbitration.exception.ArbitrationException;
import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import com.huawei.jetcd.client.AllNodeDownSelectPolicy;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.client.form.Form;
import com.huawei.jetcd.client.impl.HealthCheckHandler;
import com.huawei.jetcd.client.internal.EtcdServer;
import com.huawei.jetcd.exception.EtcdAuthException;
import com.huawei.jetcd.exception.EtcdClientException;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.exception.EtcdServerCheckException;
import com.huawei.jetcd.exception.EtcdServerException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Timeout;

public abstract class AbstractClient
implements Closeable {
    protected EtcdConfig config;
    private final CloseableHttpAsyncClient client;
    private final UsernamePasswordCredentials credentials;
    private final List<EtcdServer> etcdServers;
    private final AtomicInteger selectedServerIndex = new AtomicInteger(-1);
    private AllNodeDownSelectPolicy allNodeDownSelectPolicy = AllNodeDownSelectPolicy.RANDOM_SELECT_ONE;

    protected AbstractClient(EtcdConfig config, SSLContext sslContext) {
        this.config = config;
        AllNodeDownSelectPolicy pAllNodeDownSelectPolicy = config.getAllNodeDownSelectPolicy();
        if (pAllNodeDownSelectPolicy != null) {
            this.allNodeDownSelectPolicy = pAllNodeDownSelectPolicy;
        }
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoKeepAlive(config.isKeepAlive()).build();
        PoolingAsyncClientConnectionManagerBuilder connectionManagerBuilder = PoolingAsyncClientConnectionManagerBuilder.create();
        if (sslContext != null) {
            connectionManagerBuilder.setTlsStrategy(AbstractClient.createTlsStrategy(sslContext));
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)config.getConnectTimeOut())).setResponseTimeout(Timeout.ofMilliseconds((long)config.getReadTimeout())).build();
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).setConnectionManager((AsyncClientConnectionManager)connectionManagerBuilder.build()).setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_1).setDefaultRequestConfig(requestConfig);
        if (VerifyUtil.isEmpty(config.getUsername())) {
            this.credentials = null;
        } else {
            this.credentials = new UsernamePasswordCredentials(config.getUsername(), config.getPassword().toCharArray());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)this.credentials);
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        this.client = clientBuilder.build();
        this.client.start();
        try {
            String scheme = (sslContext != null ? URIScheme.HTTPS : URIScheme.HTTP).id;
            this.etcdServers = AbstractClient.initServer(config, scheme);
            if (config.isHealthCheck()) {
                this.startHealthCheck();
            }
        }
        catch (Exception e) {
            LogManager.warn("[startHealthCheck] execute failed. Client need to close");
            try {
                this.close();
            }
            catch (IOException e2) {
                LogManager.error("Close client failed, msg: " + LogManager.getErrorMessage(e2));
                throw new ArbitrationException("Close client failed", (Throwable)e2);
            }
            throw e;
        }
    }

    private static TlsStrategy createTlsStrategy(SSLContext sslContext) {
        return ClientTlsStrategyBuilder.create().setSslContext(sslContext).setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setTlsVersions(new TLS[]{TLS.V_1_2}).setTlsDetailsFactory(sslEngine -> new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol())).build();
    }

    private static List<EtcdServer> initServer(EtcdConfig config, String scheme) {
        return Arrays.stream(config.getServer()).map(authority -> {
            try {
                return new EtcdServer(new URI(scheme, (String)authority, null, null, null));
            }
            catch (URISyntaxException e) {
                throw new ArbitrationException("Parse server ip failed.", (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    SimpleHttpResponse syncExecuteHttp(Form form) throws EtcdException {
        try {
            EtcdServer server = this.selectServer();
            return (SimpleHttpResponse)this.client.execute(this.buildRequest(server, form), (HttpContext)this.buildContext(server), null).get();
        }
        catch (ExecutionException e) {
            if (this.isSSLEngineException(e)) {
                LogManager.error("Certificate auth failed." + LogManager.getErrorMessage(e));
                throw new EtcdAuthException(400, "certificate auth failed.");
            }
            return this.syncExecuteRetry(form);
        }
        catch (InterruptedException e) {
            LogManager.error("Request interrupted." + LogManager.getErrorMessage(e));
            throw new EtcdClientException("Request interrupted.", 404L);
        }
        catch (EtcdServerException e) {
            throw e;
        }
        catch (Exception e) {
            return this.syncExecuteRetry(form);
        }
    }

    private boolean isSSLEngineException(Exception e) {
        if (VerifyUtil.isEmpty(e) || VerifyUtil.isEmpty(e.getMessage())) {
            return false;
        }
        return Arrays.stream(e.getMessage().split(":")).anyMatch(message -> message.contains("SSLEngine"));
    }

    private SimpleHttpResponse syncExecuteRetry(Form form) throws EtcdException {
        int retryCount = form.getRetryCount();
        if (retryCount == -1) {
            retryCount = Math.max(this.etcdServers.size(), this.config.getRetryCount());
        }
        if (retryCount == 0) {
            LogManager.error("Request error, retryCount=0, abort retry! Form: " + form);
            throw new EtcdClientException("Request error, retryCount=0, abort retry!", 404L);
        }
        LogManager.error("Request error, retryCount=" + retryCount + ". Form: " + form);
        form.setRetryCount(--retryCount);
        return this.syncExecuteHttp(form);
    }

    private SimpleHttpRequest buildRequest(EtcdServer server, Form form) {
        SimpleRequestBuilder build = SimpleRequestBuilder.create((String)form.getHttpMethod().name()).setUri(server.getUri()).setPath(form.getPath());
        form.getParamsMap().forEach((arg_0, arg_1) -> ((SimpleRequestBuilder)build).addParameter(arg_0, arg_1));
        if (form.getBody() != null) {
            build.setBody(form.getBody(), ContentType.TEXT_PLAIN).setCharset(StandardCharsets.UTF_8);
        }
        SimpleHttpRequest request = build.build();
        LogManager.debug("Build request success. Request: " + request.toString());
        return request;
    }

    private HttpClientContext buildContext(EtcdServer server) {
        HttpClientContext context = HttpClientContext.create();
        if (this.credentials != null) {
            BasicScheme authScheme = new BasicScheme();
            authScheme.initPreemptive((Credentials)this.credentials);
            context.resetAuthExchange(HttpHost.create((URI)server.getUri()), (AuthScheme)authScheme);
        }
        return context;
    }

    private void startHealthCheck() {
        if (VerifyUtil.isEmpty(this.etcdServers)) {
            LogManager.debug("No arbitration server.");
            return;
        }
        List checkerList = this.etcdServers.stream().map(server -> HealthCheckHandler.startCheck(server, this.client, this.buildContext((EtcdServer)server))).collect(Collectors.toList());
        int threshold = (int)Math.ceil((double)this.etcdServers.size() / 2.0);
        int healthNum = 0;
        for (HealthCheckHandler checker : checkerList) {
            try {
                if (!checker.isServerHealth() || ++healthNum < threshold) continue;
                break;
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                LogManager.error(String.format(Locale.ROOT, "Check health for server %s failed, message: %s", checker.getServer().getUri().getHost(), LogManager.getErrorMessage(e)));
            }
        }
        LogManager.debug("The number of checked is: " + healthNum + " and threshold number is: " + threshold);
        if (healthNum < threshold) {
            LogManager.error("Arbitration server health check failed.");
            throw new EtcdServerCheckException(1073947394L);
        }
    }

    private EtcdServer selectServer() throws EtcdException {
        int prevIndex = this.selectedServerIndex.get();
        int serverCount = this.etcdServers.size();
        for (int i = 1; i <= serverCount; ++i) {
            EtcdServer etcdServer = this.etcdServers.get((prevIndex + i) % serverCount);
            if (!etcdServer.isHealth()) continue;
            this.selectedServerIndex.compareAndSet(prevIndex, prevIndex + i);
            return etcdServer;
        }
        return this.allNodeDownSelectPolicy.select(this.etcdServers);
    }
}

