/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.impl;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.client.IClient;
import com.huawei.jetcd.client.form.Form;
import com.huawei.jetcd.client.form.KeyGetForm;
import com.huawei.jetcd.client.form.VersionForm;
import com.huawei.jetcd.client.impl.AbstractClient;
import com.huawei.jetcd.client.parser.EtcdResultTranslator;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.model.EtcdNode;
import com.huawei.jetcd.model.EtcdResult;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;

public final class ClientImpl
extends AbstractClient
implements IClient {
    public ClientImpl(EtcdConfig config) {
        super(config, null);
    }

    public ClientImpl(EtcdConfig config, SSLContext sslContext) {
        super(config, sslContext);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String version() throws EtcdException {
        VersionForm form = new VersionForm();
        try {
            SimpleHttpResponse response = this.syncExecuteHttp(form);
            return EtcdResultTranslator.translateVersion(response);
        }
        catch (EtcdException e) {
            LogManager.error("Connected etcd server failed, message: " + LogManager.getErrorMessage(e));
            throw new EtcdException("Connected etcd server failed.");
        }
    }

    @Override
    public EtcdResult get(String key) throws EtcdException {
        KeyGetForm form = new KeyGetForm(key);
        return this.syncExecute(form);
    }

    @Override
    public List<EtcdNode> listDir(String dir) throws EtcdException {
        KeyGetForm form = new KeyGetForm(dir);
        EtcdResult result = this.syncExecute(form);
        if (result.getNode() == null || result.getNode().getNodes() == null) {
            List<EtcdNode> nodeList = Collections.emptyList();
            return nodeList;
        }
        return result.getNode().getNodes();
    }

    private EtcdResult syncExecute(Form form) throws EtcdException {
        SimpleHttpResponse response = this.syncExecuteHttp(form);
        return EtcdResultTranslator.translateKeyResult(response);
    }
}

