/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.client.impl;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import com.huawei.jetcd.client.internal.EtcdServer;
import com.huawei.jetcd.model.EtcdHealth;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;

public class HealthCheckHandler {
    private static final Timeout CHECK_READ_TIMEOUT = Timeout.ofMilliseconds((long)2000L);
    private EtcdServer server;
    private Future<SimpleHttpResponse> responseFuture;

    private HealthCheckHandler(EtcdServer server, Future<SimpleHttpResponse> responseFuture) {
        this.server = server;
        this.responseFuture = responseFuture;
    }

    public static HealthCheckHandler startCheck(EtcdServer server, CloseableHttpAsyncClient client, HttpClientContext context) {
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(CHECK_READ_TIMEOUT).build();
        SimpleHttpRequest request = SimpleRequestBuilder.get((URI)server.getUri()).setPath("/health").setRequestConfig(requestConfig).build();
        LogManager.debug("Check server health with request: " + request);
        return new HealthCheckHandler(server, client.execute(request, (HttpContext)context, null));
    }

    public boolean isServerHealth() throws InterruptedException, ExecutionException, IOException {
        String serverHost = this.server.getUri().getHost();
        if (this.responseFuture != null) {
            SimpleHttpResponse response = this.responseFuture.get();
            boolean isHealth = this.isHealth(response);
            LogManager.debug("Server: " + serverHost + ", health result: " + isHealth);
            return isHealth;
        }
        LogManager.warn("No result for server: " + serverHost);
        return false;
    }

    private boolean isHealth(SimpleHttpResponse response) throws IOException {
        String responseBody;
        if (response.getCode() == 200 && (responseBody = response.getBodyText()) != null) {
            EtcdHealth etcdHealth = JSONObject.toBean(responseBody, EtcdHealth.class);
            if (VerifyUtil.isEmpty(etcdHealth)) {
                LogManager.error("etcdHealth object is null.");
                return false;
            }
            this.server.setHealth(etcdHealth.isHealth());
            return etcdHealth.isHealth();
        }
        return false;
    }

    public EtcdServer getServer() {
        return this.server;
    }
}

