/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.jetcd.exception;

import com.huawei.jetcd.exception.EtcdException;
import java.util.Locale;

public class EtcdServerException
extends EtcdException {
    private static final long serialVersionUID = 1L;
    private String etcdCause;
    private int errorCode;
    private Long index;
    private String etcdMessage;

    public EtcdServerException(int errorCode, String cause, String message, Long index) {
        this.errorCode = errorCode;
        this.etcdCause = cause;
        this.etcdMessage = message;
        this.index = index;
    }

    public EtcdServerException(int errorCode, String etcdCause) {
        this.errorCode = errorCode;
        this.etcdCause = etcdCause;
    }

    public EtcdServerException(int errorCode) {
        this.errorCode = errorCode;
    }

    public EtcdServerException(Long index) {
        this.index = index;
    }

    @Override
    public String getMessage() {
        return String.format(Locale.ROOT, "[%s]: %s%s%s", this.errorCode, this.etcdMessage, this.etcdCause != null ? ", cause: " + this.etcdCause : "", this.index != null ? ", at index: " + this.index : "");
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public String getEtcdCause() {
        return this.etcdCause;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Long getIndex() {
        return this.index;
    }

    public String getEtcdMessage() {
        return this.etcdMessage;
    }
}

