/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.backtask.dao.impl;

import com.huawei.lego.cbb.backtask.dao.IBackTaskDAO;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.service.BackTaskLocal;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.util.StringUtils;

public class BackTaskDAOImpl
extends HibernateDaoSupportWrapper
implements IBackTaskDAO {
    private static final String KEY_HQL = "hql";
    private static final String KEY_PARAMS = "params";
    private static final String KEY_PARAMTYPES = "paramtypes";
    private static final Log LOG = LogFactory.getInstance(BackTaskDAOImpl.class);

    @Override
    public long addTask(BackTask task) {
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().openSession();
            Long id = (Long)session.save((Object)task);
            long l = id;
            return l;
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            Optional.ofNullable(session).ifPresent(SharedSessionContract::close);
        }
    }

    @Override
    public void updateTask(BackTask task) {
        try {
            BackTask tempTask = (BackTask)this.getHibernateTemplate().get(BackTask.class, (Serializable)task.getTaskId());
            if (null == tempTask) {
                throw new LegoCheckedException(201L);
            }
            HibernateTemplate template = super.getHibernateTemplate();
            template.evict((Object)tempTask);
            template.merge((Object)task);
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void deleteTask(long taskId) {
        try {
            BackTask tempTask = (BackTask)this.getHibernateTemplate().get(BackTask.class, (Serializable)Long.valueOf(taskId));
            if (null == tempTask) {
                throw new LegoCheckedException(201L);
            }
            super.getHibernateTemplate().delete((Object)tempTask);
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public BackTask readTask(long taskId) {
        BackTask task = null;
        try {
            task = (BackTask)this.getHibernateTemplate().get(BackTask.class, (Serializable)Long.valueOf(taskId));
            if (null == task) {
                throw new LegoCheckedException(201L);
            }
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return task;
    }

    @Override
    public List<BackTask> queryTask(Map<String, Object> condition) {
        Map<String, Object[]> map = this.getHqlByCondition(condition, false);
        String hql = (String)map.get(KEY_HQL)[0];
        Object[] params = map.get(KEY_PARAMS);
        if (null == params) {
            return super.getHibernateTemplate().find(hql, new Object[0]);
        }
        return super.getHibernateTemplate().find(hql, params);
    }

    @Override
    public Paging findPage(Map<String, Object> condition, int firstRowIndex, int totalRow) {
        Map<String, Object[]> map = this.getHqlByCondition(condition, false);
        String hql = (String)map.get(KEY_HQL)[0];
        Object[] params = map.get(KEY_PARAMS);
        Object[] paramTypes = map.get(KEY_PARAMTYPES);
        List task = (List)this.getHibernateTemplate().execute(session -> {
            Query q = session.createQuery(hql);
            if (null != paramTypes) {
                for (int i = 0; i < paramTypes.length; ++i) {
                    if ("String".equals(paramTypes[i])) {
                        q.setString(i, (String)params[i]);
                        continue;
                    }
                    if (!"Integer".equals(paramTypes[i])) continue;
                    q.setInteger(i, ((Integer)params[i]).intValue());
                }
            }
            q.setFirstResult(firstRowIndex);
            q.setMaxResults(totalRow);
            return q.list();
        });
        Paging rePaging = new Paging();
        ArrayList<BackTask> taskTemp = new ArrayList<BackTask>();
        if (null != task) {
            for (BackTask backTask : task) {
                taskTemp.add(BackTaskLocal.getBackTaskBo(backTask));
            }
        }
        rePaging.setData(taskTemp);
        Map<String, Object[]> countMap = this.getHqlByCondition(condition, true);
        String countHql = (String)countMap.get(KEY_HQL)[0];
        Object[] countParams = countMap.get(KEY_PARAMS);
        long iCount = 0L;
        iCount = null == countParams ? this.getCount(countHql) : this.getCount(countHql, countParams);
        rePaging.setiCount((int)iCount);
        return rePaging;
    }

    private long getCount(String hql, Object[] params) {
        return this.getTotalCount("select count(*) " + hql, params);
    }

    private long getTotalCount(String hql, Object[] params) {
        return (Long)super.getHibernateTemplate().find(hql, params).listIterator().next();
    }

    private Map<String, Object[]> getHqlByCondition(Map<String, Object> condition, boolean isCountSql) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        ArrayList<Object> paramList = new ArrayList<Object>();
        ArrayList<String> paramTypeList = new ArrayList<String>();
        StringBuilder hql = new StringBuilder("from BackTask t where t.taskId > 0 ");
        if (null == condition) {
            map.put(KEY_HQL, new String[]{hql.toString()});
            return map;
        }
        String orderKey = "";
        String oerder = "";
        if (!isCountSql) {
            oerder = "DESC";
            orderKey = "order by startTime ";
        }
        for (Map.Entry<String, Object> entry : condition.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.appendParams(key, value, hql, paramList, paramTypeList);
            if (isCountSql || !key.equalsIgnoreCase("DESC") && !key.equalsIgnoreCase("ASC")) continue;
            oerder = key;
            if (!CommonUtil.isValidDbColumn((String)String.valueOf(value))) {
                throw new LegoCheckedException(1073947393L);
            }
            orderKey = "order by " + value + " ";
        }
        hql.append(orderKey);
        hql.append(oerder);
        map.put(KEY_HQL, new String[]{hql.toString()});
        map.put(KEY_PARAMS, paramList.toArray());
        map.put(KEY_PARAMTYPES, paramTypeList.toArray());
        return map;
    }

    private void appendParams(String key, Object value, StringBuilder hql, List<Object> paramList, List<String> paramTypeList) {
        if ("taskName".equalsIgnoreCase(key)) {
            hql.append(" and t.taskName like ? ");
            paramList.add("%" + value.toString().trim() + "%");
            paramTypeList.add("String");
        } else if ("targetName".equalsIgnoreCase(key)) {
            hql.append(" and lower(t.targetName) like ? ");
            String targetNameValue = StringUtils.replace((String)value.toString().trim().toLowerCase(Locale.US), (String)"'", (String)"''");
            targetNameValue = targetNameValue.replace("_", "\\_");
            paramList.add("%" + targetNameValue + "%");
            paramTypeList.add("String");
        } else if ("taskResult".equalsIgnoreCase(key)) {
            hql.append(" and t.taskResult = ? ");
            paramList.add(NumberUtil.convertToInteger((Object)value.toString()));
            paramTypeList.add("Integer");
        } else if ("createUser".equalsIgnoreCase(key)) {
            hql.append(" and t.createUser = ? ");
            paramList.add(value.toString().trim());
            paramTypeList.add("String");
        } else if ("type".equalsIgnoreCase(key)) {
            if (value.toString().trim().equals("replication")) {
                hql.append(" and ( t.type = ? or t.type = 'hyperMetroReplication' or t.type = 'IntraCityHyperMetroReplication' )");
            } else {
                hql.append(" and t.type = ? ");
            }
            paramList.add(value.toString().trim());
            paramTypeList.add("String");
        }
        if ("taskDetailPara".equalsIgnoreCase(key)) {
            hql.append(" and t.taskDetailPara = ? ");
            paramList.add(value.toString().trim());
            paramTypeList.add("String");
        }
        if ("taskLink".equalsIgnoreCase(key)) {
            hql.append(" and t.taskLink = ? ");
            paramList.add(value.toString().trim());
            paramTypeList.add("String");
        }
    }

    private long getCount(String hql) {
        return this.getTotalCount("select count(*) " + hql);
    }

    private long getTotalCount(String hql) {
        return (Long)super.getHibernateTemplate().find(hql, new Object[0]).listIterator().next();
    }

    @Override
    public Boolean nameIsExist(String taskName) {
        StringBuilder hql = new StringBuilder("from BackTask t where t.taskName = ?");
        List taskList = super.getHibernateTemplate().find(hql.toString(), new Object[]{taskName});
        if (null != taskList && !taskList.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public Paging queryTaskResultItem(long taskId, int start, int pagesize, String sortField, boolean sortType) {
        if (!CommonUtil.isValidDbColumn((String)sortField)) {
            throw new LegoCheckedException(1073947393L);
        }
        StringBuffer hql = new StringBuffer();
        hql.append(" from TaskResultItem t");
        hql.append(" where t.resultItem.taskId = ?");
        hql.append(" order by t.");
        hql.append(sortField);
        if (sortType) {
            hql.append(" asc");
        } else {
            hql.append(" desc");
        }
        int firstRowIndex = start;
        int totalRow = pagesize;
        long taskid = taskId;
        List list = (List)this.getHibernateTemplate().execute(session -> {
            Query q = session.createQuery(hql.toString());
            q.setLong(0, taskid);
            q.setFirstResult(firstRowIndex);
            q.setMaxResults(totalRow);
            return q.list();
        });
        BackTask backtask = this.readTask(taskId);
        Paging page = new Paging();
        page.setData(list);
        page.setiCount(backtask.getTaskResultSet().size());
        return page;
    }
}

