/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.backtask.service;

import com.huawei.lego.cbb.backtask.dao.IBackTaskDAO;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.BackTaskState;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.backtask.service.BackTaskLocal;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

@Service(name="backTask", desc="", interfaceClass=IBackTaskService.class)
public class BackTaskService
extends BaseService
implements IBackTaskService,
ILifecycle,
SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(BackTaskService.class);
    private IBackTaskDAO backTaskDao;

    public long addTask(BackTask task) {
        BackTask taskMo = BackTaskLocal.getBackTaskMo(task);
        return this.backTaskDao.addTask(taskMo);
    }

    public void updateTask(BackTask task) {
        BackTask taskMo = BackTaskLocal.getBackTaskMo(task);
        this.backTaskDao.updateTask(taskMo);
    }

    public void updateTask(long taskId, int progress, int result, Date endTime) {
        BackTask task = this.backTaskDao.readTask(taskId);
        if (null != task) {
            task.setTaskProgress(Integer.valueOf(progress));
            task.setTaskResult(Integer.valueOf(result));
            if (null != endTime) {
                task.setEndTime(endTime);
            }
            this.backTaskDao.updateTask(task);
        }
    }

    public void updateTask(long taskId, int progress) {
        if (progress < -1 || progress > 100) {
            throw new LegoCheckedException(1073947393L);
        }
        BackTask task = this.backTaskDao.readTask(taskId);
        if (null == task.getTaskProgress() || progress > task.getTaskProgress()) {
            task.setTaskProgress(Integer.valueOf(progress));
            this.backTaskDao.updateTask(task);
        }
    }

    public void deleteTask(long taskId) {
        BackTask backTask = this.backTaskDao.readTask(taskId);
        this.backTaskDao.deleteTask(taskId);
        logger.info((Object)String.format(Locale.ENGLISH, "Delete the task: name:%s and the target name: %s.", backTask.getTaskName(), backTask.getTargetName()));
    }

    public BatchOperationResult deleteTask(List<BatchOperation> list) {
        BatchOperationResult results = new BatchOperationResult();
        ArrayList<BatchOperation> resultLists = new ArrayList<BatchOperation>();
        int fails = 0;
        int operCount = 0;
        if (null != list && !list.isEmpty()) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    ++fails;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    ++fails;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (Exception e) {
                    ++fails;
                    batchOperation.setErrorCode(102L);
                }
                resultLists.add(batchOperation);
            }
            results.setResult(resultLists);
            results.setFailCount(fails);
            results.setTotalCount(operCount);
            results.setSucceedCount(operCount - fails);
        }
        return results;
    }

    public BackTask readTask(long taskId) {
        BackTask taskMo = this.backTaskDao.readTask(taskId);
        BackTask taskBo = BackTaskLocal.getBackTaskBo(taskMo);
        return taskBo;
    }

    public List<BackTask> queryTasks(Map<String, Object> condition) {
        ArrayList<BackTask> taskBoListTemp = new ArrayList<BackTask>();
        List<BackTask> taskBoList = this.backTaskDao.queryTask(condition);
        for (BackTask backTask : taskBoList) {
            taskBoListTemp.add(BackTaskLocal.getBackTaskBo(backTask));
        }
        return taskBoListTemp;
    }

    public Paging queryTasks(Map<String, Object> condition, int firstRowIndex, int totalRow) {
        return this.backTaskDao.findPage(condition, firstRowIndex, totalRow);
    }

    public Boolean nameIsExist(String taskName) {
        return this.backTaskDao.nameIsExist(taskName);
    }

    public void setBackTaskDao(IBackTaskDAO backTaskDao) {
        this.backTaskDao = backTaskDao;
    }

    public Status getCurrentStatus() {
        return null;
    }

    public void initialize(ICallback[] callback) {
    }

    public void setCurrentStatus(Status status) {
    }

    public void start(ICallback[] callback) {
    }

    public void stop(ICallback[] callback) {
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.handleUndoneTasks();
        }
    }

    private void handleUndoneTasks() {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        Integer taskResult = BackTaskState.PROCESS.getValue();
        Integer taskFail = BackTaskState.FAIL.getValue();
        condition.put("taskResult", taskResult);
        List<Object> processTasks = this.queryTasks(condition);
        long sysBeginTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        processTasks = processTasks.stream().filter(task -> task.getStartTime().getTime() < sysBeginTime).collect(Collectors.toList());
        if (!processTasks.isEmpty()) {
            for (BackTask backTask : processTasks) {
                backTask.setTaskProgress(Integer.valueOf(100));
                backTask.setTaskResult(taskFail);
                backTask.setEndTime(new Date());
                this.updateTask(backTask);
                logger.info((Object)String.format(Locale.ENGLISH, "Update task fail for id:%s name:%s targetName:%s.", backTask.getTaskId(), backTask.getTaskName(), backTask.getTargetName()));
            }
        }
    }

    public Paging queryTaskResultItem(long taskId, int start, int pagesize, String sortFild, boolean sortType) {
        return this.backTaskDao.queryTaskResultItem(taskId, start, pagesize, sortFild, sortType);
    }
}

