/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.license.util;

import com.huawei.lego.cbb.license.sdk.model.LicenseOverdueDealPolicy;
import com.huawei.lego.cbb.license.service.LicHelper;
import com.huawei.lego.cbb.license.util.ServerEsnBuilder;
import com.huawei.lego.cbb.user.service.common.SystemInitializeUser;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.springframework.beans.factory.InitializingBean;

public class LicensePolicyUtil
implements InitializingBean {
    private static final int MAX_USE_DAY = 90;
    private static final String LEGO_LIC_XML = "legoLic.xml";
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static LicenseOverdueDealPolicy overdueDealPolicy;
    private static Properties props;
    private static final Log LOGGER;
    private LicHelper licHelper = null;
    private long installTime = 0L;

    public Long getSystemInstalledTime() {
        if (this.installTime != 0L) {
            return this.installTime;
        }
        String licLegoPath = PathUtil.getLegoRuntimePath() + File.separator + "lic" + File.separator + LEGO_LIC_XML;
        try {
            File file = new File(licLegoPath);
            if (!file.exists()) {
                LOGGER.error((Object)"licLegoPath not found:", 1L);
                return 0L;
            }
            Configurations configs = new Configurations();
            XMLConfiguration conf = configs.xml(file);
            String licTime = WccEncryptor.decrypt((String)conf.getString("lic(0)[@sit]"));
            try {
                this.installTime = Long.parseLong(licTime);
                return this.installTime;
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"NumberFormatException when parseLong installTime, errMsg:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        catch (ConfigurationException e) {
            LOGGER.error((Object)"Unable to resolve installation time,errMsg:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return 0L;
    }

    public int getMaxUseDay() {
        return 90;
    }

    public LicenseOverdueDealPolicy getOverdueDealPolicy() {
        if (null == overdueDealPolicy) {
            this.initOverdueDealPolicy();
        }
        return overdueDealPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOverdueDealPolicy() {
        InputStream stream = null;
        try {
            String jarfileName = AdapterUtils.getClassJarPath(SystemInitializeUser.class);
            if (null == jarfileName) {
                LOGGER.error((Object)"jar file null");
            } else {
                URL url;
                ClassLoader classLoader = AdapterUtils.getClassLoader(SystemInitializeUser.class);
                if (null != classLoader && null != (url = AdapterUtils.getUrlResourceFromJar((ClassLoader)classLoader, (String)jarfileName, (String)DEFAULT_PROPERTIES))) {
                    stream = url.openStream();
                    props.load(stream);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        finally {
            this.closeStream(stream);
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)props);
        overdueDealPolicy = new LicenseOverdueDealPolicy();
        int value = this.getInt("system.lcense.login.policy");
        if (value > 0) {
            overdueDealPolicy.setPermitLogin(Boolean.TRUE.booleanValue());
        } else {
            overdueDealPolicy.setPermitLogin(Boolean.FALSE.booleanValue());
        }
        this.fillProLicInfo();
    }

    private void closeStream(InputStream stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"close stream fail.", 1L);
            }
        }
    }

    private void fillProLicInfo() {
        String name = this.getProperty("system.license.name", "Lego");
        String version = this.getProperty("system.license.version", "V100R002");
        int scale = this.getInt("system.license.resnumscale");
        List<String> esnlist = ServerEsnBuilder.getInstance().getServerEsns();
        this.licHelper.setProductName(name);
        this.licHelper.setProductVer(version);
        this.licHelper.setResNumScale(scale);
        this.licHelper.setEsnlist(esnlist);
        StringBuffer sb = new StringBuffer();
        sb.append("system's name is: ");
        sb.append(name);
        sb.append('\n');
        sb.append("system's version is: ");
        sb.append(version);
        sb.append('\n');
        sb.append("system's esns is: ");
        if (null != esnlist) {
            for (String esn : esnlist) {
                sb.append(esn);
                sb.append(" | ");
            }
        } else {
            sb.append("null");
        }
        LOGGER.info((Object)sb.toString(), 1L);
    }

    public LicHelper getLicHelper() {
        return this.licHelper;
    }

    public void setLicHelper(LicHelper licHelper) {
        this.licHelper = licHelper;
    }

    private String getProperty(String key, String defaultValue) {
        String value = props.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    private int getInt(String key) {
        String value = props.getProperty(key);
        if (null == value || value.length() <= 0) {
            return 0;
        }
        return NumberUtil.convertToInteger((Object)value);
    }

    public void afterPropertiesSet() {
        this.initOverdueDealPolicy();
    }

    static {
        props = new Properties();
        LOGGER = LogFactory.getInstance(LicensePolicyUtil.class);
    }
}

