/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.service;

import com.huawei.lego.cbb.resource.common.ResourceConstDefine;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.huawei.lego.cbb.resource.sdk.service.IDataExplore;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.base.scopemanager.IScopemanager;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.sysmonitor.sdk.service.ISysMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

@Service(name="DeviceDataExplore", desc="", interfaceClass=IDataExplore.class)
public class DeviceDataExplore
extends BaseService
implements IDataExplore {
    private static final Log logger = LogFactory.getInstance(DeviceDataExplore.class);
    private static final String SYS_MAIN_TYPE = "lego.dic.legosystem.maintype";
    private ICommonDao commonDao = null;
    private ISysMonitor sysMoniService = null;
    private IScopemanager scopeManagerService = null;

    public ISysMonitor getSysMoniService() {
        return this.sysMoniService;
    }

    public void setSysMoniService(ISysMonitor sysMoniService) {
        this.sysMoniService = sysMoniService;
    }

    public void setCommonDao(ICommonDao dao) {
        this.commonDao = dao;
    }

    public IScopemanager getScopeManagerService() {
        return this.scopeManagerService;
    }

    public void setScopeManagerService(IScopemanager scopeManagerService) {
        this.scopeManagerService = scopeManagerService;
    }

    public List<?> getDataList(int begin, int count, TopoObjectQueryCondition condtion) {
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        List<?> topoObjectList = this.commonDao.findPage(this.getHSqlByQueryCondition(condtion, param), begin, count, param);
        for (TopoObject topoObject : topoObjectList) {
            String ip = this.getInstallServerIp();
            if (null == ip || ip.trim().isEmpty()) {
                logger.debug((Object)String.format(Locale.ENGLISH, "The getInstallServerIp is:%s.", ip), 1L);
                break;
            }
            if (!SYS_MAIN_TYPE.equals(topoObject.getMainType())) continue;
            topoObject.setIpAddress(ip);
            break;
        }
        return topoObjectList;
    }

    public long getTotalDataCount(TopoObjectQueryCondition condtion) {
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        String hSqlPre = "select count(*) " + this.getHSqlByQueryCondition(condtion, param);
        return this.commonDao.getTotalCount(hSqlPre, param);
    }

    public List<?> getDataList(TopoObjectQueryCondition queryCondition) {
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        return this.commonDao.findByHql(this.getHSqlByQueryCondition(queryCondition, param), param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstallServerIp() {
        FileInputStream inputStream;
        String ip;
        block12: {
            Document document;
            block11: {
                block10: {
                    String current;
                    ip = "";
                    String legoinstallPath = "/monitor/RDInstalled.xml";
                    String realPath = "";
                    try {
                        current = new File(System.getProperty("user.dir")).getCanonicalPath();
                    }
                    catch (IOException e) {
                        logger.error((Object)("get current path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                        current = null;
                    }
                    if (null == current) {
                        logger.error((Object)"null user.dir", 1L);
                        return ip;
                    }
                    realPath = this.getRealPath(legoinstallPath, current);
                    SAXReader reader = new SAXReader();
                    inputStream = null;
                    document = null;
                    ip = InetAddress.getLocalHost().getHostAddress();
                    inputStream = new FileInputStream(realPath);
                    CommonUtil.setSecurityFeatures((SAXReader)reader);
                    document = reader.read((InputStream)inputStream);
                    if (null != document) break block10;
                    logger.error((Object)"The document is null.", 1L);
                    String string = ip;
                    this.clostInputStream(inputStream);
                    return string;
                }
                Node floatNode = document.selectSingleNode("//install/floatip");
                if (null == floatNode || null == (ip = floatNode.getText()) || ip.trim().isEmpty()) break block11;
                String string = ip;
                this.clostInputStream(inputStream);
                return string;
            }
            Node httpNode = document.selectSingleNode("//install/httpsip");
            if (null == httpNode) break block12;
            String string = ip = httpNode.getText();
            this.clostInputStream(inputStream);
            return string;
        }
        try {
            String string = ip;
            this.clostInputStream(inputStream);
            return string;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Get install ip fail, error is:" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                this.clostInputStream(inputStream);
            }
            catch (Throwable throwable) {
                this.clostInputStream(inputStream);
                throw throwable;
            }
        }
        return ip;
    }

    private String getRealPath(String legoinstallPath, String current) {
        String legoruntime = "/LegoRuntime";
        int lengthDifference = current.length() - legoruntime.length();
        String newCurrentPath = "";
        if (lengthDifference >= 0) {
            newCurrentPath = current.substring(0, lengthDifference);
        }
        String realPath = newCurrentPath + legoinstallPath;
        return realPath;
    }

    private void clostInputStream(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)"Close the inputstream failed, error is:", (Throwable)e, 1L);
            }
        }
    }

    private StringBuilder getHSqlByQueryUserId(StringBuilder sql, String hSqlApp, TopoObjectQueryCondition queryCondition) {
        sql.append("from TopoObject d where d.moId in (");
        sql.append(ResourceConstDefine.getHQueryStringbyUserId(queryCondition.getUserId()));
        sql.append(" )");
        if (!hSqlApp.isEmpty()) {
            sql.append(" and ");
            sql.append(hSqlApp);
        }
        return sql;
    }

    protected String getHSqlByQueryCondition(TopoObjectQueryCondition queryCondition, Map<Integer, String> param) {
        StringBuilder sql = new StringBuilder();
        if (queryCondition != null) {
            if (this.checkObjectNotNull(queryCondition.getDeviceNameLikeQuery())) {
                String deviceName = ConverterUtil.convertString(queryCondition.getDeviceNameLikeQuery().trim(), true);
                queryCondition.setDeviceNameLikeQuery(deviceName);
            }
            if (this.checkObjectNotNull(queryCondition.getDevIpAddressLikeQuery())) {
                String ip = ConverterUtil.convertString(queryCondition.getDevIpAddressLikeQuery().trim(), true);
                queryCondition.setDevIpAddressLikeQuery(ip);
            }
            String hSqlApp = queryCondition.getQuerySql(param);
            if (queryCondition.getUserId() != null) {
                sql = this.getHSqlByQueryUserId(sql, hSqlApp, queryCondition);
            } else {
                sql.append("from TopoObject");
                if (!hSqlApp.isEmpty()) {
                    sql.append(" d where ");
                    sql.append(hSqlApp);
                }
            }
        } else {
            sql.append("from TopoObject");
        }
        return sql.toString();
    }

    private boolean checkObjectNotNull(String str) {
        return null != str && !"".equals(str);
    }

    public TopoObject getRootMO() {
        ManagedObject mo = ((AbsApplication)super.getContainer()).getContainer().getSystemMO();
        if (null == mo) {
            logger.info((Object)"system MO is null.", 1L);
            try {
                String hql = "from TopoObject topo where topo.mainType='lego.dic.legosystem.maintype' and topo.subType='lego.dic.legosystem.subtype' and topo.name='Management System'";
                List<?> topoObjectList = this.commonDao.findByHql(hql);
                if (null != topoObjectList) {
                    mo = (ManagedObject)topoObjectList.get(0);
                    ((AbsApplication)super.getContainer()).getContainer().setSystemMO(mo);
                }
            }
            catch (Exception e) {
                logger.error((Object)("query system MO exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
        return (TopoObject)mo;
    }
}

