/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.service;

import com.google.common.collect.ImmutableMap;
import com.huawei.lego.cbb.cloudservice.sdk.model.MultiCloudProjectIdMapping;
import com.huawei.lego.cbb.resource.dao.IResourceDao;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.cbb.resource.service.IResourceFilter;
import com.huawei.lego.cbb.resource.util.DaoFactory;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.QueryCondition;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service(name="ResourceServiceImpl", desc="", interfaceClass=IResourceService.class)
public class ResourceServiceImpl
extends BaseService
implements IResourceService {
    private static final String SYS_NAME_OID = ".1.3.6.1.2.1.1.5.0";
    private static final Log LOGGER = LogFactory.getInstance(ResourceServiceImpl.class);
    private List<IResourceFilter> resourceFilterList = new ArrayList<IResourceFilter>();
    private IMessageCenter messageCenter = null;
    private IResourceDao resourceDao = null;
    private IUserMgr userMgr;
    private IDiscoveryService discoveryService;

    public void unmanageMo(List<ManagedObject> moList) {
        if (moList == null) {
            LOGGER.warn((Object)"the moList is null", 1L);
            return;
        }
        for (ManagedObject mo : moList) {
            mo.setManaged(Boolean.valueOf(false));
            this.resourceDao.updateMo(mo);
            List<ManagedObject> moList2 = this.resourceDao.getChildMo(mo.getMoId(), true);
            if (moList2 == null || moList2.isEmpty()) continue;
            this.unmanageMo(moList2);
        }
    }

    public List<Node> getDiscoveredResource() {
        List<? extends ManagedObject> nodeList = this.resourceDao.getMoByType(Node.class, true);
        ArrayList<Node> resultList = new ArrayList<Node>();
        if (VerifyUtil.isEmpty(nodeList)) {
            return resultList;
        }
        for (Node node : nodeList) {
            if (!node.getIsTopMo().booleanValue()) continue;
            resultList.add(node);
        }
        return resultList;
    }

    private Paging queryMoAdmin(boolean isAdmin, Paging paging, int firstRowIndex, int totalRow, long userId) {
        if (isAdmin) {
            if (this.resourceFilterList.isEmpty()) {
                return paging;
            }
            List<?> list = this.resourceFilterList.get(0).resourceFilter(paging.getData());
            paging.setData(list);
            return paging;
        }
        this.processNonAdminPrivilegedData(firstRowIndex, totalRow, userId, paging);
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "222222 paging info, total count is : %s.", paging.getiCount()), 1L);
        if (paging.getData() != null) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "222222 paging info, current page count is : %s.", paging.getData().size()), 1L);
        }
        if (this.resourceFilterList.isEmpty()) {
            return paging;
        }
        List<?> list = this.resourceFilterList.get(0).resourceFilter(paging.getData());
        paging.setData(list);
        return paging;
    }

    private void processNonAdminPrivilegedData(int firstRowIndex, int totalRow, long userId, Paging paging) {
        if (null == this.userMgr) {
            LOGGER.error((Object)"userMgr is null!");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList privilegedMoIdList = this.userMgr.getUserGrandObjects(userId);
        if (privilegedMoIdList == null) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "UserId is : %s, privilegedMoIdList is : null", userId), 1L);
            privilegedMoIdList = new ArrayList();
        } else {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "userId is : %s, privilegedMoIdList is : %s.", userId, privilegedMoIdList), 1L);
        }
        List oldMoList = paging.getData();
        ArrayList<ManagedObject> resultMoList = new ArrayList<ManagedObject>();
        ArrayList<ManagedObject> privilegedMoList = new ArrayList<ManagedObject>();
        if (oldMoList != null) {
            ArrayList<Long> oldMoIdList = new ArrayList<Long>();
            for (Object obj : oldMoList) {
                ManagedObject mo = (ManagedObject)obj;
                if (privilegedMoIdList.contains(mo.getMoId())) {
                    privilegedMoList.add(mo);
                }
                oldMoIdList.add(mo.getMoId());
            }
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "Old mo id list is : %s", oldMoIdList), 1L);
            for (int index = firstRowIndex; resultMoList.size() < totalRow && index < privilegedMoList.size(); ++index) {
                ManagedObject mo = (ManagedObject)privilegedMoList.get(index);
                resultMoList.add(mo);
            }
            paging.setData(resultMoList);
            paging.setiCount(privilegedMoList.size());
        }
    }

    public void modifyDeviceIp(Long id, String newIp) {
        TopoObject topoObject = (TopoObject)this.resourceDao.getMoByIdAndType(TopoObject.class, id, true);
        if (topoObject == null) {
            LOGGER.warn((Object)("can not find the TopoObject in the DB, primary key : " + id), 1L);
            return;
        }
        topoObject.setIpAddress(newIp);
        this.resourceDao.updateMo((ManagedObject)topoObject);
    }

    public Node getDeviceDetailInfo(Long id) {
        Node node = (Node)this.resourceDao.getMoByIdAndType(Node.class, id, true);
        if (node == null) {
            LOGGER.warn((Object)("device does not exist, device id is : " + id), 1L);
            throw new LegoCheckedException(201L);
        }
        return node;
    }

    public Long addMo(ManagedObject newMo) {
        if (VerifyUtil.isEmpty((Object)newMo)) {
            LOGGER.error((Object)"The newMo is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "AddMo, mo uuid is : %s.", newMo.getUuid()), 1L);
        newMo.setRecentUpdateTime(new Timestamp(System.currentTimeMillis()));
        ManagedObject oldMo = this.resourceDao.getMoByUuid(newMo.getUuid(), null);
        if (oldMo != null) {
            this.resourceDao.evict(oldMo);
        }
        Long moId = null;
        if (oldMo == null) {
            if (newMo instanceof Node) {
                Node newNode = (Node)newMo;
                if (newNode.getDiscoveredTime() == null) {
                    newNode.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
                }
                this.extracted(newNode);
            }
            moId = this.resourceDao.addMo(newMo);
        } else {
            newMo.setMoId(oldMo.getMoId());
            newMo.setUuid(oldMo.getUuid());
            newMo.setTopMoUuid(oldMo.getTopMoUuid());
            newMo.setIsTopMo(oldMo.getIsTopMo());
            if (newMo instanceof Node) {
                if (((Node)newMo).getDiscoveredTime() == null) {
                    ((Node)newMo).setDiscoveredTime(((Node)oldMo).getDiscoveredTime());
                }
                this.processUpdate(newMo, oldMo);
            }
            try {
                this.resourceDao.updateMo(newMo);
            }
            catch (Exception e) {
                LOGGER.error((Object)("update mo error, mo is : " + newMo + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            moId = newMo.getMoId();
        }
        return moId;
    }

    private void processUpdate(ManagedObject newMo, ManagedObject oldMo) {
        Node newNode = (Node)newMo;
        Node oldNode = (Node)oldMo;
        for (Map.Entry entry : newNode.getManagementProtocolMap().entrySet()) {
            String newProtocolParaName = (String)entry.getKey();
            Protocol newProtocolPara = (Protocol)entry.getValue();
            Protocol oldProtocolPara = oldNode.getManagementProtocol(newProtocolParaName);
            if (oldProtocolPara != null) {
                newProtocolPara.setId(oldProtocolPara.getId());
                newProtocolPara.setNode(oldProtocolPara.getNode());
                continue;
            }
            newProtocolPara.setNode(newNode);
        }
        for (Map.Entry entry : oldNode.getManagementProtocolMap().entrySet()) {
            String oldProtocolParaName = (String)entry.getKey();
            if (newNode.getManagementProtocol(oldProtocolParaName) != null) continue;
            this.resourceDao.delete(entry.getValue());
        }
    }

    public List<Long> addMo(List<ManagedObject> moList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ManagedObject mo : moList) {
            idList.add(this.addMo(mo));
        }
        return idList;
    }

    private void addMoAndSubMoChild(ManagedObject mo, Long returnedMoId, String topMoUuid) {
        Set childMo = mo.getChildMos();
        String hql = "from ManagedObject mo where mo.parentMo.moId = " + returnedMoId;
        List<?> oldChildMo = this.resourceDao.findByHql(hql);
        HashMap<String, Long> oldChildMoUUIDIdMap = new HashMap<String, Long>();
        for (ManagedObject oldMo : oldChildMo) {
            oldChildMoUUIDIdMap.put(oldMo.getUuid(), oldMo.getMoId());
        }
        if (childMo == null || childMo.isEmpty()) {
            if (!oldChildMoUUIDIdMap.isEmpty()) {
                LOGGER.debug((Object)"willllllllll delete unexist mo , mo map is : ", 1L);
                this.discoveryService.deleteDevice(new ArrayList(oldChildMoUUIDIdMap.values()));
            }
            return;
        }
        for (ManagedObject tMo : childMo) {
            oldChildMoUUIDIdMap.remove(tMo.getUuid());
            if (tMo.getParentMo() == null) {
                tMo.setParentMo(mo);
                tMo.setTopMoUuid(topMoUuid);
            }
            this.addMoAndSubMo(tMo);
        }
        if (!oldChildMoUUIDIdMap.isEmpty()) {
            LOGGER.debug((Object)"will222222222 delete unexist mo , mo map is : ", 1L);
            this.discoveryService.deleteDevice(new ArrayList(oldChildMoUUIDIdMap.values()));
        }
    }

    public void addMoAndSubMo(ManagedObject mo) {
        if (mo == null) {
            LOGGER.warn((Object)"the mo is null", 1L);
            return;
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Will invoke addMoAndSubMo, mo uuid is : %s", mo.getUuid()), 1L);
        if (this.discoveryService == null) {
            this.discoveryService = (IDiscoveryService)ServiceContext.getInstance().lookup("discover/DiscoveryServiceImpl");
            if (this.discoveryService == null) {
                LOGGER.error((Object)"can not get the DiscoveryServiceImpl rmi service!!!", 1L);
                return;
            }
        }
        this.processMO(mo);
    }

    private void processMO(ManagedObject mo) {
        String topMoUuid = null;
        if (mo.getIsTopMo().booleanValue()) {
            topMoUuid = mo.getUuid();
            ManagedObject topMo = this.getMoByUuid(topMoUuid, null);
            if (this.checkMoIsTop(topMo, mo)) {
                String newIP = ((TopoObject)mo).getIpAddress();
                String oldIP = ((TopoObject)topMo).getIpAddress();
                if (!oldIP.equals(newIP)) {
                    LOGGER.debug((Object)String.format(Locale.ENGLISH, "The ip address of the device changed, old ip is : %s, new ip is : %s, and will send message, message body is : %s.", oldIP, newIP, mo), 1L);
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(112L);
                    mu.setObj(mo);
                    mu.setMt(MessageTopic.DATA);
                    mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
                    this.messageCenter.sendMessage(mu);
                }
            }
        } else {
            ManagedObject parentMo = mo.getParentMo();
            if (parentMo == null) {
                LOGGER.error((Object)("the mo is not the top mo, but the mo's parent mo is null, mo is : " + mo), 1L);
            } else {
                topMoUuid = parentMo.getTopMoUuid();
            }
        }
        mo.setTopMoUuid(topMoUuid);
        Long returnedMoId = this.addMo(mo);
        this.addMoAndSubMoChild(mo, returnedMoId, topMoUuid);
    }

    private boolean checkMoIsTop(ManagedObject topMo, ManagedObject mo) {
        return topMo instanceof TopoObject && mo instanceof TopoObject;
    }

    private void addMoAndSubMoIdWithoutDelete(ManagedObject mo, String topMoUuid) {
        Long moId = this.addMo(mo);
        if (moId != null) {
            mo.setMoId(moId);
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "The mo is added, uuid is : %s, mo id is : %s.", mo.getUuid(), moId), 1L);
        } else {
            LOGGER.warn((Object)("the returned mo id is null, mo uuid is : " + mo.getUuid()), 1L);
        }
        Set childMo = mo.getChildMos();
        if (childMo == null || childMo.isEmpty()) {
            return;
        }
        for (ManagedObject tMo : childMo) {
            if (tMo.getParentMo() == null) {
                tMo.setParentMo(mo);
                tMo.setTopMoUuid(topMoUuid);
            }
            this.addMoAndSubMoWithoutDelete(tMo);
        }
    }

    public void addMoAndSubMoWithoutDelete(ManagedObject mo) {
        if (null == mo) {
            LOGGER.error((Object)"The parameter is null.", 1L);
            return;
        }
        LOGGER.debug((Object)"will invoke addMoAndSubMoWithoutDelete, mo is : ", 1L);
        if (this.discoveryService == null) {
            this.discoveryService = (IDiscoveryService)ServiceContext.getInstance().lookup("discover/DiscoveryServiceImpl");
            if (this.discoveryService == null) {
                LOGGER.error((Object)"can not get the DiscoveryServiceImpl rmi service!!!", 1L);
                return;
            }
        }
        String topMoUuid = null;
        if (mo.getIsTopMo().booleanValue()) {
            topMoUuid = mo.getUuid();
            ManagedObject topMo = this.getMoByUuid(topMoUuid, null);
            if (this.checkMoIsTop(topMo, mo)) {
                String newIP = ((TopoObject)mo).getIpAddress();
                String oldIP = ((TopoObject)topMo).getIpAddress();
                if (!oldIP.equals(newIP)) {
                    LOGGER.debug((Object)String.format(Locale.ENGLISH, "The ip address of the device changed, old ip is : %s, new ip is : %s, and will send message, message body is : %s.", oldIP, newIP, mo), 1L);
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(112L);
                    mu.setObj(mo);
                    mu.setMt(MessageTopic.DATA);
                    mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
                    this.messageCenter.sendMessage(mu);
                }
            }
        } else {
            if (mo.getParentMo() == null) {
                LOGGER.error((Object)("the mo is not the top mo, but the mo's parent mo is null, mo is : " + mo), 1L);
            }
            topMoUuid = mo.getParentMo().getTopMoUuid();
        }
        mo.setTopMoUuid(topMoUuid);
        this.addMoAndSubMoIdWithoutDelete(mo, topMoUuid);
    }

    public void updateMo(ManagedObject mo) {
        this.resourceDao.updateMo(mo);
    }

    public List<ManagedObject> getMoByType(String type) {
        List<Object> list = new ArrayList<ManagedObject>();
        if (type.indexOf(",") > -1) {
            String[] types;
            for (String str : types = type.split(",")) {
                ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
                QueryCondition condition = new QueryCondition("type", (Serializable)((Object)str));
                conditions.add(condition);
                list.addAll(this.resourceDao.queryRes(ManagedObject.class, conditions, 0, -1, "name", false).getData());
            }
        } else {
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            QueryCondition condition = new QueryCondition("type", (Serializable)((Object)type));
            conditions.add(condition);
            list = this.resourceDao.queryRes(ManagedObject.class, conditions, 0, -1, "name", false).getData();
        }
        if (null == list) {
            return new ArrayList<ManagedObject>(0);
        }
        return list;
    }

    public List<ManagedObject> getMoByType(String type, long userId) {
        boolean isAdmin = this.userMgr.checkUserIsAdmin(userId);
        List<ManagedObject> allDeviceList = this.getMoByType(type);
        if (isAdmin) {
            return allDeviceList;
        }
        ArrayList privilegedMoIdList = this.userMgr.getUserGrandObjects(userId);
        ArrayList<ManagedObject> privilegedMoList = new ArrayList<ManagedObject>();
        if (null == privilegedMoIdList) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "userId is : %s, privilegedMoIdList is : null", userId), 1L);
            privilegedMoIdList = new ArrayList();
        } else {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "userId is : %s, privilegedMoIdList is : %s.", userId, privilegedMoIdList), 1L);
        }
        if (privilegedMoIdList.isEmpty()) {
            return privilegedMoList;
        }
        for (ManagedObject obj : allDeviceList) {
            ManagedObject mo = obj;
            if (!privilegedMoIdList.contains(mo.getMoId())) continue;
            privilegedMoList.add(mo);
        }
        return privilegedMoList;
    }

    public List<ManagedObject> getChildMo(long parentId, Boolean managed) {
        return this.resourceDao.getChildMo(parentId, managed);
    }

    public ManagedObject getMoByIp(String ip) {
        return this.resourceDao.getMoByIp(ip, true);
    }

    public void deleteMo(Long moId) {
        this.resourceDao.deleteMo(moId);
    }

    public int updateBySql(String sql, Object[] param) {
        return this.resourceDao.updateBySql(sql, param);
    }

    public List<ManagedObject> getAllSubMo(Long moId) {
        ArrayList<ManagedObject> subMoList = new ArrayList<ManagedObject>();
        this.resourceDao.getAllSubMo(moId, subMoList);
        return subMoList;
    }

    public ManagedObject getMoByUuid(String uuid, Boolean managed) {
        return this.resourceDao.getMoByUuid(uuid, managed);
    }

    public List<Long> getAllMoId() {
        return this.resourceDao.getAllMoId();
    }

    public void setResourceDao(IResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public void unmanageMoWithoutMsg(List<ManagedObject> moList) {
        if (moList == null) {
            LOGGER.warn((Object)"the moList is null", 1L);
            return;
        }
        for (ManagedObject mo : moList) {
            mo.setManaged(Boolean.valueOf(false));
            this.resourceDao.updateMoWithoutMsg(mo);
            List<ManagedObject> moList2 = this.resourceDao.getChildMo(mo.getMoId(), true);
            if (moList2 == null || moList2.isEmpty()) continue;
            this.unmanageMoWithoutMsg(moList2);
        }
    }

    public void modifyDeviceIpWithout(Long id, String newIp) {
        TopoObject topoObject = (TopoObject)this.resourceDao.getMoByIdAndType(TopoObject.class, id, true);
        if (topoObject == null) {
            LOGGER.warn((Object)("can not find the TopoObject in the DB, primary key : " + id), 1L);
            return;
        }
        topoObject.setIpAddress(newIp);
        this.resourceDao.updateMoWithoutMsg((ManagedObject)topoObject);
    }

    private Long addMoIfOldNotNull(ManagedObject newMo, ManagedObject oldMo, Map<Long, Long> msgMap) {
        Long moId = null;
        newMo.setMoId(oldMo.getMoId());
        newMo.setUuid(oldMo.getUuid());
        if (newMo.getIsTopMo().booleanValue()) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "##Set device alias, dev name is:%s.", newMo.getName()), 1L);
            newMo.setDevAlias(oldMo.getDevAlias());
        }
        if (newMo instanceof Node) {
            if (((Node)newMo).getDiscoveredTime() == null) {
                ((Node)newMo).setDiscoveredTime(((Node)oldMo).getDiscoveredTime());
            }
            this.processUpdate(newMo, oldMo);
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "NewMo to be updated without msg, newMo uuid is : %s.", newMo.getUuid()), 1L);
        try {
            this.resourceDao.updateMoWithoutMsg(newMo);
        }
        catch (Exception e) {
            LOGGER.error((Object)("update mo error, mo is :\u3000" + newMo + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        moId = newMo.getMoId();
        if (!oldMo.equals((Object)newMo)) {
            if (newMo.getIsTopMo().booleanValue()) {
                msgMap.put(moId, 107L);
            } else {
                msgMap.put(moId, 108L);
            }
        }
        return moId;
    }

    public Long addMoWithoutMsg(ManagedObject newMo, Map<Long, Long> msgMap) {
        newMo.setRecentUpdateTime(new Timestamp(System.currentTimeMillis()));
        LOGGER.debug((Object)"addMo without msg, mo is : ", 1L);
        ManagedObject oldMo = this.resourceDao.getMoByUuid(newMo.getUuid(), null);
        if (oldMo != null) {
            this.resourceDao.evict(oldMo);
        }
        Long moId = null;
        if (oldMo == null) {
            if (newMo instanceof Node) {
                Node newNode = (Node)newMo;
                if (newNode.getDiscoveredTime() == null) {
                    newNode.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
                }
                this.extracted(newNode);
            }
            if (this.checkMoNOAlias(newMo)) {
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "##Set device alias, dev name is:%s.", newMo.getName()), 1L);
                newMo.setDevAlias(newMo.getName());
            }
            moId = this.resourceDao.addMoWithoutMsg(newMo);
            if (newMo.getIsTopMo().booleanValue()) {
                msgMap.put(moId, 103L);
            } else {
                msgMap.put(moId, 104L);
            }
        } else {
            moId = this.addMoIfOldNotNull(newMo, oldMo, msgMap);
        }
        return moId;
    }

    private boolean checkMoNOAlias(ManagedObject newMo) {
        return newMo.getIsTopMo() != false && (null == newMo.getDevAlias() || "".equals(newMo.getDevAlias()));
    }

    private void extracted(Node newNode) {
        for (Protocol protocol : newNode.getManagementProtocolMap().values()) {
            Protocol p;
            if (protocol.getId() != null && (p = (Protocol)this.resourceDao.get(Protocol.class, protocol.getId())) == null) {
                protocol.setId(null);
            }
            protocol.setNode(newNode);
        }
    }

    private void addMoAndSubMoWithoutMsgChild(ManagedObject mo, Map<Long, Long> msgMap, Long returnedMoId, String topMoUuid) {
        Set childMo = mo.getChildMos();
        String hql = "from ManagedObject mo where mo.parentMo.moId = " + returnedMoId;
        List<?> oldChildMo = this.resourceDao.findByHql(hql);
        HashMap<String, Long> oldChildMoUUIDIdMap = new HashMap<String, Long>();
        for (ManagedObject oldMo : oldChildMo) {
            oldChildMoUUIDIdMap.put(oldMo.getUuid(), oldMo.getMoId());
        }
        if (childMo == null || childMo.isEmpty()) {
            if (!oldChildMoUUIDIdMap.isEmpty()) {
                LOGGER.debug((Object)"willllllllll delete unexist mo , mo map is : ", 1L);
                this.discoveryService.deleteDevice(new ArrayList(oldChildMoUUIDIdMap.values()));
            }
            return;
        }
        for (ManagedObject tMo : childMo) {
            oldChildMoUUIDIdMap.remove(tMo.getUuid());
            if (tMo.getParentMo() == null) {
                tMo.setParentMo(mo);
                tMo.setTopMoUuid(topMoUuid);
            }
            this.addMoAndSubMoWithoutMsg(tMo, msgMap);
        }
        if (!oldChildMoUUIDIdMap.isEmpty()) {
            LOGGER.debug((Object)"will222222222 delete unexist mo , mo map is : ", 1L);
            this.discoveryService.deleteDevice(new ArrayList(oldChildMoUUIDIdMap.values()));
        }
    }

    public void addMoAndSubMoWithoutMsg(ManagedObject mo, Map<Long, Long> msgMap) {
        LOGGER.debug((Object)"will invoke addMoAndSubMo without msg, mo is : ", 1L);
        if (mo == null) {
            return;
        }
        if (this.discoveryService == null) {
            this.discoveryService = (IDiscoveryService)ServiceContext.getInstance().lookup("discover/DiscoveryServiceImpl");
            if (this.discoveryService == null) {
                LOGGER.error((Object)"can not get the DiscoveryServiceImpl rmi service!!!", 1L);
                return;
            }
        }
        this.processMO1(msgMap, mo);
    }

    private void processMO1(Map<Long, Long> msgMap, ManagedObject mo) {
        String topMoUuid = null;
        if (mo.getIsTopMo().booleanValue()) {
            topMoUuid = mo.getUuid();
            ManagedObject topMo = this.getMoByUuid(topMoUuid, null);
            if (this.checkMoIsTop(topMo, mo)) {
                String newIP = ((TopoObject)mo).getIpAddress();
                String oldIP = ((TopoObject)topMo).getIpAddress();
                String string = oldIP = oldIP == null ? "" : oldIP;
                if (!oldIP.equals(newIP)) {
                    LOGGER.debug((Object)String.format(Locale.ENGLISH, "the ip address of the device changed, old ip is : %s, new ip is : %s, and will send message, message body is : %s", oldIP, newIP, mo), 1L);
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(112L);
                    mu.setObj(mo);
                    mu.setMt(MessageTopic.DATA);
                    mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
                    this.messageCenter.sendMessage(mu);
                }
            }
        } else {
            ManagedObject parentMo = mo.getParentMo();
            if (parentMo == null) {
                LOGGER.error((Object)("the mo is not the top mo, but the mo's parent mo is null, mo is : " + mo), 1L);
            } else {
                topMoUuid = parentMo.getTopMoUuid();
            }
        }
        mo.setTopMoUuid(topMoUuid);
        Long returnedMoId = this.addMoWithoutMsg(mo, msgMap);
        this.addMoAndSubMoWithoutMsgChild(mo, msgMap, returnedMoId, topMoUuid);
    }

    private void addMoAndSubMoIdWithoutDeleteWithoutMsg(ManagedObject mo, Map<Long, Long> msgMap, String topMoUuid) {
        Long moId = this.addMoWithoutMsg(mo, msgMap);
        if (moId != null) {
            mo.setMoId(moId);
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "The mo is added, uuid is :%s, mo id is : %s.", mo.getUuid(), moId), 1L);
        } else {
            LOGGER.warn((Object)("the returned mo id is null, mo uuid is : " + mo.getUuid()), 1L);
        }
        Set childMo = mo.getChildMos();
        if (childMo == null || childMo.isEmpty()) {
            return;
        }
        for (ManagedObject tMo : childMo) {
            if (tMo.getParentMo() == null) {
                tMo.setParentMo(mo);
                tMo.setTopMoUuid(topMoUuid);
            }
            this.addMoAndSubMoWithoutDeleteWithoutMsg(tMo, msgMap);
        }
    }

    public void addMoAndSubMoWithoutDeleteWithoutMsg(ManagedObject mo, Map<Long, Long> msgMap) {
        if (null == mo) {
            LOGGER.error((Object)"The parameter is null.", 1L);
            return;
        }
        LOGGER.debug((Object)"will invoke addMoAndSubMoWithoutDelete without msg, mo is : ", 1L);
        if (this.discoveryService == null) {
            this.discoveryService = (IDiscoveryService)ServiceContext.getInstance().lookup("discover/DiscoveryServiceImpl");
            if (this.discoveryService == null) {
                LOGGER.error((Object)"can not get the DiscoveryServiceImpl rmi service!!!", 1L);
                return;
            }
        }
        String topMoUuid = null;
        if (mo.getIsTopMo().booleanValue()) {
            topMoUuid = mo.getUuid();
            ManagedObject topMo = this.getMoByUuid(topMoUuid, null);
            if (topMo instanceof TopoObject && mo instanceof TopoObject) {
                String newIP = ((TopoObject)mo).getIpAddress();
                String oldIP = ((TopoObject)topMo).getIpAddress();
                if (!oldIP.equals(newIP)) {
                    LOGGER.debug((Object)String.format(Locale.ENGLISH, "The ip address of the device changed, old ip is : %s, new ip is : %s, and will send message, message body is :%s.", oldIP, newIP, mo), 1L);
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(112L);
                    mu.setObj(mo);
                    mu.setMt(MessageTopic.DATA);
                    mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
                    this.messageCenter.sendMessage(mu);
                }
            }
        } else {
            if (mo.getParentMo() == null) {
                LOGGER.error((Object)("the mo is not the top mo, but the mo's parent mo is null, mo is : " + mo), 1L);
            }
            topMoUuid = mo.getParentMo().getTopMoUuid();
        }
        mo.setTopMoUuid(topMoUuid);
        this.addMoAndSubMoIdWithoutDeleteWithoutMsg(mo, msgMap, topMoUuid);
    }

    public void updateMoWithoutMsg(ManagedObject mo) {
        this.resourceDao.updateMoWithoutMsg(mo);
    }

    public void deleteMoWithoutMsg(Long moId) {
        this.resourceDao.deleteMoWithoutMsg(moId);
    }

    public List<Long> addMoWithoutMsg(List<ManagedObject> moList, Map<Long, Long> msgMap) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ManagedObject mo : moList) {
            idList.add(this.addMoWithoutMsg(mo, msgMap));
        }
        return idList;
    }

    public void modifyMoAiasName(Long moId, String newAliasName) {
        Object[] params;
        Object[] param = new Object[]{newAliasName, newAliasName, moId};
        this.resourceDao.updateBySql("update T_managedobject set dev_alias=?, name=? where moid=?", param);
        List<ManagedObject> childMos = this.resourceDao.getChildMo(moId, true);
        for (ManagedObject childMo : childMos) {
            String oldName = childMo.getName();
            String newName = newAliasName;
            if (childMo.getTopMoUuid().startsWith("NasStorage") && !("NasStorage" + childMo.getUuid()).equals(childMo.getTopMoUuid())) {
                Pattern pat = Pattern.compile("\\((.*?)\\)");
                Matcher mat = pat.matcher(oldName);
                while (mat.find()) {
                    newName = newAliasName + mat.group(0);
                }
            }
            params = new Object[]{newName, newName, childMo.getMoId()};
            this.resourceDao.updateBySql("update T_managedobject set dev_alias=?, name=? where moid=? and type like '%Unit'", params);
        }
        String mainType = this.resourceDao.getMoMainTypeByMoId(moId);
        if ("ism.deviceType.vtl.mainType".equals(mainType)) {
            Object[] params2 = new Object[]{newAliasName, moId};
            this.resourceDao.updateBySql("update ti_vtlstorage set name=? where moid=?", params2);
        }
        if ("ism.deviceType.virtualizationServer.mainType".equals(mainType)) {
            StringBuffer selectVirtualhost = new StringBuffer();
            selectVirtualhost.append("select t1.moid  from ti_virtualhost t1").append(" inner join T_managedobject t2 on t1.moid = t2.moid").append(" inner join T_managedobject t3 on t2.parent_id = t3.moid where t3.moid=").append(moId);
            List<?> moids = DaoFactory.getInstance().getResourceDao().findBySql(selectVirtualhost.toString(), new Object[0]);
            for (int i = 0; i < moids.size(); ++i) {
                params = new Object[]{newAliasName, moids.toArray()[i]};
                this.resourceDao.updateBySql("update ti_virtualhost set ownedhostname=? where moid=?", params);
            }
        }
        this.updateAliasForAlarmAndEvent(moId, newAliasName);
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Update the alias successfully, the moid is:%s.the new alias name is:%s.", moId, newAliasName), 1L);
        ManagedObject tmpObject = this.getMOByMoid(moId);
        if (null != tmpObject) {
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(7005L);
            mu.setObj(tmpObject);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
            this.messageCenter.sendMessage(mu);
        }
    }

    private void updateAliasForAlarmAndEvent(Long moId, String newAliasName) {
        Object[] updateParams = new Object[]{newAliasName, moId};
        this.resourceDao.updateBySql("update T_alarm set mo_name=? where mo_id=?", updateParams);
        this.resourceDao.updateBySql("update T_alarm_notifyresitem set moname=? where alarmsource=?", updateParams);
        this.resourceDao.updateBySql("update T_alarm_synctask set moname=? where moid=?", updateParams);
        this.resourceDao.updateBySql("update T_event set mo_name=? where mo_id=?", updateParams);
    }

    public ManagedObject getMOByMoid(Long moid) {
        return this.resourceDao.getMoByIdAndType(ManagedObject.class, moid, true);
    }

    public void onBind(IResourceFilter resourceFilter, Map<String, String> map) {
        this.resourceFilterList.add(resourceFilter);
    }

    public void onUnbind(IResourceFilter resourceFilter, Map<String, String> map) {
        this.resourceFilterList.remove(resourceFilter);
    }

    public List<ManagedObject> getAllTopMO() {
        return this.resourceDao.getAllTopMO();
    }

    public String getMoMainTypeByMoId(Long moId) {
        return this.resourceDao.getMoMainTypeByMoId(moId);
    }

    public void addMoAndSubMoEx(ManagedObject mo, Map<Long, Long> msgMap) {
        if (null == mo) {
            LOGGER.debug((Object)"will invoke addMoAndSubMo without msg, mo is : null");
            return;
        }
        LOGGER.debug((Object)"Will invoke addMoAndSubMo without msg, mo is : %s.", new Object[]{mo});
        String topMoUuid = null;
        topMoUuid = mo.getIsTopMo() != false ? mo.getUuid() : mo.getParentMo().getTopMoUuid();
        ManagedObject topMo = this.getMoByUuid(topMoUuid, true);
        boolean isDisCovery = false;
        if (null == topMo) {
            isDisCovery = true;
        }
        mo.setTopMoUuid(topMoUuid);
        this.addMoWithoutMsg(mo, msgMap);
        this.resourceDao.getBaseHibernateTemplate().flush();
        Map<String, Long> uuidToMoIdMap = this.getUuidToMoIdMap(topMoUuid);
        this.resourceDao.clear();
        HashSet<ManagedObject> mos = new HashSet<ManagedObject>();
        for (ManagedObject moItem : mo.getChildMos()) {
            ManagedObject oldMo;
            Long oldMoId = uuidToMoIdMap.get(moItem.getUuid());
            if (null != oldMoId) {
                moItem.setMoId(oldMoId);
            } else if (!isDisCovery && null != (oldMo = this.getMoByUuid(moItem.getUuid(), true))) {
                LOGGER.debug((Object)"Find mouuid in db:%s and moid is %s.", new Object[]{moItem.getUuid(), oldMo.getMoId()});
                moItem.setMoId(oldMo.getMoId());
            }
            moItem.setTopMoUuid(mo.getTopMoUuid());
            moItem.setParentMo(mo);
            moItem.setRecentUpdateTime(new Timestamp(System.currentTimeMillis()));
            mos.add(moItem);
        }
        this.addSubMoEx(mos, uuidToMoIdMap, isDisCovery);
    }

    public void saveMultiCloudProjectIdMapping(MultiCloudProjectIdMapping mapping) {
        if (VerifyUtil.isEmpty((Object)mapping)) {
            LOGGER.error((Object)"Mapping is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)mapping.getCenterCloudProjectId()) || VerifyUtil.isEmpty((String)mapping.getRegionCloudProjectId()) || VerifyUtil.isEmpty((String)mapping.getRegionId())) {
            LOGGER.error((Object)"Mapping data is invalid!");
            throw new LegoCheckedException(1073947393L);
        }
        MultiCloudProjectIdMapping mappingInDb = this.getMultiCloudProjectIdMapping(mapping.getCenterCloudProjectId(), mapping.getRegionCloudProjectId(), mapping.getRegionId());
        if (!VerifyUtil.isEmpty((Object)mappingInDb)) {
            LOGGER.debug((Object)"Mapping data is already exist.");
            return;
        }
        this.resourceDao.save(mapping);
    }

    public List<MultiCloudProjectIdMapping> getMultiCloudProjectIdMapping(String projectId) {
        String hql = "FROM MultiCloudProjectIdMapping where centerCloudProjectId = ? or regionCloudProjectId = ?";
        ImmutableMap param = ImmutableMap.of((Object)0, (Object)projectId, (Object)1, (Object)projectId);
        List<?> result = this.resourceDao.findByHql(hql, (Map<Integer, String>)param);
        ArrayList<MultiCloudProjectIdMapping> dataList = new ArrayList<MultiCloudProjectIdMapping>();
        if (VerifyUtil.isEmpty(result)) {
            LOGGER.debug((Object)"No data is found.");
            return dataList;
        }
        result.forEach(item -> {
            if (!(item instanceof MultiCloudProjectIdMapping)) {
                LOGGER.debug((Object)"Invalid data is found.");
                return;
            }
            dataList.add((MultiCloudProjectIdMapping)item);
        });
        return dataList;
    }

    public MultiCloudProjectIdMapping getMultiCloudProjectIdMapping(String centerCloudProjectId, String regionCloudProjectId, String regionId) {
        String hql = "FROM MultiCloudProjectIdMapping where centerCloudProjectId = ? and regionCloudProjectId = ? and regionId = ?";
        ImmutableMap param = ImmutableMap.of((Object)0, (Object)centerCloudProjectId, (Object)1, (Object)regionCloudProjectId, (Object)2, (Object)regionId);
        List<?> result = this.resourceDao.findByHql(hql, (Map<Integer, String>)param);
        if (VerifyUtil.isEmpty(result)) {
            LOGGER.debug((Object)"No data is found.");
            return null;
        }
        Object dataInDb = CommonUtil.getFirstElement(result);
        if (VerifyUtil.isEmpty((Object)dataInDb) || !(dataInDb instanceof MultiCloudProjectIdMapping)) {
            LOGGER.debug((Object)"No data is found.");
            return null;
        }
        return (MultiCloudProjectIdMapping)dataInDb;
    }

    private void addSubMoEx(Set<ManagedObject> mos, Map<String, Long> uuidToMoIdMap, boolean isDisCovery) {
        if (null == mos || mos.isEmpty()) {
            LOGGER.debug((Object)"Will invoke addMoAndSubMo without msg, mo is : null or empty.");
            return;
        }
        LOGGER.debug((Object)"Will invoke addMoAndSubMo without msg, mo is : %s.", new Object[]{mos});
        for (ManagedObject mo : mos) {
            if (mo == null) continue;
            this.resourceDao.evict(mo);
        }
        this.resourceDao.saveAll(mos);
        String topMoUuid = null;
        HashSet<ManagedObject> childMos = new HashSet<ManagedObject>();
        for (ManagedObject mo : mos) {
            topMoUuid = mo.getTopMoUuid();
            for (ManagedObject childMo : mo.getChildMos()) {
                ManagedObject oldMo;
                Long oldMoId = uuidToMoIdMap.get(childMo.getUuid());
                if (null != oldMoId) {
                    childMo.setMoId(oldMoId);
                } else if (!isDisCovery && null != (oldMo = this.getMoByUuid(childMo.getUuid(), true))) {
                    LOGGER.debug((Object)"Find mouuid in db:%s and moid is %s.", new Object[]{childMo.getUuid(), oldMo.getMoId()});
                    childMo.setMoId(oldMo.getMoId());
                }
                childMo.setTopMoUuid(topMoUuid);
                childMo.setRecentUpdateTime(new Timestamp(System.currentTimeMillis()));
                childMo.setParentMo(mo);
                childMos.add(childMo);
            }
        }
        this.addSubMoEx(childMos, uuidToMoIdMap, isDisCovery);
    }

    private Map<String, Long> getUuidToMoIdMap(String topMoUuid) {
        String hql = "select moId, uuid from ManagedObject where topMoUuid = ?";
        Object[] params = new Object[]{topMoUuid};
        List<?> results = this.resourceDao.findByHql(hql, params);
        HashMap<String, Long> uuidToMoIdMap = new HashMap<String, Long>();
        if (null != results && !results.isEmpty()) {
            for (Object[] resultArray : results) {
                String uuid = resultArray[1].toString();
                Long moId = Long.valueOf(resultArray[0].toString());
                uuidToMoIdMap.put(uuid, moId);
            }
        }
        return uuidToMoIdMap;
    }
}

