/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.notes;

import com.huawei.lego.cbb.user.service.userrelmo.IUserRelMoService;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;

public class ReceiveMessageMgr
extends MessageTaskManager
implements InitializingBean {
    private static final Log LOGGER = LogFactory.getInstance(ReceiveMessageMgr.class);
    private IUserRelMoService userRelMoService;
    private IMessageCenter mc;

    public IMessageCenter getMc() {
        return this.mc;
    }

    public void setMc(IMessageCenter mc) {
        this.mc = mc;
    }

    @Override
    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters(1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(105L);
        return mrs;
    }

    @Override
    public void onMessage(MessageUnit message) {
        if (null == message) {
            return;
        }
        int messageCode = (int)message.getCmdcode();
        if (105L == (long)messageCode) {
            HashMap msgObj = (HashMap)message.getObj();
            Set<Long> set = msgObj.keySet();
            try {
                this.userRelMoService.deleteManageObject(set, null);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("delete user relation mo is error" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
            }
        }
    }

    public IUserRelMoService getUserRelMoService() {
        return this.userRelMoService;
    }

    public void setUserRelMoService(IUserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    public void afterPropertiesSet() {
        this.mc.addSubscriberTo(this);
    }
}

