/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.operation;

import com.huawei.lego.cbb.user.dao.IOperationDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.service.operation.IOperationService;
import com.huawei.lego.cbb.user.service.roleservice.IRoleService;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.tree.DataElement;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import com.huawei.lego.nem.topo.sdk.model.UIElement;
import com.huawei.lego.nem.topo.sdk.model.UIStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class OperationService
implements IOperationService {
    private IOperationDao operationDao;
    private IRoleService roleService;

    @Override
    public List<OperationInfo> getAllOpt() {
        return this.operationDao.getAllOpt();
    }

    @Override
    public RootDataElement getOptTree(Long roleId) {
        Set set = null;
        if (-2L == roleId) {
            return this.getOptTree();
        }
        RoleInfo role = this.roleService.getRole(roleId);
        set = role.getOperationSet();
        RootDataElement rootTree = null;
        List<OperationInfo> result = this.getAllOpt();
        rootTree = this.getOptTree(result, set);
        return rootTree;
    }

    @Override
    public RootDataElement getOptTree() {
        List<OperationInfo> result = this.getAllOpt();
        RootDataElement rootTree = this.getOptTree(result);
        return rootTree;
    }

    protected DataElement createDataElement(OperationInfo op, int index) {
        DataElement dataEle = new DataElement();
        dataEle.setDisName(op.getOpName());
        dataEle.setEleType(NumberUtil.convertToLong((Object)3));
        dataEle.setId(op.getOpId());
        dataEle.setEntityId("" + op.getOpId());
        dataEle.addStyle(new UIStyle("sortId", "" + index));
        dataEle.addStyle(new UIStyle("ctrlSel", String.valueOf(op.isMaster())));
        return dataEle;
    }

    private RootDataElement getOptTree(Collection<OperationInfo> result) {
        TreeSet<OperationInfo> treeSet = new TreeSet<OperationInfo>();
        for (OperationInfo op : result) {
            String serialNumber = op.getSerialNumber();
            if (serialNumber.equalsIgnoreCase("None")) continue;
            treeSet.add(op);
        }
        RootDataElement rootTree = new RootDataElement();
        HashMap<String, DataElement> dataMap = new HashMap<String, DataElement>();
        int sortId = 0;
        for (OperationInfo op : treeSet) {
            DataElement curDataEle = this.createDataElement(op, ++sortId);
            String serialNumber = op.getSerialNumber();
            if (serialNumber.equalsIgnoreCase("None")) continue;
            int pos = serialNumber.lastIndexOf(45);
            if (pos == -1) {
                rootTree.addChildEle((UIElement)curDataEle);
                dataMap.put(serialNumber, curDataEle);
                continue;
            }
            String parentStr = serialNumber.substring(0, pos);
            DataElement parentEle = (DataElement)dataMap.get(parentStr);
            if (parentEle != null) {
                parentEle.addChildEle((UIElement)curDataEle);
            }
            dataMap.put(serialNumber, curDataEle);
        }
        return rootTree;
    }

    private RootDataElement getOptTree(Collection<OperationInfo> allOpt, Collection<OperationInfo> fliter) {
        ArrayList<OperationInfo> result = new ArrayList<OperationInfo>();
        for (OperationInfo opt : fliter) {
            String[] serialArr;
            int serialArrLen;
            String serialNumber = opt.getSerialNumber();
            if (serialNumber.equalsIgnoreCase("None") || (serialArrLen = (serialArr = serialNumber.split("-")).length) <= 1) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(serialArr[0]);
            this.processOptTree(sb, result, serialArr, allOpt);
        }
        return this.getOptTree(result);
    }

    private void processOptTree(StringBuilder sb, List<OperationInfo> result, String[] serialArr, Collection<OperationInfo> allOpt) {
        for (int i = 0; i < serialArr.length; ++i) {
            if (i != 0) {
                sb.append("-" + serialArr[i]);
            }
            for (OperationInfo temp : allOpt) {
                if (!temp.getSerialNumber().equals(sb.toString())) continue;
                result.add(temp);
            }
        }
    }

    public IOperationDao getOperationDao() {
        return this.operationDao;
    }

    public void setOperationDao(IOperationDao operationDao) {
        this.operationDao = operationDao;
    }

    public void setRoleService(IRoleService roleService) {
        this.roleService = roleService;
    }
}

