/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.scopemanager;

import com.huawei.lego.cbb.user.service.scopemanager.UserAuthInfo;
import com.huawei.lego.core.base.scopemanager.IScopemanager;
import com.huawei.lego.core.base.scopemanager.NameValuePair;
import com.huawei.lego.core.base.scopemanager.ScopeManagerConstant;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Service(name="Scopemanager", desc="", interfaceClass=IScopemanager.class)
public class ScopeManager
extends BaseService
implements IScopemanager,
ILifecycle,
Serializable {
    private static final long serialVersionUID = 4885017051868059850L;
    private static final String ADMIN = "admin";
    private static final Long ADMIN_USER_ID = 1L;
    private static final Long USER_ID_STEP = 2L;
    private static Map<Long, UserAuthInfo> userInfoCache = new HashMap<Long, UserAuthInfo>();
    private static Map<Long, String> userMoidList = new HashMap<Long, String>();
    private static final int LOG_CODE_NUM = 1;
    private static final Log LOGGER = LogFactory.getInstance(ScopeManager.class);
    private String userName = "";
    private String userToken = "";

    public Long getUserIdbyUserName(String usrName) {
        Long userId = 0L;
        if (usrName == null || usrName.isEmpty()) {
            return userId;
        }
        if (this.isAdministrator(usrName)) {
            userId = ADMIN_USER_ID;
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Login user name:%s,user id:%s.", usrName, userId), 1L);
            return userId;
        }
        for (Map.Entry<Long, UserAuthInfo> entry : userInfoCache.entrySet()) {
            if (!usrName.equals(entry.getValue().getUserName())) continue;
            userId = entry.getValue().getUserId();
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Login user name:%s,user id:%s.", usrName, userId), 1L);
        return userId;
    }

    public String getUserName() {
        return this.userName;
    }

    private boolean isAdministrator(String usrName) {
        return usrName.equalsIgnoreCase(ADMIN);
    }

    public Set<String> getAllPermittedOperationsIDByUserId(Long userId) {
        if (userId == null || userId == 0L) {
            return new HashSet<String>();
        }
        for (Map.Entry<Long, UserAuthInfo> entry : userInfoCache.entrySet()) {
            if (!userId.equals(entry.getKey())) continue;
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Login user id:%s, with operations:%s.", userId, entry.getValue().getOperationIds()), 1L);
            return entry.getValue().getOperationIds();
        }
        return new HashSet<String>();
    }

    public Set<String> getAllPermittedSecurityObjID(Long userId) {
        if (userId == null || userId == 0L) {
            return new HashSet<String>();
        }
        for (Map.Entry<Long, UserAuthInfo> entry : userInfoCache.entrySet()) {
            if (!userId.equals(entry.getKey())) continue;
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Login user id:%s, with objects:%s.", userId, entry.getValue().getSecurityIds()), 1L);
            return entry.getValue().getSecurityIds();
        }
        return new HashSet<String>();
    }

    public Set<NameValuePair[]> getAllUserPermissions() {
        HashSet<NameValuePair[]> result = new HashSet<NameValuePair[]>();
        for (Map.Entry<Long, UserAuthInfo> entry : userInfoCache.entrySet()) {
            Long userId = entry.getKey();
            if (userId == 1L || userId == 0L) continue;
            UserAuthInfo user = entry.getValue();
            String usrName = user.getUserName();
            Set<String> objSet = user.getSecurityIds();
            Set<String> opSet = user.getOperationIds();
            NameValuePair[] parameters = new NameValuePair[]{new NameValuePair("uservalue", usrName), new NameValuePair("opset", opSet.toString()), new NameValuePair("objset", objSet.toString())};
            result.add(parameters);
        }
        return result;
    }

    public ScopeManagerConstant saveUserAuthObjID(String usrName, Set<String> securityIds, Set<String> operationIds) {
        if (usrName == null || usrName.isEmpty()) {
            return ScopeManagerConstant.RESULT_NULL;
        }
        this.userName = usrName;
        if (this.isAdministrator(usrName)) {
            UserAuthInfo userAuthInfo = new UserAuthInfo();
            userAuthInfo.setOperationIds(operationIds);
            userAuthInfo.setSecurityIds(securityIds);
            userAuthInfo.setUserId(ADMIN_USER_ID);
            userAuthInfo.setUserName(usrName);
            userInfoCache.put(ADMIN_USER_ID, userAuthInfo);
            return ScopeManagerConstant.RESULT_OK;
        }
        UserAuthInfo userAuthInfo = null;
        Long userId = 0L;
        boolean isExistUser = false;
        for (Map.Entry<Long, UserAuthInfo> entry : userInfoCache.entrySet()) {
            if (!usrName.equals(entry.getValue().getUserName())) continue;
            isExistUser = true;
            userId = entry.getKey();
            userAuthInfo = entry.getValue();
        }
        if (isExistUser && null != userAuthInfo) {
            userAuthInfo.setOperationIds(operationIds);
            userAuthInfo.setSecurityIds(securityIds);
            userInfoCache.put(userId, userAuthInfo);
        } else {
            Long userIdTmp = this.generateUserId(usrName);
            UserAuthInfo userAuthInfoTmp = new UserAuthInfo();
            userAuthInfoTmp.setOperationIds(operationIds);
            userAuthInfoTmp.setSecurityIds(securityIds);
            userAuthInfoTmp.setUserId(userIdTmp);
            userAuthInfoTmp.setUserName(usrName);
            userInfoCache.put(userIdTmp, userAuthInfoTmp);
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Assign login user id:%s,with user name:%s.", userId, usrName), 1L);
        return ScopeManagerConstant.RESULT_OK;
    }

    private Long generateUserId(String usrName) {
        Long userIdMax = 0L;
        if ((userInfoCache == null || userInfoCache.isEmpty()) && !this.isAdministrator(usrName)) {
            Long userIdTmp = userIdMax + USER_ID_STEP;
            return userIdTmp;
        }
        for (Map.Entry<Long, UserAuthInfo> entry : userInfoCache.entrySet()) {
            Long userId = entry.getKey();
            if (userIdMax >= userId) continue;
            userIdMax = userId;
        }
        return userIdMax + 1L;
    }

    public void saveUserMoid(Long userId, String moidStr) {
        if (userId == null || moidStr == null) {
            LOGGER.info((Object)"save user moid para is null!", 0L);
        }
        userMoidList.put(userId, moidStr);
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Save user moid:%s,with user id:%s.", moidStr, userId), 1L);
    }

    public boolean checkUserIsAdmin(Long userId) {
        if (ADMIN_USER_ID.equals(userId)) {
            return true;
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Current userId:%s.", userId), 1L);
        return false;
    }

    public String getUserMoidList(Long userId) {
        String moids = "";
        for (Map.Entry<Long, String> entry : userMoidList.entrySet()) {
            if (!entry.getKey().equals(userId)) continue;
            moids = entry.getValue();
        }
        if (moids == null || moids.isEmpty()) {
            moids = null;
        }
        return moids;
    }

    public boolean checkUserHasRight(Long userId, String opId) {
        Set<String> rights = this.getAllPermittedOperationsIDByUserId(userId);
        boolean hasRight = false;
        for (String right : rights) {
            if (!right.equals(opId)) continue;
            hasRight = true;
            break;
        }
        return hasRight;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public void saveUserToken(String usrToken) {
        if (usrToken != null && !usrToken.isEmpty()) {
            this.userToken = usrToken;
        }
    }
}

