/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.security;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.cbb.user.dao.IRoleDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.service.IUserService;
import com.huawei.lego.cbb.user.service.UserModifyType;
import com.huawei.lego.cbb.user.service.common.SessionGeneratorUtil;
import com.huawei.lego.cbb.user.service.security.IAuthorityService;
import com.huawei.lego.cbb.user.service.security.ISecurity;
import com.huawei.lego.cbb.user.service.security.LoginFailCounter;
import com.huawei.lego.cbb.user.service.security.ThirdAuthorityFactory;
import com.huawei.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.huawei.lego.cbb.user.service.userrelmo.IUserRelMoService;
import com.huawei.lego.cbb.user.thirdauth.SSOAuthority;
import com.huawei.lego.cbb.user.thirdauth.sdk.IThirdAuthority;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.huawei.lego.core.base.scopemanager.IScopemanager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.SortList;
import com.huawei.lego.core.sdk.util.TimeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class AuthorityService
implements IAuthorityService {
    private static final Log LOGGER = LogFactory.getInstance(AuthorityService.class);
    private static final int DEFULT_TIME_OUT = 30;
    private static final int MINUTE_SECOND = 60;
    private static final int MIN_SESSION_TIMEOUT = 1;
    private static final String USER_LOCK = "USER_LOCK";
    private static final String PASSWORD_CHECK_FAIL = "PASSWORD_CHECK_FAIL";
    private static final Integer ERR_PASSWORD_OLDERROR = 258;
    private static final String ADMINGROUP = "administrator";
    private static final String ONLINEUSERSESSIONCOUNT = "userSessionCount_";
    private static final String SYSTEM_USER_LIMIT_ONLINE = "system.user.limit.online";
    private static final long SYSTEM_USER_LIMIT_ONLINE_DEFAULT_VALUE = 100L;
    private ISecurity security;
    private IUserLoginLocalCache cacheService;
    private transient IUserRelMoService userRelMoService;
    private String onlineSessionIdList = "onlineSessionIdList";
    private IThirdAuthority thirdAuthority;
    private SSOAuthority ssoAuthority;
    private IUserService userService;
    private IRoleDao roleDao;
    private IScopemanager scopeManagerService;
    private long sessionLimitSize;

    public IScopemanager getScopeManagerService() {
        return this.scopeManagerService;
    }

    public void setScopeManagerService(IScopemanager scopeManagerService) {
        this.scopeManagerService = scopeManagerService;
    }

    public void setRoleDao(IRoleDao roleDao) {
        this.roleDao = roleDao;
    }

    public void initialize() {
        this.sessionLimitSize = LegoConfig.getInstance().getNumber(SYSTEM_USER_LIMIT_ONLINE, 100L);
    }

    @Override
    public UserInfo login(String hostIp, String userName, String pwd, boolean existInDB) {
        boolean temporaryLock = this.checkTemporaryLock(userName);
        if (temporaryLock) {
            throw new LegoCheckedException(284L);
        }
        UserInfo userInfo = this.checkUserPswRight(userName, pwd, existInDB, false);
        if (userInfo != null) {
            this.doPasswordCheckSuccess(userInfo.isLock(), userName);
            return userInfo;
        }
        this.doPasswordCheckFail(userName, UserModifyType.LOGINPWDFAIL.getValue());
        throw new LegoCheckedException(256L);
    }

    @Override
    public UserInfo loginForSso(String hostIp, String userName, String pwd, boolean existInDB) {
        boolean temporaryLock = this.checkTemporaryLock(userName);
        if (temporaryLock) {
            throw new LegoCheckedException(284L);
        }
        UserInfo userInfo = this.checkUserPswRightForSso(userName, pwd, existInDB);
        if (null != userInfo) {
            this.doPasswordCheckSuccess(userInfo.isLock(), userName);
            return userInfo;
        }
        this.doPasswordCheckFail(userName, UserModifyType.LOGINPWDFAIL.getValue());
        throw new LegoCheckedException(256L);
    }

    @Override
    public String generateSessionId(UserInfo userInfo, String hostIp) {
        String sessionId = SessionGeneratorUtil.generateSessionId(userInfo.getId(), hostIp);
        User onlineUser = new User();
        onlineUser.setLoginDate(TimeUtil.getCurrentDate());
        onlineUser.setLoginTime(System.currentTimeMillis());
        onlineUser.setUserId(userInfo.getId());
        onlineUser.setIpAdr(hostIp);
        onlineUser.setSession(sessionId);
        onlineUser.setUserName(userInfo.getUserName());
        try {
            UserLoginPolicyInfo temp = this.security.getLoginPolicy();
            int saveTime = 0;
            int sessionTimeOut = 0;
            if (null != temp) {
                sessionTimeOut = temp.getSessionTimeOut();
                if (sessionTimeOut < 1) {
                    sessionTimeOut = 30;
                }
                saveTime = 60 * sessionTimeOut;
            } else {
                saveTime = 1800;
            }
            if (null != this.cacheService) {
                ConcurrentSkipListSet set;
                this.cacheService.put(sessionId, onlineUser, saveTime);
                if (!this.cacheService.containsKey(this.onlineSessionIdList)) {
                    set = new ConcurrentSkipListSet();
                    this.cacheService.put(this.onlineSessionIdList, set);
                }
                if (this.cacheService.containsKey(this.onlineSessionIdList)) {
                    set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList);
                    set.add(sessionId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return sessionId;
    }

    @Override
    public UserInfo login(UserInfo userInfo, boolean existInDB) {
        return this.login("", userInfo.getUserName(), userInfo.getUserPwd(), existInDB);
    }

    @Override
    public Boolean checkUserPsw(String userName, String pwd, boolean existInDB) {
        boolean passwordRight = Boolean.FALSE;
        UserInfo userInfo = this.checkUserPswRight(userName, pwd, existInDB, false);
        if (null != userInfo) {
            passwordRight = Boolean.TRUE;
        }
        return passwordRight;
    }

    private ResutObj getEncryptPassword(String userName, String pwd, boolean isUpperNms) {
        ResutObj ojb = new ResutObj();
        String userSalt = this.userService.getSaltByUserName(userName);
        String enPwd = "";
        if (!isUpperNms) {
            enPwd = KmcCompatible.getHashData((String)pwd, (String)userSalt);
        }
        ojb.setEnPwd(enPwd);
        return ojb;
    }

    private UserInfo checkUserPswRight(String userName, String pwd, boolean existInDB, boolean isUpperNms) {
        boolean passwordRight = false;
        ResutObj obj = this.getEncryptPassword(userName, pwd, isUpperNms);
        String enPwd = obj.getEnPwd();
        UserInfo userInfo = null;
        try {
            if (existInDB) {
                userInfo = this.userService.getUserInfoByName(userName, false);
            } else {
                userInfo = new UserInfo();
                userInfo.setPasswordModel(Integer.valueOf(UserAuthorityType.SSO.getValue()));
                userInfo.setUserName(userName);
                userInfo.setLock(false);
            }
        }
        catch (Exception e) {
            return userInfo;
        }
        if (null == userInfo) {
            return userInfo;
        }
        if (userInfo.isLock()) {
            throw new LegoCheckedException(293L);
        }
        try {
            return this.getResultUserInfo(pwd, existInDB, passwordRight, enPwd, userInfo);
        }
        catch (LegoCheckedException e) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Error %s.", ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            throw e;
        }
    }

    private UserInfo getResultUserInfo(String pwd, boolean existInDB, boolean passwordRight, String enPwd, UserInfo userInfo) {
        if (userInfo.getPasswordModel().intValue() == UserAuthorityType.RADIUS.getValue() || userInfo.getPasswordModel().intValue() == UserAuthorityType.LDAP.getValue()) {
            return this.extractMethod(pwd, passwordRight, userInfo);
        }
        if (userInfo.getPasswordModel().intValue() == UserAuthorityType.SSO.getValue()) {
            return this.getUserInfo(userInfo, enPwd, existInDB);
        }
        if (userInfo.getPasswordModel().intValue() == UserAuthorityType.WOS.getValue()) {
            throw new LegoCheckedException(298L);
        }
        return this.updateUserInfo(pwd, userInfo);
    }

    private UserInfo getUserInfo(UserInfo userInfo, String pwd, boolean existInDB) {
        this.ssoAuthority = (SSOAuthority)ThirdAuthorityFactory.getInstance().getThirdAuthorityByType(userInfo.getPasswordModel());
        if (null == this.ssoAuthority) {
            throw new LegoCheckedException(292L);
        }
        try {
            userInfo = this.ssoAuthority.userAuthority(userInfo.getUserName(), pwd, existInDB);
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() == 256L) {
                return null;
            }
            throw ex;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, null, (long)102L, null, (Log)LOGGER);
        }
        return userInfo;
    }

    private UserInfo updateUserInfo(String pwd, UserInfo userInfo) {
        if (KmcCompatible.isDataSame((String)pwd, (String)userInfo.getUserPwdSalt(), (String)userInfo.getUserPwd())) {
            userInfo.setUserPwdSalt("");
            userInfo.setUserPwd(KmcInstance.protectPwdEx((String)pwd));
            this.userService.updateUser(userInfo, false);
            return userInfo;
        }
        return null;
    }

    private UserInfo extractMethod(String pwd, boolean passwordRight, UserInfo userInfo) {
        this.thirdAuthority = ThirdAuthorityFactory.getInstance().getThirdAuthorityByType(userInfo.getPasswordModel());
        if (null == this.thirdAuthority) {
            throw new LegoCheckedException(292L);
        }
        try {
            passwordRight = this.thirdAuthority.userAuthority(userInfo.getUserName(), pwd);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 256L) {
                return null;
            }
            throw e;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, null, (long)102L, null, (Log)LOGGER);
        }
        if (passwordRight) {
            return userInfo;
        }
        return null;
    }

    private UserInfo checkUserPswRightForSso(String userName, String pwd, boolean existInDB) {
        boolean passwordRight = false;
        String enPwd = pwd;
        UserInfo userInfo = null;
        try {
            if (existInDB) {
                userInfo = this.userService.getUserInfoByName(userName, false);
            } else {
                userInfo = new UserInfo();
                userInfo.setPasswordModel(Integer.valueOf(UserAuthorityType.SSO.getValue()));
                userInfo.setUserName(userName);
                userInfo.setLock(false);
            }
        }
        catch (Exception e) {
            return userInfo;
        }
        if (null == userInfo) {
            return userInfo;
        }
        if (userInfo.isLock()) {
            throw new LegoCheckedException(293L);
        }
        try {
            return this.getUpdateUserInfo(pwd, existInDB, passwordRight, enPwd, userInfo);
        }
        catch (LegoCheckedException e) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Error %s.", ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            throw e;
        }
    }

    private UserInfo getUpdateUserInfo(String pwd, boolean existInDB, boolean passwordRight, String enPwd, UserInfo userInfo) {
        if (userInfo.getPasswordModel().intValue() == UserAuthorityType.RADIUS.getValue() || userInfo.getPasswordModel().intValue() == UserAuthorityType.LDAP.getValue()) {
            return this.extractMethod(pwd, passwordRight, userInfo);
        }
        if (userInfo.getPasswordModel().intValue() == UserAuthorityType.SSO.getValue()) {
            return this.userInfoAuthority(userInfo, enPwd, existInDB);
        }
        if (userInfo.getPasswordModel().intValue() == UserAuthorityType.WOS.getValue()) {
            throw new LegoCheckedException(298L);
        }
        if (!enPwd.equals(userInfo.getUserPwd())) {
            return null;
        }
        return userInfo;
    }

    private UserInfo userInfoAuthority(UserInfo userInfo, String pwd, boolean existInDB) {
        this.ssoAuthority = (SSOAuthority)ThirdAuthorityFactory.getInstance().getThirdAuthorityByType(userInfo.getPasswordModel());
        if (null == this.ssoAuthority) {
            throw new LegoCheckedException(292L);
        }
        try {
            userInfo = this.ssoAuthority.userAuthority(userInfo.getUserName(), pwd, existInDB);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 256L) {
                return null;
            }
            throw e;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, null, (long)102L, null, (Log)LOGGER);
        }
        return userInfo;
    }

    @Override
    public void logout(String sessionId) {
        ConcurrentSkipListSet set;
        if (null == this.cacheService) {
            return;
        }
        if (this.cacheService.containsKey(sessionId, true)) {
            this.cacheService.remove(sessionId);
        }
        if (this.cacheService.containsKey(this.onlineSessionIdList) && (set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList)).contains(sessionId)) {
            set.remove(sessionId);
        }
        this.dealOnLineSessionCountWhenLogOut(sessionId);
    }

    private void dealOnLineSessionCountWhenLogOut(String sessionId) {
        String userId = SessionGeneratorUtil.getUserIdFromSessionId(sessionId);
        this.cacheService.syncMinusSessionCount(ONLINEUSERSESSIONCOUNT + userId, Integer.MIN_VALUE);
    }

    @Override
    public List<String> getOnlineUserSession(long userId) {
        ArrayList<String> onLineUserSessionList = new ArrayList<String>();
        if (null == this.cacheService) {
            return null;
        }
        if (this.cacheService.containsKey(this.onlineSessionIdList)) {
            ConcurrentSkipListSet set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList);
            this.initSessionList(set, userId, onLineUserSessionList);
        }
        return onLineUserSessionList;
    }

    private void initSessionList(ConcurrentSkipListSet<String> set, long userId, List<String> onLineUserSessionList) {
        for (String temp : set) {
            if (this.cacheService.containsKey(temp, true)) {
                User tempUser = (User)this.cacheService.get(temp, true);
                if (tempUser.getUserId() != userId) continue;
                onLineUserSessionList.add(tempUser.getSession());
                continue;
            }
            LOGGER.info((Object)"Deleting Expired Sessions.");
            set.remove(temp);
        }
    }

    @Override
    public List<User> getAllOnlineUser(User user) {
        if (null == this.cacheService) {
            return null;
        }
        ArrayList<User> allOnLineUser = new ArrayList<User>();
        if (this.cacheService.containsKey(this.onlineSessionIdList)) {
            ConcurrentSkipListSet set = (ConcurrentSkipListSet)this.cacheService.get(this.onlineSessionIdList);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String temp = (String)iterator.next();
                if (this.cacheService.containsKey(temp, true)) {
                    User tempUser = (User)this.cacheService.get(temp, true);
                    this.setOnLinUser(user, tempUser, allOnLineUser);
                    continue;
                }
                iterator.remove();
                this.dealOnLineSessionCountWhenLogOut(temp);
            }
        }
        return allOnLineUser;
    }

    private void setOnLinUser(User user, User tempUser, List<User> allOnLineUser) {
        if (null == user || user.getUserId().equals(tempUser.getUserId())) {
            String stayTime = TimeUtil.getInterval((long)tempUser.getLoginTime());
            tempUser.setStayTime(stayTime);
            allOnLineUser.add(tempUser);
        }
    }

    @Override
    public List<User> getAllOnlineUser(User user, String sortFile, String sortType) {
        String sort = sortType;
        List<User> list = this.getAllOnlineUser(user);
        if (null == list) {
            list = new ArrayList<User>();
        }
        String methodName = "";
        SortList sortList = new SortList();
        if (sortFile.equals("ipAdr")) {
            methodName = "getIpAdr";
        } else if (sortFile.equals("userName")) {
            methodName = "getUserName";
        } else if (sortFile.equals("stayTime")) {
            sort = this.turnOver(sortType);
            methodName = "getLoginTime";
        } else if (sortFile.equals("loginDate")) {
            methodName = "getLoginDate";
        }
        sortList.sort(list, methodName, sort);
        return list;
    }

    @Override
    public boolean checkTimeout(String sessionId, boolean prolongTime) {
        if (null == this.cacheService) {
            LOGGER.debug((Object)"cacheService is null", 1L);
            return true;
        }
        Boolean result = Boolean.TRUE;
        if (prolongTime) {
            if (this.cacheService.containsKey(sessionId)) {
                result = Boolean.FALSE;
            }
        } else if (this.cacheService.containsKey(sessionId, true)) {
            result = Boolean.FALSE;
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "CheckTimeout result is : %s prolongTime is : %s.", result, prolongTime), 1L);
        return result;
    }

    @Override
    public Map checkUserRight(long userId, List<String> opIds) {
        UserInfo user = null;
        try {
            user = this.userService.getFullUserInfoById(userId);
        }
        catch (Exception e) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "User is null%s.", ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        if (null == user) {
            return null;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (null != opIds) {
            for (String i : opIds) {
                map.put(i, this.checkUserRight(userId, i));
            }
        }
        return map;
    }

    @Override
    public boolean checkUserRight(long userId, String opId) {
        boolean hasRight = false;
        if (userId <= 0L) {
            UserInfo user = this.ssoAuthority.create(userId, "");
            return this.isHasRight(opId, hasRight, user.getRolesSet());
        }
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            hasRight = Boolean.TRUE;
            return hasRight;
        }
        UserInfo user = null;
        try {
            user = this.userService.getFullUserInfoById(userId);
        }
        catch (Exception e) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "User is null%s.", ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        if (null == user) {
            return hasRight;
        }
        Set roleSet = user.getRolesSet();
        if (null == roleSet) {
            return hasRight;
        }
        return this.isHasRight(opId, hasRight, roleSet);
    }

    private boolean isHasRight(String opId, boolean hasRight, Set<RoleInfo> roleSet) {
        for (RoleInfo role : roleSet) {
            Set operSet = role.getOperationSet();
            if (null == operSet) {
                return hasRight;
            }
            for (OperationInfo operInfo : operSet) {
                if (!opId.equalsIgnoreCase(operInfo.getOpName())) continue;
                hasRight = true;
                return hasRight;
            }
        }
        return hasRight;
    }

    @Override
    public Boolean checkUserIsAdminGroup(long userId) {
        Set roleSet;
        Boolean result = Boolean.FALSE;
        UserInfo user = null;
        try {
            user = this.userService.getUserInfoById(userId, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        if (null != user && null != (roleSet = user.getRolesSet()) && !roleSet.isEmpty()) {
            result = this.ssAdminGroup(roleSet);
        }
        return result;
    }

    private Boolean ssAdminGroup(Set<RoleInfo> roleSet) {
        Boolean result = Boolean.FALSE;
        for (RoleInfo role : roleSet) {
            if (!ADMINGROUP.equals(role.getRoleName())) continue;
            result = Boolean.TRUE;
            return result;
        }
        return result;
    }

    @Override
    public Boolean checkUserIsAdmin(long userId) {
        Boolean result = Boolean.FALSE;
        UserInfo user = null;
        try {
            user = userId <= 0L ? this.ssoAuthority.create(userId, null) : this.userService.getUserInfoById(userId, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        if (null != user) {
            result = user.isAdmin();
        }
        return result;
    }

    @Override
    public Boolean checkUserIsAuditor(long userId) {
        Set roleSet;
        Boolean result = Boolean.FALSE;
        UserInfo user = null;
        try {
            user = this.userService.getUserInfoById(userId, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        if (null != user && null != (roleSet = user.getRolesSet()) && !roleSet.isEmpty()) {
            return this.checkRoleSet(roleSet);
        }
        return result;
    }

    private Boolean checkRoleSet(Set<RoleInfo> roleSet) {
        Boolean result = Boolean.FALSE;
        for (RoleInfo role : roleSet) {
            if (role.getRoleIdx() != 3L) continue;
            result = Boolean.TRUE;
            return result;
        }
        return result;
    }

    @Override
    public List<Long> getUserGrandObjects(UserInfo userInfo) {
        return this.getUserGrandObjects(userInfo.getId());
    }

    @Override
    public List<Long> getUserGrandObjects(long userId) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            list.add(-1L);
        } else {
            List<UserRelMoInfo> relMoList = this.userRelMoService.getUserAllRelMO(userId);
            for (UserRelMoInfo userRelMoInfo : relMoList) {
                list.add(userRelMoInfo.getId().getMoId());
            }
        }
        return list;
    }

    @Override
    public Boolean checkUserGrandObject(long userId, long moId) {
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            return Boolean.TRUE;
        }
        return this.userRelMoService.checkUserRight(userId, moId);
    }

    @Override
    public Set<String> getUserOpids(UserInfo userInfo) {
        return this.getUserAllOpNames(userInfo.getId());
    }

    @Override
    public Set<String> getUserOpids(int userId) {
        return this.getUserAllOpNames(userId);
    }

    @Override
    public Set<String> getUserAllOpNames(long userId) {
        HashSet<String> set = new HashSet<String>();
        UserInfo user = null;
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            return null;
        }
        try {
            user = this.userService.getFullUserInfoById(userId);
        }
        catch (Exception e) {
            LOGGER.error((Object)"get user is error", 1L);
        }
        if (null == user) {
            set.add(null);
            return set;
        }
        Set roleSet = user.getRolesSet();
        if (null == roleSet) {
            return set;
        }
        for (RoleInfo role : roleSet) {
            Set operSet = role.getOperationSet();
            if (null == operSet) continue;
            for (OperationInfo operInfo : operSet) {
                set.add(operInfo.getOpName());
            }
        }
        return set;
    }

    @Override
    public Set<String> getSSOUserAllOpNames(long roleId) {
        HashSet<String> set = new HashSet<String>();
        RoleInfo roleinfo = this.roleDao.getRoleById(roleId, true);
        Set operSet = roleinfo.getOperationSet();
        if (null != operSet) {
            for (OperationInfo operInfo : operSet) {
                set.add(operInfo.getOpName());
            }
        }
        return set;
    }

    private boolean checkTemporaryLock(String userName) {
        boolean isLock = Boolean.FALSE;
        UserLoginPolicyInfo loginPolicyInfo = this.security.getLoginPolicy();
        if (null == loginPolicyInfo || loginPolicyInfo.getUnseal() < 1) {
            return isLock;
        }
        if (this.cacheService == null) {
            return isLock;
        }
        String userLockKey = USER_LOCK + userName;
        if (this.cacheService.containsKey(userLockKey, true)) {
            isLock = Boolean.TRUE;
        }
        return isLock;
    }

    private void doPasswordCheckFail(String userName, int isModify) {
        UserLoginPolicyInfo loginPolicyInfo = this.security.getLoginPolicy();
        if (null == loginPolicyInfo || loginPolicyInfo.getUnseal() < 1) {
            return;
        }
        String loginFailKey = PASSWORD_CHECK_FAIL + userName;
        String userLockKey = USER_LOCK + userName;
        int loginFainlCount = 0;
        LoginFailCounter loginFailUser = this.putLoginFailUser(loginPolicyInfo, loginFailKey);
        loginFainlCount = loginFailUser.getCount();
        loginFailUser.setCount(++loginFainlCount);
        try {
            if (loginFainlCount >= loginPolicyInfo.getLgoinCount()) {
                this.checkedLockTime(userName, isModify, loginPolicyInfo, loginFailKey, userLockKey);
            } else {
                this.getLoginFainlCount(isModify, loginPolicyInfo, loginFainlCount, loginFailUser);
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Error %s.", ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            throw e;
        }
    }

    private void doPasswordCheckSuccess(boolean userLock, String userName) {
        if (userLock) {
            throw new LegoCheckedException(293L);
        }
        String passwordCheckFailKey = PASSWORD_CHECK_FAIL + userName;
        if (this.cacheService != null && this.cacheService.containsKey(passwordCheckFailKey, true)) {
            this.cacheService.remove(passwordCheckFailKey);
        }
    }

    private void checkedLockTime(String userName, int isModify, UserLoginPolicyInfo loginPolicyInfo, String loginFailKey, String userLockKey) {
        int lockTime = loginPolicyInfo.getLockTime();
        if (lockTime < 0) {
            this.getUserIdByName(userName, isModify, loginFailKey, userLockKey);
        } else {
            Date lockToDate = TimeUtil.getAftertime((int)lockTime);
            this.cacheService.put(userLockKey, userLockKey, lockToDate);
        }
        this.cacheService.remove(loginFailKey);
        if (1 == isModify) {
            throw new LegoCheckedException(2602L);
        }
        if (2 == isModify) {
            throw new LegoCheckedException(2606L);
        }
        throw new LegoCheckedException(284L);
    }

    private void getLoginFainlCount(int isModify, UserLoginPolicyInfo loginPolicyInfo, int loginFainlCount, LoginFailCounter loginFailUser) {
        loginFailUser.setCount(loginFainlCount);
        if (loginFainlCount == loginPolicyInfo.getLgoinCount() - 1) {
            if (1 == isModify) {
                throw new LegoCheckedException(2601L);
            }
            if (2 == isModify) {
                throw new LegoCheckedException(2605L);
            }
            throw new LegoCheckedException(282L);
        }
    }

    private void getUserIdByName(String userName, int isModify, String loginFailKey, String userLockKey) {
        block4: {
            try {
                this.security.lockUser(userName);
            }
            catch (LegoCheckedException ex) {
                if (ex.getErrorCode() != 201L) break block4;
                Date lockToDate = TimeUtil.getAftertime((int)1800);
                this.cacheService.put(userLockKey, userLockKey, lockToDate);
                this.cacheService.remove(loginFailKey);
                if (1 == isModify) {
                    throw new LegoCheckedException(2602L, (Throwable)ex);
                }
                if (2 == isModify) {
                    throw new LegoCheckedException(2606L, (Throwable)ex);
                }
                throw new LegoCheckedException(284L, (Throwable)ex);
            }
        }
    }

    private LoginFailCounter putLoginFailUser(UserLoginPolicyInfo loginPolicyInfo, String loginFailKey) {
        LoginFailCounter loginFailUser = (LoginFailCounter)this.cacheService.get(loginFailKey, true);
        if (null == loginFailUser) {
            loginFailUser = new LoginFailCounter();
            int interval = 10;
            if (null != loginPolicyInfo.getLgoinInterval() && (interval = loginPolicyInfo.getLgoinInterval().intValue()) <= 0) {
                interval = 10;
            }
            Date failTodate = TimeUtil.getAftertime((int)interval);
            this.cacheService.put(loginFailKey, loginFailUser, failTodate);
        }
        return loginFailUser;
    }

    private String turnOver(String sortType) {
        if (sortType.equalsIgnoreCase("desc")) {
            return "asc";
        }
        return "desc";
    }

    @Override
    public void clearLoginFailHistory() {
    }

    public void setCacheService(IUserLoginLocalCache cacheService) {
        this.cacheService = cacheService;
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setUserRelMoService(IUserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    @Override
    public UserInfo login(String hostIP, String pwd, String userName) {
        return this.login(hostIP, userName, pwd, true);
    }

    @Override
    public UserInfo login(UserInfo userInfo) {
        return this.login(userInfo, true);
    }

    @Override
    public Boolean checkUserPsw(String userName, String pwd) {
        return this.checkUserPsw(userName, pwd, true);
    }

    @Override
    public UserInfo loginForUpNms(String hostIp, String userName, String pwd, boolean existInDB) {
        boolean temporaryLock = this.checkTemporaryLock(userName);
        if (temporaryLock) {
            throw new LegoCheckedException(284L);
        }
        UserInfo userInfo = this.checkUserPswRight(userName, pwd, existInDB, true);
        if (userInfo != null) {
            this.doPasswordCheckSuccess(userInfo.isLock(), userName);
            return userInfo;
        }
        this.doPasswordCheckFail(userName, UserModifyType.LOGINPWDFAIL.getValue());
        throw new LegoCheckedException(256L);
    }

    @Override
    public void checkLock(String userName, String userPwd, String newPwd, String salt) {
        boolean temporaryLock = this.checkTemporaryLock(userName);
        if (temporaryLock) {
            throw new LegoCheckedException(2602L);
        }
        if (KmcCompatible.isDataSame((String)newPwd, (String)salt, (String)userPwd)) {
            this.doPasswordCheckSuccess(false, userName);
            return;
        }
        this.doPasswordCheckFail(userName, UserModifyType.MODIFYPWDFAIL.getValue());
        throw new LegoCheckedException((long)ERR_PASSWORD_OLDERROR.intValue());
    }

    @Override
    public void checkLock(String userName, String userPwd, boolean modify) {
        this.login("", userName, userPwd, true);
    }

    @Override
    public void checkLockSuper(String userName, String userPwd, String newPwd, String salt) {
        boolean temporaryLock = this.checkTemporaryLock(userName);
        if (temporaryLock) {
            throw new LegoCheckedException(2606L);
        }
        if (KmcCompatible.isDataSame((String)newPwd, (String)salt, (String)userPwd)) {
            this.doPasswordCheckSuccess(false, userName);
            return;
        }
        this.doPasswordCheckFail(userName, UserModifyType.MODIFYPWDSUPERFAIL.getValue());
        throw new LegoCheckedException(260L);
    }

    @Override
    public void checkUserSessionControl(UserInfo userInfo) {
        if (null == userInfo) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkCacheSize(true);
        String key = ONLINEUSERSESSIONCOUNT + userInfo.getId();
        if (NumberUtil.getBooleanValue((Boolean)userInfo.isSessionControl())) {
            try {
                this.cacheService.syncAddSessionCount(key, NumberUtil.getIntValue((Integer)userInfo.getSessionLimit()));
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("the user: " + userInfo.getId() + "exceed count: " + userInfo.getSessionLimit()));
                throw new LegoCheckedException(1073947448L, (Throwable)e);
            }
        } else {
            this.cacheService.syncAddSessionCount(key, Integer.MAX_VALUE);
        }
    }

    private void checkCacheSize(boolean reserve) {
        boolean result;
        int sessionCacheSize;
        Object sessions = this.cacheService.get(this.onlineSessionIdList);
        Set onlines = sessions instanceof Set ? (Set)sessions : null;
        int n = sessionCacheSize = onlines != null ? onlines.size() : 0;
        if (reserve) {
            result = (long)sessionCacheSize < this.sessionLimitSize;
        } else {
            boolean bl = result = (long)sessionCacheSize <= this.sessionLimitSize;
        }
        if (!result) {
            throw new LegoCheckedException(1073947466L, new String[]{String.valueOf(this.sessionLimitSize)});
        }
    }

    static class ResutObj {
        private String enPwd;

        ResutObj() {
        }

        public String getEnPwd() {
            return this.enPwd;
        }

        public void setEnPwd(String enPwd) {
            this.enPwd = enPwd;
        }
    }
}

