/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms.messagemanager;

import com.huawei.lego.com.internal.ICommandCodeService;
import com.huawei.lego.comm.internal.jms.core.MessageCenter;
import com.huawei.lego.comm.internal.jms.messagecodebase.MessageCodeRegisterException;
import com.huawei.lego.comm.internal.jms.messagemanager.MessageChecker;
import com.huawei.lego.comm.internal.jms.util.ClassFiler;
import com.huawei.lego.core.sdk.exception.jms.LegoJMSInitializeException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MessageCollecter
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getInstance(MessageCollecter.class);
    private MessageChecker mche = new MessageChecker();
    private List<String> classinfo = null;
    private Map<String, ClassFiler> classs = null;

    public void setThisBundleName(String[] name) {
    }

    public void setClasses(Map<String, ClassFiler> classFilters) {
        this.classs = classFilters;
    }

    public void regist(ICommandCodeService service) {
        List codes = service.getProductCommandCodes();
        if (null == codes) {
            LOGGER.error((Object)"Error whe regist product code, the service return null!", 1L);
            return;
        }
        try {
            MessageCenter mc = MessageCenter.getInstance();
            String pn = service.getProductName().getProductName();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Product:%s register command code num:%s.", pn, codes.size()), 1L);
            for (Long code : codes) {
                this.mche.judgeSpecialMessage(code, pn);
                mc.registerMessageCode(code, pn);
            }
        }
        catch (MessageCodeRegisterException mcre) {
            LOGGER.error((Object)"", (Throwable)((Object)mcre), 1L);
            throw mcre;
        }
        catch (LegoJMSInitializeException e) {
            LOGGER.error((Object)"", (Throwable)e, 1L);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    public ClassFiler checkClassExist(String key) {
        if (null != this.classs) {
            return this.classs.get(key);
        }
        return null;
    }

    public void delClassByKey(String key) {
        if (null != this.classs) {
            this.classs.remove(key);
        }
    }

    public void onBind(ICommandCodeService service, Map<String, String> properties) {
        this.regist(service);
    }

    public void onUnBind(ICommandCodeService service, Map<String, String> properties) {
    }

    public void destroy() {
    }

    public void afterPropertiesSet() {
    }
}

