/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.keystore;

import com.huawei.lego.comm.keystore.KeyStoreConfig;
import com.huawei.lego.core.base.util.KeyStoreLoader;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.security.KeyStore;

public class KeystoreUtil {
    public static KeyStore loadKeyStore(KeyStoreConfig keyStoreConfig) {
        return KeyStoreLoader.getKeyStore(keyStoreConfig.getKeyStorePath(), () -> new KeyStoreLoader(keyStoreConfig.getKeyStoreType(), Paths.get(keyStoreConfig.getKeyStorePath(), new String[0]), keyStoreConfig::getDecodedKeyStorePass));
    }

    public static KeyStore loadKeyStore(String path, String storePass, String storeType) throws Exception {
        try (FileInputStream in = new FileInputStream(path);){
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(in, storePass.toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
    }
}

