/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.comm.security.ProtocolManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class BcmSSLSocketFactory
extends SSLSocketFactory {
    private static final Log logger = LogFactory.getInstance(BcmSSLSocketFactory.class);
    private String ip;
    private String[] protocols;

    public BcmSSLSocketFactory(String ipAddress, String ... protocols) {
        String[] stringArray;
        if (VerifyUtil.isEmpty((String)ipAddress)) {
            logger.error((Object)"ipAddress is null.");
            throw new LegoCheckedException(207L);
        }
        this.ip = ipAddress;
        if (VerifyUtil.isEmpty((Object[])protocols)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "TLSv1.2";
        } else {
            stringArray = protocols;
        }
        this.protocols = stringArray;
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        Socket socket = sslSocketFactory.createSocket();
        if (socket instanceof SSLSocket) {
            ProtocolManager.resetEnabledProtocolsAndCipherSuites((SSLSocket)socket, this.protocols);
        }
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        Socket sslSocket = sslSocketFactory.createSocket(socket, host, port, autoClose);
        if (sslSocket instanceof SSLSocket) {
            ProtocolManager.resetEnabledProtocolsAndCipherSuites((SSLSocket)sslSocket, this.protocols);
        }
        return sslSocket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        return sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        return sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        Socket socket = sslSocketFactory.createSocket(host, port);
        if (socket instanceof SSLSocket) {
            ProtocolManager.resetEnabledProtocolsAndCipherSuites((SSLSocket)socket, this.protocols);
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        Socket socket = sslSocketFactory.createSocket(host, port);
        if (socket instanceof SSLSocket) {
            ProtocolManager.resetEnabledProtocolsAndCipherSuites((SSLSocket)socket, this.protocols);
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        Socket socket = sslSocketFactory.createSocket(host, port, localHost, localPort);
        if (socket instanceof SSLSocket) {
            ProtocolManager.resetEnabledProtocolsAndCipherSuites((SSLSocket)socket, this.protocols);
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory();
        Socket socket = sslSocketFactory.createSocket(address, port, localAddr, localPort);
        if (socket instanceof SSLSocket) {
            ProtocolManager.resetEnabledProtocolsAndCipherSuites((SSLSocket)socket, this.protocols);
        }
        return socket;
    }

    public SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sslSocketFactory;
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new BcmX509TrustManager(this.ip)}, SecureRandomFactory.getInstanceStrongWithDRBG());
            sslSocketFactory = context.getSocketFactory();
        }
        catch (Exception e) {
            logger.error((Object)("Creating SSLSocketFactory failed,ipAddress=" + this.ip + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(207L, "Initializing BcmSSLSocketFactory failed.", (Throwable)e);
        }
        return sslSocketFactory;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }
}

