/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.ism.drm.wcc.util.alarm.CertAlarmQueue;
import com.huawei.ism.drm.wcc.util.alarm.CertAuthFail;
import com.huawei.ism.drm.wcc.util.alarm.CertAuthSuccess;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.ICommonService;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.cbb.resource.util.DaoFactory;
import com.huawei.lego.cbb.resource.util.DaoParamUtil;
import com.huawei.lego.comm.security.ICertificateServerCallback;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CertificateServerCallbackManager {
    private static final int START_TIME = 60000;
    private static final int INTERVAL_TIME = 60000;
    private static final Log LOGGER = LogFactory.getInstance(CertificateServerCallbackManager.class);
    private static CertificateServerCallbackManager instance;
    private static Set<ICertificateServerCallback> callbackList;

    public static synchronized CertificateServerCallbackManager getInstance() {
        if (null == instance) {
            instance = new CertificateServerCallbackManager();
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            CertificateServerCallbackManager.startProcessSuccessCertThread();
            scheduler.scheduleAtFixedRate(() -> {
                try {
                    CertificateServerCallbackManager.processFailedCert();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception occurred when processFailedCert, msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                try {
                    CertificateServerCallbackManager.processRevokedCert();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception occurred when processRevokedCert, msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
            }, 60000L, 60000L, TimeUnit.MILLISECONDS);
        }
        return instance;
    }

    public void onBind(ICertificateServerCallback callback, Map<?, ?> properties) {
        callbackList.add(callback);
    }

    public void onUnbind(ICertificateServerCallback callback, Map<?, ?> properties) {
        callbackList.remove(callback);
    }

    private static String getAlarmParam(String ipAddress) {
        IResourceService resourceService = ServiceProvider.getResourceService();
        if (null == resourceService) {
            LOGGER.info((Object)"get IResourceService null.", 1L);
            return null;
        }
        ManagedObject managedObject = resourceService.getMoByIp(ipAddress);
        if (null != managedObject) {
            return managedObject.getUuid();
        }
        String moId = CertificateServerCallbackManager.getMoIdForRemoteServer(ipAddress);
        if (!VerifyUtil.isEmpty((String)moId)) {
            return moId;
        }
        String remoteSyslogServerId = CertificateServerCallbackManager.getIdForRemoteSyslogServer(ipAddress);
        if (!VerifyUtil.isEmpty((String)remoteSyslogServerId)) {
            return remoteSyslogServerId;
        }
        String ssoServerId = CertificateServerCallbackManager.getSSOAlarmParam(ipAddress);
        if (!VerifyUtil.isEmpty((String)ssoServerId)) {
            return ssoServerId;
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Device is not exist in DB.ipAddress=%s.", ipAddress), 1L);
        return ipAddress;
    }

    private static String getSSOAlarmParam(String ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        if (!ipAddress.startsWith("SSO-Server:")) {
            return null;
        }
        String ipInfo = AddressUtil.getIpInStr((String)ipAddress);
        if (ipInfo == null) {
            return null;
        }
        return "syslog" + ipInfo.replace(".", "");
    }

    private static void processFailedCert() {
        try {
            Iterator iterator = CertAlarmQueue.getFailedCertMap().iterator();
            while (iterator.hasNext()) {
                CertAuthFail certAuthFail = (CertAuthFail)iterator.next();
                String ipAddress = certAuthFail.getIpAddress();
                String alarmParam = CertificateServerCallbackManager.getAlarmParam(ipAddress);
                if (!VerifyUtil.isEmpty((String)alarmParam)) {
                    CertificateServerCallbackManager.notifyAllCallback(certAuthFail, alarmParam);
                    iterator.remove();
                    iterator = CertAlarmQueue.getFailedCertMap().iterator();
                    continue;
                }
                if (System.currentTimeMillis() - certAuthFail.getAlarmCreateTime() <= 0x6DDD00L) continue;
                iterator.remove();
            }
        }
        catch (Exception t) {
            LOGGER.error((Object)("processCert Catch a Exception" + ExceptionUtil.getErrorMessage((Throwable)t)), 200L);
        }
    }

    private static void processRevokedCert() {
        String ipAddress;
        Iterator revokedIterator = CertAlarmQueue.getRevokedCertMap().entrySet().iterator();
        while (revokedIterator.hasNext()) {
            Map.Entry entry = revokedIterator.next();
            ipAddress = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            CertAlarmQueue.removeUnRevokedCert((String)ipAddress);
            for (ICertificateServerCallback callback : callbackList) {
                try {
                    callback.failForRevokedCert(ipAddress, set);
                    revokedIterator.remove();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"FailForRevokedCert notify callback exception.", (Throwable)e);
                }
            }
        }
        Iterator unRevokedCertIterator = CertAlarmQueue.getUnRevokedCertMap().iterator();
        while (unRevokedCertIterator.hasNext()) {
            ipAddress = (String)unRevokedCertIterator.next();
            for (ICertificateServerCallback callback : callbackList) {
                try {
                    callback.restoreForRevokedCert(ipAddress);
                    unRevokedCertIterator.remove();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"FailForRevokedCert notify callback exception.", (Throwable)e);
                }
            }
        }
    }

    private static void startProcessSuccessCertThread() {
        Runnable processSuccessCertRunnable = () -> {
            while (true) {
                try {
                    while (true) {
                        CertificateServerCallbackManager.doProcessSuccessCert();
                    }
                }
                catch (Exception t) {
                    LOGGER.error((Object)"ProcessSuccessCert Catch a Exception:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)t)});
                    continue;
                }
                break;
            }
        };
        ExecutionService.submit(processSuccessCertRunnable);
    }

    private static void doProcessSuccessCert() throws InterruptedException {
        CertAuthSuccess certAuthSuccess = CertAlarmQueue.getSucceededCert();
        if (VerifyUtil.isEmpty(callbackList)) {
            LOGGER.warn((Object)"Failed to processSuccessCert, cause callbackList is empty.");
            return;
        }
        String ipAddress = certAuthSuccess.getIpAddress();
        String alarmParam = CertificateServerCallbackManager.getAlarmParam(ipAddress);
        CertAlarmQueue.removeFailedCert((CertAuthSuccess)certAuthSuccess);
        for (ICertificateServerCallback callback : callbackList) {
            callback.success(certAuthSuccess, alarmParam);
        }
    }

    private static void notifyAllCallback(CertAuthFail certAuthFail, String moUuid) {
        CertificateServerCallbackManager.writeCertAlarmLog(certAuthFail);
        if (VerifyUtil.isEmpty(callbackList)) {
            LOGGER.info((Object)"callbackList is empty.", 1L);
            return;
        }
        for (ICertificateServerCallback callback : callbackList) {
            try {
                CertificateServerCallbackManager.notifyCallback(certAuthFail, moUuid, callback);
            }
            catch (Exception e) {
                LOGGER.error((Object)("verify cert notify callback exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private static void writeCertAlarmLog(CertAuthFail certAuthFail) {
        int type = certAuthFail.getCertAuthFailType();
        switch (type) {
            case 1: {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Verify certificate fail,Certificate is invalid. Ip:%s.", certAuthFail.getIpAddress()));
                break;
            }
            case 2: {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Verify certificate fail,Certificate is not trusted. Ip:%s.", certAuthFail.getIpAddress()));
                break;
            }
            case 3: {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "The Certificate is expiring. Ip:%s.", certAuthFail.getIpAddress()));
                break;
            }
            default: {
                LOGGER.error((Object)("CertAuthFailType is invalid:" + type + ",IP:" + certAuthFail.getIpAddress()), 1L);
            }
        }
    }

    private static void notifyCallback(CertAuthFail certAuthFail, String moUuid, ICertificateServerCallback callback) {
        int type = certAuthFail.getCertAuthFailType();
        switch (type) {
            case 1: {
                callback.failForCertExpired(certAuthFail.getIpAddress(), moUuid);
                break;
            }
            case 2: {
                callback.failForCertNoTrust(certAuthFail.getIpAddress(), moUuid);
                break;
            }
            case 3: {
                callback.failForCertExpiring(certAuthFail.getIpAddress(), moUuid, certAuthFail.getExpiringDays());
                break;
            }
            default: {
                LOGGER.error((Object)("CertAuthFailType is invalid:" + type + ",IP:" + certAuthFail.getIpAddress()), 1L);
            }
        }
    }

    private static String getIdForRemoteSyslogServer(String ipAddress) {
        String sql;
        ICommonService commonService = ServiceProvider.getCommonService();
        List list = commonService.findBySql(sql = "select PROTOCALPROPS from ti_lognotifyserver", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (Object object : list) {
                if (!String.valueOf(object).contains(ipAddress)) continue;
                return "syslog" + ipAddress.replace(".", "");
            }
        }
        return null;
    }

    private static String getMoIdForRemoteServer(String ipAddress) {
        try {
            String sql = "select a.id from ManagementServer a where a.ip=?";
            Map<Integer, String> params = DaoParamUtil.hqlParams(ipAddress);
            List<?> list = DaoFactory.getInstance().getResourceDao().findByHql(sql, params);
            if (!VerifyUtil.isEmpty(list)) {
                return String.valueOf(list.get(0));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("get remote server service failue" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return null;
    }

    static {
        callbackList = new HashSet<ICertificateServerCallback>();
    }
}

