/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.SSLSocket;

public class ProtocolManager {
    private static final Log logger = LogFactory.getInstance(ProtocolManager.class);
    private static final String[] DEFAULT_CIPHERSUITES = new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};

    public static void resetEnabledProtocolsAndCipherSuites(SSLSocket sslSocket, String[] protocols) {
        if (null == sslSocket) {
            logger.error((Object)"sslSocket is null.");
            return;
        }
        Object[] enabledProtocols = sslSocket.getEnabledProtocols();
        logger.debug((Object)String.format(Locale.ENGLISH, "SslSocket protocol:%s,set protocols:%s.", Arrays.toString(enabledProtocols), Arrays.toString(protocols)));
        if (null != protocols && 0 < protocols.length) {
            sslSocket.setEnabledProtocols(protocols);
        }
        sslSocket.setEnabledCipherSuites(DEFAULT_CIPHERSUITES);
    }
}

