/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.container.support;

import com.huawei.lego.core.base.framework.container.IStructureHolder;
import com.huawei.lego.core.base.framework.rpc.MetadataInforCreator;
import com.huawei.lego.core.base.framework.rpc.metadata.MetadataCreatorFactory;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.IApplication;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.base.structure.ISystem;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ApplicationHolder
implements IStructureHolder<IApplication, AppInfo> {
    private static final Log LOGGER = LogFactory.getInstance(ApplicationHolder.class);
    private List<IApplication> applications = Collections.synchronizedList(new ArrayList());
    private ISystem system;

    public ApplicationHolder() {
    }

    public ApplicationHolder(ISystem system) {
        this.system = system;
    }

    @Override
    public List<IApplication> getHeldStructureEles() {
        return this.applications;
    }

    public void addApplication(IApplication app) {
        this.applications.add(app);
    }

    @Override
    public synchronized void free(IApplication app) {
        if (app instanceof ILifecycle) {
            ((ILifecycle)app).setCurrentStatus(Status.STATUS_STOPED);
        }
    }

    @Override
    public synchronized AppInfo hold(IApplication app) {
        AppInfo infor = null;
        MetadataInforCreator creator = MetadataCreatorFactory.getFactory().produceMetadataInforCreator(app);
        if (creator == null) {
            LOGGER.error((Object)"Creator is null!");
            return infor;
        }
        try {
            ((AbsApplication)app).setContainer(this.system);
            infor = (AppInfo)creator.createInfor(app);
            app.setAppInfor(infor);
            if (app instanceof ILifecycle) {
                ((ILifecycle)app).setCurrentStatus(Status.STATUS_READY);
            }
            this.applications.add(app);
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return infor;
    }

    @Override
    public Class getHeldStructureType() {
        return IApplication.class;
    }
}

