/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.registry;

import com.huawei.lego.core.sdk.base.AppStatus;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.model.ServiceType;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.DateFormatUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppStore {
    private static final String KEY_APP = "app";
    private static final String KEY_APP_NAME = "name";
    private static final String KEY_APP_VERSION = "version";
    private static final String KEY_APP_DESC = "desc";
    private static final String KEY_APP_BUNDLE_NAME = "bundlename";
    private static final String KEY_APP_CREATEDATE = "createdate";
    private static final String KEY_APP_IP = "ip";
    private static final String KEY_APP_PORT = "port";
    private static final String KEY_APP_STATUS = "status";
    private static final String KEY_SERVICE = "service";
    private static final String KEY_SERVICE_NAME = "name";
    private static final String KEY_SERVICE_INTERFACE = "interface";
    private static final String KEY_SERVICE_TYPE = "type";
    private static final Log LOGGER = LogFactory.getInstance(AppStore.class);
    private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ConcurrentHashMap<String, AppInfo> infos = new ConcurrentHashMap();

    public synchronized void add(AppInfo info) {
        if (null != info) {
            this.infos.put(info.getAppName(), info);
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "AppManager manage app infos : %s.", this.infos), 0L);
    }

    public synchronized void remove(String appName) {
        this.infos.remove(appName);
    }

    public synchronized AppInfo query(String appName) {
        return this.infos.get(appName);
    }

    public synchronized List<AppInfo> list() {
        ArrayList<AppInfo> apps = new ArrayList<AppInfo>();
        Set<Map.Entry<String, AppInfo>> entrySet = this.infos.entrySet();
        for (Map.Entry<String, AppInfo> entry : entrySet) {
            apps.add(this.infos.get(entry.getKey()));
        }
        return apps;
    }

    public synchronized void store(InputStream is) {
        AppXMLReader handler = new AppXMLReader();
        handler.parser(is);
    }

    class AppXMLReader
    extends DefaultHandler {
        private AppInfo app;
        private ServiceInfo service;

        AppXMLReader() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (AppStore.KEY_APP.equals(qName)) {
                this.app = new AppInfo();
                this.app.setAppName(attributes.getValue("name"));
                this.app.setVersion(attributes.getValue(AppStore.KEY_APP_VERSION));
                String createDate = attributes.getValue(AppStore.KEY_APP_CREATEDATE);
                try {
                    this.app.setCreateDate(DateFormatUtil.parse((DateFormat)AppStore.this.dateformat, (String)createDate));
                }
                catch (ParseException e) {
                    LOGGER.error((Object)"ERROR:", (Throwable)e, 0L);
                }
                this.app.setBundleName(attributes.getValue(AppStore.KEY_APP_BUNDLE_NAME));
                this.app.setDesc(attributes.getValue(AppStore.KEY_APP_DESC));
                this.app.setStatus(AppStatus.getAppStatus((int)NumberUtil.convertToInteger((Object)attributes.getValue(AppStore.KEY_APP_STATUS))));
                this.app.setIp(attributes.getValue(AppStore.KEY_APP_IP));
                this.app.setPort(NumberUtil.convertToInteger((Object)attributes.getValue(AppStore.KEY_APP_PORT)).intValue());
            } else if (AppStore.KEY_SERVICE.equals(qName)) {
                this.service = new ServiceInfo();
                this.service.setApp(this.app);
                this.service.setName(attributes.getValue("name"));
                this.service.setInterfaceName(attributes.getValue(AppStore.KEY_SERVICE_INTERFACE));
                this.service.setType(ServiceType.getAppStatus((int)NumberUtil.convertToInteger((Object)attributes.getValue(AppStore.KEY_SERVICE_TYPE))));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (AppStore.KEY_APP.equals(qName)) {
                AppStore.this.add(this.app);
            } else if (AppStore.KEY_SERVICE.equals(qName)) {
                this.app.addService(this.service);
            }
        }

        public void parser(InputStream is) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(true);
            try {
                CommonUtil.setSecurityFeatures((SAXParserFactory)factory);
                SAXParser parser = factory.newSAXParser();
                parser.parse(is, (DefaultHandler)this);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.error((Object)"Parse faile!", (Throwable)e, 0L);
            }
        }
    }
}

